/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestOffline;
import tech.carpentum.sdk.payment.model.OfflineMethod;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class OfflineMethodImpl
implements OfflineMethod {
    private final Optional<AccountPayinRequestOffline> account;
    private final Optional<String> paymentOperatorCode;
    private final Optional<String> emailAddress;
    private final Optional<String> productId;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<AccountPayinRequestOffline> getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public Optional<String> getProductId() {
        return this.productId;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private OfflineMethodImpl(BuilderImpl builder) {
        this.account = Optional.ofNullable(builder.account);
        this.paymentOperatorCode = Optional.ofNullable(builder.paymentOperatorCode);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.productId = Optional.ofNullable(builder.productId);
        this.hashCode = Objects.hash(this.account, this.paymentOperatorCode, this.emailAddress, this.productId);
        this.toString = builder.type + "(account=" + this.account + ", paymentOperatorCode=" + this.paymentOperatorCode + ", emailAddress=" + this.emailAddress + ", productId=" + this.productId + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfflineMethodImpl)) {
            return false;
        }
        OfflineMethodImpl that = (OfflineMethodImpl)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.paymentOperatorCode.equals(that.paymentOperatorCode)) {
            return false;
        }
        if (!this.emailAddress.equals(that.emailAddress)) {
            return false;
        }
        return this.productId.equals(that.productId);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements OfflineMethod.Builder {
        private AccountPayinRequestOffline account = null;
        private String paymentOperatorCode = null;
        private String emailAddress = null;
        private String productId = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("OfflineMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestOffline account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public BuilderImpl productId(String productId) {
            this.productId = productId;
            return this;
        }

        @Override
        public OfflineMethodImpl build() {
            return new OfflineMethodImpl(this);
        }
    }
}

