/*
 * Decompiled with CFR 0.152.
 */
package tech.beepbeep.beep_commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.beepbeep.beep_commons.util.Constants;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltech/beepbeep/beep_commons/util/Utils;", "", "()V", "Companion", "module-beep-commons"})
public final class Utils {
    @NotNull
    public static final String logName = "log.txt";
    public static final int TOTAL_LOG_MB = 20;
    public static final int NUM_LOG_FILES = 10;
    @NotNull
    public static final String CRASH_LOG_SUFFIX = "crash";
    @NotNull
    public static final String DEBUG_LOG_SUFFIX = "debug";
    @NotNull
    public static final String EVENTS_DIRECTORY_NAME = "events";
    @Nullable
    private static String beepPath;
    @Nullable
    private static String eventsPath;
    private static boolean isDebug;
    private static int numRecording;
    private static final Logger logger;
    private static final HashMap<String, ReentrantReadWriteLock> logFileLocks;
    private static boolean isSetLogPath;
    private static long CRASH_LOG_SIZE;
    private static long DEFAULT_EVENT_LOG_SIZE;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        isDebug = true;
        logger = Logger.getLogger("BeepSdk");
        logFileLocks = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)DEBUG_LOG_SUFFIX, (Object)new ReentrantReadWriteLock()), TuplesKt.to((Object)CRASH_LOG_SUFFIX, (Object)new ReentrantReadWriteLock())});
        CRASH_LOG_SIZE = 0x500000L;
        DEFAULT_EVENT_LOG_SIZE = 0x100000L;
    }

    public static final /* synthetic */ void access$setDEFAULT_EVENT_LOG_SIZE$cp(long l) {
        DEFAULT_EVENT_LOG_SIZE = l;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0003\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010+J\u000e\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\u0006J\u0010\u0010.\u001a\u0004\u0018\u00010\u00062\u0006\u0010/\u001a\u00020\u0006J\u0010\u00100\u001a\u0004\u0018\u00010\u001e2\u0006\u00101\u001a\u00020\u0006J\u0010\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u0006H\u0002J\u000e\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u0006J\u0016\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0016J\u0006\u00107\u001a\u00020&J \u00107\u001a\u00020&2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u001a\u0010<\u001a\u0004\u0018\u00010(2\u0006\u0010-\u001a\u00020\u00062\b\b\u0002\u0010=\u001a\u00020\u0004J\u000e\u0010>\u001a\u00020&2\u0006\u00101\u001a\u00020\u0006J\u0010\u0010?\u001a\u00020&2\b\u0010@\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001dj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Ltech/beepbeep/beep_commons/util/Utils$Companion;", "", "()V", "CRASH_LOG_SIZE", "", "CRASH_LOG_SUFFIX", "", "DEBUG_LOG_SUFFIX", "DEFAULT_EVENT_LOG_SIZE", "EVENTS_DIRECTORY_NAME", "NUM_LOG_FILES", "", "TOTAL_LOG_MB", "beepPath", "getBeepPath", "()Ljava/lang/String;", "setBeepPath", "(Ljava/lang/String;)V", "eventsPath", "getEventsPath", "setEventsPath", "value", "", "isDebug", "()Z", "setDebug", "(Z)V", "isSetLogPath", "logFileLocks", "Ljava/util/HashMap;", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "Lkotlin/collections/HashMap;", "logName", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "numRecording", "combineLog", "", "output", "Ljava/io/File;", "input", "numBytes", "(Ljava/io/File;Ljava/io/File;Ljava/lang/Long;)V", "deleteLogsOfType", "logTypeSuffix", "extractSuffix", "fileName", "getLock", "suffix", "getStringMsg", "msg", "printLog", "message", "isHttp", "recordCrash", "throwable", "", "tag", "threadName", "recordEvent", "size", "registerLogType", "storeLog", "path", "module-beep-commons"})
    public static final class Companion {
        @Nullable
        public final String getBeepPath() {
            return beepPath;
        }

        public final void setBeepPath(@Nullable String string) {
            beepPath = string;
        }

        @Nullable
        public final String getEventsPath() {
            return eventsPath;
        }

        public final void setEventsPath(@Nullable String string) {
            eventsPath = string;
        }

        public final boolean isDebug() {
            return isDebug;
        }

        public final void setDebug(boolean value) {
            CRASH_LOG_SIZE = value ? 0x500000L : 0x100000L;
            isDebug = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void registerLogType(@NotNull String suffix) {
            Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
            HashMap hashMap = logFileLocks;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (hashMap) {
                boolean bl3 = false;
                if (logFileLocks.get(suffix) == null) {
                    ((Map)logFileLocks).put(suffix, new ReentrantReadWriteLock());
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final ReentrantReadWriteLock getLock(@NotNull String suffix) {
            Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
            HashMap hashMap = logFileLocks;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (hashMap) {
                ReentrantReadWriteLock ret;
                block4: {
                    boolean bl3 = false;
                    ret = (ReentrantReadWriteLock)logFileLocks.get(suffix);
                    if (ret != null) break block4;
                    Companion.printLog("Log type suffix " + suffix + " is not registered");
                    ReentrantReadWriteLock reentrantReadWriteLock = null;
                    return reentrantReadWriteLock;
                }
                ReentrantReadWriteLock reentrantReadWriteLock = ret;
                return reentrantReadWriteLock;
            }
        }

        public final void printLog(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.printLog(this.getStringMsg(message), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void printLog(@NotNull String message, boolean isHttp) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            try {
                Logger logger = logger;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
                logger.setLevel(Level.INFO);
                Logger logger2 = logger;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
                logger2.setUseParentHandlers(true);
                boolean bl = false;
                boolean bl2 = false;
                synchronized (this) {
                    boolean bl3 = false;
                    if (numRecording > 0) {
                        return;
                    }
                    logger.info(message);
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (Exception e) {
                String string = "Print log error: " + e;
                boolean bl = false;
                System.out.println((Object)string);
            }
        }

        private final String getStringMsg(String msg) {
            String string;
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            StackTraceElement[] stackTrace = thread.getStackTrace();
            int index = stackTrace.length > 4 ? 4 : stackTrace.length - 1;
            StackTraceElement stackTraceElement = stackTrace[index];
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"stackTrace[index]");
            String className = stackTraceElement.getFileName();
            StackTraceElement stackTraceElement2 = stackTrace[index];
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement2, (String)"stackTrace[index]");
            String methodName = stackTraceElement2.getMethodName();
            StackTraceElement stackTraceElement3 = stackTrace[index];
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement3, (String)"stackTrace[index]");
            int lineNumber = stackTraceElement3.getLineNumber();
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = methodName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"methodName");
            String string3 = string2;
            int n = 0;
            int n2 = 1;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string = string5;
            n = 0;
            String string6 = string3;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toUpperCase()");
            string = string7;
            string3 = methodName;
            n = 1;
            stringBuilder2 = stringBuilder2.append(string);
            n2 = 0;
            String string8 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
            string = string8;
            methodName = stringBuilder2.append(string).toString();
            StringBuilder stringBuilder3 = new StringBuilder();
            StringBuilder stringBuilder4 = stringBuilder3.append("[ (").append(className).append(":").append(lineNumber).append(")#").append(methodName).append("-");
            StringBuilder stringBuilder5 = new StringBuilder().append("{");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"Thread.currentThread()");
            stringBuilder4.append(stringBuilder5.append(thread2.getName()).append("}").toString()).append(" ] ");
            stringBuilder3.append(msg);
            String string9 = stringBuilder3.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"stringBuilder.toString()");
            return string9;
        }

        public final void recordCrash() {
            this.recordEvent(Utils.CRASH_LOG_SUFFIX, CRASH_LOG_SIZE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Nullable
        public final File recordEvent(@NotNull String logTypeSuffix, long size) {
            Intrinsics.checkParameterIsNotNull((Object)logTypeSuffix, (String)"logTypeSuffix");
            if (size <= 0L) {
                this.printLog("Invalid size " + size + " passed for recordEvent");
                return null;
            }
            CharSequence charSequence = this.getEventsPath();
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                this.printLog("Did not set log path~~~so can not upload log...");
                return null;
            }
            String fileName = String.valueOf(System.currentTimeMillis()) + "_" + logTypeSuffix;
            ReentrantReadWriteLock reentrantReadWriteLock = this.getLock(logTypeSuffix);
            if (reentrantReadWriteLock != null) {
                int n;
                int n2;
                ReentrantReadWriteLock reentrantReadWriteLock2 = reentrantReadWriteLock;
                bl2 = false;
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock2.readLock();
                int n3 = reentrantReadWriteLock2.getWriteHoldCount() == 0 ? reentrantReadWriteLock2.getReadHoldCount() : 0;
                boolean bl3 = false;
                int n4 = 0;
                n4 = 0;
                int n5 = n3;
                while (n4 < n5) {
                    n2 = n4++;
                    n = 0;
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock2.writeLock();
                writeLock.lock();
                try {
                    int n6;
                    boolean bl4 = false;
                    Companion companion = Companion;
                    boolean bl5 = false;
                    int n7 = 0;
                    synchronized (companion) {
                        boolean bl6 = false;
                        n6 = numRecording;
                        numRecording = n6 + 1;
                        n7 = n6;
                    }
                    File mergedFile = new File(Companion.getEventsPath(), fileName);
                    if (mergedFile.exists()) {
                        mergedFile.delete();
                    }
                    n7 = 10;
                    Long[] longArray = new Long[n7];
                    n6 = 0;
                    while (n6 < n7) {
                        Long l;
                        int n8 = n6;
                        int n9 = n6++;
                        Long[] longArray2 = longArray;
                        boolean bl7 = false;
                        longArray2[n9] = l = Long.valueOf(0L);
                    }
                    Long[] numBytesRead = longArray;
                    Companion companion2 = Companion;
                    boolean bl8 = false;
                    n6 = 0;
                    Companion $this$run = companion2;
                    boolean bl9 = false;
                    long totalBytes = 0L;
                    int n10 = 0;
                    int n11 = 10;
                    while (n10 < n11) {
                        void i;
                        File file = new File($this$run.getBeepPath(), "log.txt." + (int)i);
                        numBytesRead[i] = file.exists() ? RangesKt.coerceIn((long)file.length(), (long)0L, (long)(size - totalBytes)) : 0L;
                        totalBytes += numBytesRead[i].longValue();
                        ++i;
                    }
                    int n12 = 10;
                    --n12;
                    bl8 = false;
                    while (n12 >= 0) {
                        void i;
                        if (numBytesRead[i] > 0L) {
                            File file = new File(Companion.getBeepPath(), "log.txt." + (int)i);
                            Companion.combineLog(mergedFile, file, numBytesRead[i]);
                        }
                        --i;
                    }
                    Companion companion3 = Companion;
                    bl8 = false;
                    n6 = 0;
                    synchronized (companion3) {
                        boolean bl10 = false;
                        int n13 = numRecording;
                        numRecording = n13 + -1;
                        n6 = n13;
                    }
                    File file = mergedFile;
                    return file;
                }
                finally {
                    n5 = 0;
                    n2 = 0;
                    n2 = 0;
                    n = n3;
                    while (n2 < n) {
                        int n14 = n2++;
                        boolean bl11 = false;
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
            }
            return null;
        }

        public static /* synthetic */ File recordEvent$default(Companion companion, String string, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = DEFAULT_EVENT_LOG_SIZE;
            }
            return companion.recordEvent(string, l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final String extractSuffix(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            Object object = new String[]{"_"};
            int n = 2;
            boolean bl = false;
            List substrings = StringsKt.split((CharSequence)fileName, (String[])object, (boolean)bl, (int)n);
            if (substrings.size() != 2) {
                this.printLog("Filename " + fileName + " is invalid");
                return null;
            }
            object = logFileLocks;
            n = 0;
            bl = false;
            synchronized (object) {
                String suffix;
                block5: {
                    boolean bl2 = false;
                    suffix = (String)substrings.get(1);
                    if (logFileLocks.keySet().contains(suffix)) break block5;
                    Companion.printLog("Filename " + fileName + " is invalid");
                    String string = null;
                    return string;
                }
                String string = suffix;
                return string;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void deleteLogsOfType(@NotNull String logTypeSuffix) {
            Intrinsics.checkParameterIsNotNull((Object)logTypeSuffix, (String)"logTypeSuffix");
            ReentrantReadWriteLock reentrantReadWriteLock = this.getLock(logTypeSuffix);
            if (reentrantReadWriteLock != null) {
                int n;
                int n2;
                ReentrantReadWriteLock reentrantReadWriteLock2 = reentrantReadWriteLock;
                boolean bl = false;
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock2.readLock();
                int n3 = reentrantReadWriteLock2.getWriteHoldCount() == 0 ? reentrantReadWriteLock2.getReadHoldCount() : 0;
                boolean bl2 = false;
                int n4 = 0;
                n4 = 0;
                int n5 = n3;
                while (n4 < n5) {
                    n2 = n4++;
                    n = 0;
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock2.writeLock();
                writeLock.lock();
                try {
                    Unit unit;
                    File[] files;
                    boolean bl3 = false;
                    String string = Companion.getEventsPath();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    File eventsDirectory = new File(string);
                    if (files != null) {
                        File[] $this$forEach$iv = files = eventsDirectory.listFiles(new FilenameFilter(logTypeSuffix){
                            final /* synthetic */ String $logTypeSuffix$inlined;
                            {
                                this.$logTypeSuffix$inlined = string;
                            }

                            public final boolean accept(File $noName_0, String name) {
                                String string = name;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                                return StringsKt.contains$default((CharSequence)string, (CharSequence)this.$logTypeSuffix$inlined, (boolean)false, (int)2, null);
                            }
                        });
                        boolean $i$f$forEach = false;
                        File[] fileArray = $this$forEach$iv;
                        int n6 = fileArray.length;
                        for (int i = 0; i < n6; ++i) {
                            File element$iv;
                            File it = element$iv = fileArray[i];
                            boolean bl4 = false;
                            it.delete();
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                finally {
                    n5 = 0;
                    n2 = 0;
                    n2 = 0;
                    n = n3;
                    while (n2 < n) {
                        int n7 = n2++;
                        boolean bl5 = false;
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
            }
        }

        public final void recordCrash(@Nullable Throwable throwable, @NotNull String tag, @NotNull String threadName) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)threadName, (String)"threadName");
            CharSequence charSequence = this.getBeepPath();
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                this.printLog("Did not set log path~~~so can not upload log...");
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                Throwable throwable2 = throwable;
                if (throwable2 != null) {
                    throwable2.printStackTrace(pw);
                }
                this.printLog(tag + ": Received uncaught exception in thread " + threadName + " with cause\n" + sw);
                Throwable throwable3 = throwable;
                if (throwable3 != null) {
                    throwable3.printStackTrace();
                }
                this.recordCrash();
            }
        }

        private final void combineLog(File output, File input, Long numBytes) {
            long numBytesToSkip;
            long l;
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(output, true);
            FileInputStream fileInputStream = new FileInputStream(input);
            Long l2 = numBytes;
            if (l2 != null) {
                Long l3 = l2;
                boolean bl = false;
                n = 0;
                long it = ((Number)l3).longValue();
                boolean bl2 = false;
                l = input.length() - it;
            } else {
                l = numBytesToSkip = 0L;
            }
            while (numBytesToSkip > 0L) {
                numBytesToSkip -= fileInputStream.skip(numBytesToSkip);
            }
            byte[] byArray = new byte[1024];
            Ref.IntRef length = new Ref.IntRef();
            while (true) {
                n = fileInputStream.read(byArray);
                boolean bl = false;
                boolean bl3 = false;
                int it = n;
                boolean bl4 = false;
                length.element = it;
                if (n == -1) break;
                fileOutputStream.write(byArray, 0, length.element);
            }
            fileInputStream.close();
        }

        static /* synthetic */ void combineLog$default(Companion companion, File file, File file2, Long l, int n, Object object) {
            if ((n & 4) != 0) {
                l = null;
            }
            companion.combineLog(file, file2, l);
        }

        public final void storeLog(@Nullable String path) {
            if (isSetLogPath) {
                this.printLog("Already set log path!!! no need to set again.");
                return;
            }
            isSetLogPath = true;
            try {
                CharSequence charSequence = path;
                Companion companion = this;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
                companion.setBeepPath(!bl3 ? path + File.separator + "beep" : "./beep");
                String string = this.getBeepPath();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Constants.Companion.setBEEP_PATH(string);
                File file = new File(this.getBeepPath());
                if (!file.exists() && !file.mkdirs()) {
                    this.printLog("Failed to create beep directory " + this.getBeepPath());
                    return;
                }
                this.setEventsPath(this.getBeepPath() + File.separator + Utils.EVENTS_DIRECTORY_NAME);
                File eventsDirectory = new File(this.getEventsPath());
                if (!eventsDirectory.exists() && !eventsDirectory.mkdir()) {
                    this.printLog("Failed to create events directory " + eventsDirectory);
                    return;
                }
                FileHandler fileHandler = new FileHandler(this.getBeepPath() + File.separator + Utils.logName, 2048000, 10, true);
                fileHandler.setFormatter(new SimpleFormatter(){
                    private final String format = "%1$tb|%1$td|%1$ty|%1$tH:%1$tM:%1$tS:%1$tL %2$s: %3$s%4$s%n";
                    private final Date dat;

                    @NotNull
                    public String format(@Nullable LogRecord record) {
                        LogRecord logRecord = record;
                        if (logRecord == null) {
                            Intrinsics.throwNpe();
                        }
                        this.dat.setTime(logRecord.getMillis());
                        String message = this.formatMessage(record);
                        String throwable = "";
                        if (record.getThrown() != null) {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            pw.println();
                            record.getThrown().printStackTrace(pw);
                            pw.close();
                            String string = sw.toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sw.toString()");
                            throwable = string;
                        }
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = this.format;
                        Object[] objectArray = new Object[4];
                        objectArray[0] = this.dat;
                        Level level = record.getLevel();
                        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"record.level");
                        objectArray[1] = level.getLocalizedName();
                        objectArray[2] = message;
                        objectArray[3] = throwable;
                        Object[] objectArray2 = objectArray;
                        boolean bl = false;
                        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                        return string2;
                    }
                    {
                        this.format = "%1$tb|%1$td|%1$ty|%1$tH:%1$tM:%1$tS:%1$tL %2$s: %3$s%4$s%n";
                        this.dat = new Date();
                    }
                });
                logger.addHandler(fileHandler);
            }
            catch (Exception e) {
                String string = "Set log path error~~~ Cannot save Log" + e;
                boolean bl = false;
                System.out.println((Object)string);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

