/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.banana.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import tech.aroma.banana.client.Banana;
import tech.aroma.banana.client.BananaClient;
import tech.aroma.banana.client.Urgency;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.annotations.concurrency.Immutable;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Immutable
@Internal
final class RequestImpl
implements Banana.Request {
    private static final Logger LOG = LoggerFactory.getLogger(RequestImpl.class);
    private final BananaClient bananaClient;
    private final Urgency urgency;
    private final String title;
    private final String text;

    RequestImpl(@Required BananaClient bananaClient, @Required String title, @Required String text, @Required Urgency urgency) {
        Arguments.checkThat((Object)bananaClient, (Object[])new Object[]{title, text, urgency}).are(Assertions.notNull());
        this.bananaClient = bananaClient;
        this.title = title;
        this.text = text;
        this.urgency = urgency;
    }

    @Override
    public Banana.Request titled(String title) {
        Arguments.checkThat((Object)title).usingMessage("title cannot be empty").is(StringAssertions.nonEmptyString()).usingMessage("title too short").is(StringAssertions.stringWithLengthGreaterThanOrEqualTo((int)3)).usingMessage("title too long").is(StringAssertions.stringWithLengthLessThan((int)40));
        return new RequestImpl(this.bananaClient, title, this.text, this.urgency);
    }

    @Override
    public Banana.Request text(String message, Object ... args) {
        Arguments.checkThat((Object)message).usingMessage("message cannot be null").is(Assertions.notNull());
        String combinedMessage = this.combineStringAndArgs(message, args);
        return new RequestImpl(this.bananaClient, this.title, combinedMessage, this.urgency);
    }

    private String combineStringAndArgs(String message, Object ... args) {
        if (args == null || args.length == 0) {
            return message;
        }
        FormattingTuple arrayFormat = MessageFormatter.arrayFormat((String)message, (Object[])args);
        String formattedMessage = arrayFormat.getMessage();
        Throwable ex = arrayFormat.getThrowable();
        if (ex == null) {
            return formattedMessage;
        }
        return String.format("%s\n%s", formattedMessage, this.printThrowable(ex));
    }

    /*
     * Exception decompiling
     */
    private String printThrowable(Throwable ex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Banana.Request withUrgency(@Required Urgency level) throws IllegalArgumentException {
        Arguments.checkThat((Object)((Object)level)).usingMessage("urgency cannot be null").is(Assertions.notNull());
        return new RequestImpl(this.bananaClient, this.title, this.text, level);
    }

    @Override
    public void send() throws IllegalArgumentException {
        this.bananaClient.sendMessage(this);
    }

    @Internal
    String getText() {
        return this.text;
    }

    @Internal
    String getTitle() {
        return this.title;
    }

    @Internal
    Urgency getUrgency() {
        return this.urgency;
    }

    public String toString() {
        return "RequestImpl{bananaClient=" + this.bananaClient + ", urgency=" + (Object)((Object)this.urgency) + ", title=" + this.title + ", text=" + this.text + '}';
    }
}

