/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.tapestry.annotations.AnnotationLocation;
import org.apache.tapestry.annotations.AnnotationMessages;
import org.apache.tapestry.annotations.ClassAnnotationEnhancementWorker;
import org.apache.tapestry.annotations.MethodAnnotationEnhancementWorker;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.spec.IComponentSpecification;

public class AnnotationEnhancementWorker
implements EnhancementWorker {
    private ClassResolver _classResolver;
    private ErrorLog _errorLog;
    private Map _methodWorkers;
    private Map _classWorkers;

    public void setClassWorkers(Map classWorkers) {
        this._classWorkers = classWorkers;
    }

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        Class clazz = op.getBaseClass();
        ClasspathResource classResource = this.newClassResource(clazz);
        for (Annotation a : clazz.getAnnotations()) {
            this.performClassEnhancement(op, spec, clazz, a, (Resource)classResource);
        }
        for (Method m : clazz.getMethods()) {
            this.performMethodEnhancement(op, spec, m, (Resource)classResource);
        }
    }

    private ClasspathResource newClassResource(Class clazz) {
        return new ClasspathResource(this._classResolver, clazz.getName().replace('.', '/'));
    }

    void performClassEnhancement(EnhancementOperation op, IComponentSpecification spec, Class clazz, Annotation annotation, Resource classResource) {
        ClassAnnotationEnhancementWorker worker = (ClassAnnotationEnhancementWorker)this._classWorkers.get(annotation.annotationType());
        if (worker == null) {
            return;
        }
        try {
            AnnotationLocation location = new AnnotationLocation(classResource, AnnotationMessages.classAnnotation(annotation, clazz));
            worker.performEnhancement(op, spec, clazz, location);
        }
        catch (Exception ex) {
            this._errorLog.error(AnnotationMessages.failureProcessingClassAnnotation(annotation, clazz, ex), null, (Throwable)ex);
        }
    }

    void performMethodEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method, Resource classResource) {
        for (Annotation a : method.getAnnotations()) {
            this.performMethodEnhancement(op, spec, method, a, classResource);
        }
    }

    void performMethodEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method, Annotation annotation, Resource classResource) {
        MethodAnnotationEnhancementWorker worker = (MethodAnnotationEnhancementWorker)this._methodWorkers.get(annotation.annotationType());
        if (worker == null) {
            return;
        }
        try {
            AnnotationLocation location = new AnnotationLocation(classResource, AnnotationMessages.methodAnnotation(annotation, method));
            worker.performEnhancement(op, spec, method, location);
        }
        catch (Exception ex) {
            this._errorLog.error(AnnotationMessages.failureProcessingAnnotation(annotation, method, ex), null, (Throwable)ex);
        }
    }

    public void setMethodWorkers(Map methodWorkers) {
        this._methodWorkers = methodWorkers;
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }

    public void setClassResolver(ClassResolver classResolver) {
        this._classResolver = classResolver;
    }
}

