/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.measure.spi.SystemOfUnits;
import systems.uom.common.Imperial;
import systems.uom.common.USCustomary;
import systems.uom.common.historic.CGS;
import systems.uom.common.historic.MKpS;
import systems.uom.common.historic.ObsoleteUnits;
import tech.units.indriya.spi.AbstractSystemOfUnitsService;

public class CommonSystemService
extends AbstractSystemOfUnitsService {
    private static final String US_SYSTEM_NAME = "USCustomary";
    private static final String CGS_KEY = "CGS";
    private static final String MKPS_KEY = "MKpS";
    private static final String OBS_KEY = "ObsoleteUnits";
    private final Map<String, String> aliases = new HashMap<String, String>();

    public CommonSystemService() {
        this.souMap.put("Imperial", Imperial.getInstance());
        this.souMap.put(US_SYSTEM_NAME, USCustomary.getInstance());
        this.souMap.put(CGS_KEY, CGS.getInstance());
        this.souMap.put(MKPS_KEY, MKpS.getInstance());
        this.souMap.put(OBS_KEY, ObsoleteUnits.getInstance());
        this.aliases.put("US", US_SYSTEM_NAME);
        this.aliases.put("UK", "Imperial");
        this.aliases.put("Centimetre\u2013gram\u2013second", CGS_KEY);
        this.aliases.put("Gravitational metric system", MKPS_KEY);
        this.aliases.put("MKfS", MKPS_KEY);
        this.aliases.put("Obsolete", OBS_KEY);
    }

    public Collection<SystemOfUnits> getAvailableSystemsOfUnits() {
        return this.souMap.values();
    }

    public SystemOfUnits getSystemOfUnits() {
        return this.getSystemOfUnits(US_SYSTEM_NAME);
    }

    public SystemOfUnits getSystemOfUnits(String name) {
        String alias = this.aliases.get(name);
        if (alias != null && alias.length() > 0) {
            return (SystemOfUnits)this.souMap.get(alias);
        }
        return (SystemOfUnits)this.souMap.get(name);
    }
}

