/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.SystemOfUnits;
import systems.uom.common.NonSI;
import systems.uom.quantity.Information;
import tec.units.ri.AbstractSystemOfUnits;
import tec.units.ri.AbstractUnit;
import tec.units.ri.format.SimpleUnitFormat;
import tec.units.ri.function.RationalConverter;
import tec.units.ri.unit.MetricPrefix;
import tec.units.ri.unit.ProductUnit;
import tec.units.ri.unit.TransformedUnit;
import tec.units.ri.unit.Units;

public final class USCustomary
extends AbstractSystemOfUnits {
    private static final String SYSTEM_NAME = "United State Customary Units";
    private static final USCustomary INSTANCE = new USCustomary();
    public static final Unit<Length> METER = Units.METRE;
    public static final Unit<Length> FOOT = USCustomary.addUnit(METER.multiply(3048.0).divide(10000.0));
    public static final Unit<Length> FOOT_SURVEY = USCustomary.addUnit(METER.multiply(1200.0).divide(3937.0));
    public static final Unit<Length> YARD = USCustomary.addUnit(FOOT.multiply(3.0));
    public static final Unit<Length> INCH = USCustomary.addUnit(FOOT.divide(12.0));
    public static final Unit<Length> MILE = USCustomary.addUnit(METER.multiply(1609344.0).divide(1000.0));
    public static final Unit<Length> LIGHT_YEAR = USCustomary.addUnit(Units.METRE.multiply(9.460528405E15));
    public static final Unit<Length> NAUTICAL_MILE = USCustomary.addUnit(METER.multiply(1852.0));
    static final Unit<Length> POINT = USCustomary.addUnit(INCH.multiply(13837.0).divide(1000000.0));
    static final Unit<Length> PIXEL = USCustomary.addUnit(INCH.divide(72.0));
    public static final Unit<Mass> POUND = USCustomary.addUnit(Units.KILOGRAM.multiply(4.5359237E7).divide(1.0E8));
    public static final Unit<Mass> OUNCE = USCustomary.addUnit(POUND.divide(16.0));
    public static final Unit<Mass> TON = USCustomary.addUnit(POUND.multiply(2000.0));
    public static final Unit<Temperature> RANKINE = USCustomary.addUnit(Units.KELVIN.multiply(5.0).divide(9.0));
    public static final Unit<Temperature> FAHRENHEIT = USCustomary.addUnit(RANKINE.shift(459.67));
    public static final Unit<Angle> REVOLUTION = USCustomary.addUnit(Units.RADIAN.multiply(2.0).multiply(Math.PI).asType(Angle.class));
    public static final Unit<Angle> DEGREE_ANGLE = USCustomary.addUnit(REVOLUTION.divide(360.0));
    public static final Unit<Angle> MINUTE_ANGLE = USCustomary.addUnit(DEGREE_ANGLE.divide(60.0));
    public static final Unit<Angle> SECOND_ANGLE = USCustomary.addUnit(MINUTE_ANGLE.divide(60.0));
    public static final Unit<Angle> CENTIRADIAN = USCustomary.addUnit(Units.RADIAN.divide(100.0));
    public static final Unit<Angle> GRADE = USCustomary.addUnit(REVOLUTION.divide(400.0));
    public static final Unit<Time> MINUTE = USCustomary.addUnit(Units.SECOND.multiply(60.0));
    public static final Unit<Time> HOUR = USCustomary.addUnit(MINUTE.multiply(60.0));
    public static final Unit<Speed> FEET_PER_SECOND = USCustomary.addUnit(FOOT.divide(Units.SECOND)).asType(Speed.class);
    public static final Unit<Speed> MILES_PER_HOUR = USCustomary.addUnit(MILE.divide(HOUR)).asType(Speed.class);
    public static final Unit<Speed> KNOT = USCustomary.addUnit(NAUTICAL_MILE.divide(HOUR)).asType(Speed.class);
    public static final Unit<Area> SQUARE_FOOT = USCustomary.addUnit(new ProductUnit((Unit)((AbstractUnit)FOOT.multiply(FOOT))));
    public static final Unit<Area> ARE = USCustomary.addUnit(Units.SQUARE_METRE.multiply(100.0));
    public static final Unit<Area> HECTARE = USCustomary.addUnit(ARE.multiply(100.0));
    public static final Unit<Area> ACRE = USCustomary.addUnit(SQUARE_FOOT.multiply(43560.0));
    public static final Unit<Information> BIT = USCustomary.addUnit(NonSI.BIT);
    public static final Unit<Information> BYTE = USCustomary.addUnit(BIT.multiply(8.0));
    public static final Unit<Information> OCTET = BYTE;
    public static final Unit<Energy> ELECTRON_VOLT = USCustomary.addUnit(Units.JOULE.multiply(1.602176462E-19));
    public static final Unit<Power> HORSEPOWER = USCustomary.addUnit(Units.WATT.multiply(735.499));
    public static final TransformedUnit<Volume> LITER = new TransformedUnit(Units.CUBIC_METRE, (UnitConverter)new RationalConverter(1.0, 1000.0));
    public static final Unit<Volume> CUBIC_INCH = USCustomary.addUnit(INCH.pow(3).asType(Volume.class));
    public static final Unit<Volume> CUBIC_FOOT = USCustomary.addUnit(CUBIC_INCH.multiply(1728.0));
    public static final Unit<Volume> ACRE_FOOT = USCustomary.addUnit(CUBIC_FOOT.multiply(43560.0));
    public static final Unit<Volume> GALLON_DRY = USCustomary.addUnit(CUBIC_INCH.multiply(2688025.0).divide(10000.0));
    public static final Unit<Volume> GALLON_LIQUID = USCustomary.addUnit(CUBIC_INCH.multiply(231.0));
    public static final Unit<Volume> FLUID_OUNCE = USCustomary.addUnit(GALLON_LIQUID.divide(128.0));
    public static final Unit<Volume> GILL_LIQUID = USCustomary.addUnit(FLUID_OUNCE.multiply(4.0));
    public static final Unit<Volume> MINIM = USCustomary.addUnit(MetricPrefix.MICRO(LITER).multiply(61.61152));
    public static final Unit<Volume> FLUID_DRAM = USCustomary.addUnit(MINIM.multiply(60.0));
    public static final Unit<Volume> CUP = USCustomary.addUnit(FLUID_OUNCE.multiply(8.0));
    public static final Unit<Volume> TEASPOON = USCustomary.addUnit(MINIM.multiply(80.0));
    public static final Unit<Volume> TABLESPOON = USCustomary.addUnit(TEASPOON.multiply(3.0));
    public static final Unit<Volume> BARREL = USCustomary.addUnit(LITER.multiply(238.481));
    public static final Unit<Volume> PINT = USCustomary.addUnit(GILL_LIQUID.multiply(4.0));

    private USCustomary() {
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    protected static <U extends Unit<?>> U addUnit(U unit) {
        USCustomary.INSTANCE.units.add(unit);
        return unit;
    }

    public String getName() {
        return SYSTEM_NAME;
    }

    static {
        SimpleUnitFormat.getInstance().label(POUND, "lb");
        SimpleUnitFormat.getInstance().label(LITER, "L");
        SimpleUnitFormat.getInstance().label(FLUID_OUNCE, "fl oz");
        SimpleUnitFormat.getInstance().label(KNOT, "kn");
        SimpleUnitFormat.getInstance().label(MILES_PER_HOUR, "mph");
    }
}

