/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.definitions;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.api.fs.IResource;
import manifold.preprocessor.definitions.EnvironmentDefinitions;
import manifold.preprocessor.definitions.ServiceDefinitions;
import manifold.util.concurrent.LocklessLazyVar;

public class Definitions {
    public static final String BUILD_PROPERTIES = "build.properties";
    private final IFile _definitionsSource;
    private final LocklessLazyVar<Definitions> _parent;
    private final Map<String, String> _localDefs;
    private final Map<String, String> _localUnDefs;

    public Definitions(IFile definitionsSource) {
        this(definitionsSource, null);
    }

    protected Definitions(IFile definitionsSource, Map<String, String> definitions) {
        this._definitionsSource = definitionsSource;
        this._parent = LocklessLazyVar.make(() -> this.loadParentDefinitions());
        this._localDefs = definitions == null ? new HashMap() : definitions;
        this._localUnDefs = new HashMap<String, String>();
    }

    protected IFile getSourceFile() {
        return this._definitionsSource;
    }

    protected Definitions getParent() {
        return (Definitions)this._parent.get();
    }

    protected Definitions loadParentDefinitions() {
        IFile source;
        Definitions parentDefinitions = null;
        if (this._definitionsSource != null && (source = this._definitionsSource).exists()) {
            parentDefinitions = this.findBuildProperties((IResource)source);
        }
        if (parentDefinitions == null) {
            parentDefinitions = new Definitions(null, this.loadEnvironmentDefinitions()){

                @Override
                protected Definitions loadParentDefinitions() {
                    return new ServiceDefinitions(Definitions.this);
                }
            };
        }
        return parentDefinitions;
    }

    protected Map<String, String> loadEnvironmentDefinitions() {
        return EnvironmentDefinitions.instance().getEnv();
    }

    private Definitions findBuildProperties(IResource source) {
        if (source == null) {
            return null;
        }
        if (source instanceof IFile && source.exists()) {
            if (source.getName().equalsIgnoreCase(BUILD_PROPERTIES)) {
                source = source.getParent();
            }
            if ((source = source.getParent()) == null) {
                return null;
            }
        }
        if (((IDirectory)source).hasChildFile(BUILD_PROPERTIES)) {
            return this.makeBuildDefinitions(((IDirectory)source).file(BUILD_PROPERTIES));
        }
        return this.findBuildProperties((IResource)source.getParent());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Definitions makeBuildDefinitions(IFile source) {
        Properties properties = new Properties();
        try (InputStream input = source.openInputStream();){
            properties.load(input);
            Definitions definitions = new Definitions(source, properties);
            return definitions;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this._localDefs.clear();
        this._localUnDefs.clear();
    }

    public boolean isDefined(String def) {
        if (this._localUnDefs.containsKey(def)) {
            return false;
        }
        if (this._localDefs.containsKey(def)) {
            return true;
        }
        Definitions parent = this.getParent();
        return parent != null && parent.isDefined(def);
    }

    public String getValue(String def) {
        if (this._localUnDefs.containsKey(def)) {
            return null;
        }
        if (this._localDefs.containsKey(def)) {
            return this._localDefs.get(def);
        }
        Definitions parent = this.getParent();
        return parent == null ? null : parent.getValue(def);
    }

    public String define(String def) {
        return this.define(def, "");
    }

    public String define(String def, String value) {
        this._localUnDefs.remove(def);
        return this._localDefs.put(def, value);
    }

    public String undef(String def) {
        this._localUnDefs.put(def, "");
        return this._localDefs.remove(def);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Definitions that = (Definitions)o;
        return this._localDefs.equals(that._localDefs) && this._localUnDefs.equals(that._localUnDefs);
    }

    public int hashCode() {
        return Objects.hash(this._localDefs, this._localUnDefs);
    }
}

