/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra.loadbalancing;

import com.datastax.driver.core.policies.ErrorAwarePolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.util.Duration;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import systems.composable.dropwizard.cassandra.loadbalancing.LoadBalancingPolicyFactory;

@JsonTypeName(value="errorAware")
public class ErrorAwarePolicyFactory
implements LoadBalancingPolicyFactory {
    @Valid
    @NotNull
    private LoadBalancingPolicyFactory subPolicy;
    private Integer maxErrorsPerMinute;
    private Duration retryPeriod;

    @JsonProperty
    public LoadBalancingPolicyFactory getSubPolicy() {
        return this.subPolicy;
    }

    @JsonProperty
    public void setSubPolicy(LoadBalancingPolicyFactory subPolicy) {
        this.subPolicy = subPolicy;
    }

    @JsonProperty
    public Integer getMaxErrorsPerMinute() {
        return this.maxErrorsPerMinute;
    }

    @JsonProperty
    public void setMaxErrorsPerMinute(Integer maxErrorsPerMinute) {
        this.maxErrorsPerMinute = maxErrorsPerMinute;
    }

    @JsonProperty
    public Duration getRetryPeriod() {
        return this.retryPeriod;
    }

    @JsonProperty
    public void setRetryPeriod(Duration retryPeriod) {
        this.retryPeriod = retryPeriod;
    }

    @Override
    public LoadBalancingPolicy build() {
        ErrorAwarePolicy.Builder builder = ErrorAwarePolicy.builder((LoadBalancingPolicy)this.subPolicy.build());
        if (this.maxErrorsPerMinute != null) {
            builder.withMaxErrorsPerMinute(this.maxErrorsPerMinute.intValue());
        }
        if (this.retryPeriod != null) {
            builder.withRetryPeriod(this.retryPeriod.getQuantity(), this.retryPeriod.getUnit());
        }
        return builder.build();
    }
}

