/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.util.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraManager
implements Managed {
    private final Logger LOG = LoggerFactory.getLogger(CassandraManager.class);
    private final Cluster cluster;
    private final Duration shutdownGracePeriod;

    public CassandraManager(Cluster cluster, Duration shutdownGracePeriod) {
        this.cluster = cluster;
        this.shutdownGracePeriod = shutdownGracePeriod;
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.LOG.debug("Attempting graceful shutdown of Cassandra cluster: {}", (Object)this.cluster.getClusterName());
        CloseFuture future = this.cluster.closeAsync();
        try {
            future.get(this.shutdownGracePeriod.toMilliseconds(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.LOG.warn("Cassandra cluster did not close in {}. Forcing it now.", (Object)this.shutdownGracePeriod);
            future.force();
        }
    }
}

