/*
 * Decompiled with CFR 0.152.
 */
package studio.crud.crudframework.utils.component.componentmap;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.TargetClassAware;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import studio.crud.crudframework.utils.component.componentmap.ComponentMapIdentifier;
import studio.crud.crudframework.utils.component.componentmap.ComponentMapPostProcessorKt;
import studio.crud.crudframework.utils.component.componentmap.annotation.ComponentMap;
import studio.crud.crudframework.utils.component.componentmap.annotation.ComponentMapKey;
import studio.crud.crudframework.utils.component.componentmap.model.SingletonComponentMap;
import studio.crud.crudframework.utils.utils.FieldUtils;
import studio.crud.crudframework.utils.utils.ParameterLock;
import studio.crud.crudframework.utils.utils.ReflectionUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J2\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J\u001a\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002R,\u0010\u0003\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lstudio/crud/crudframework/utils/component/componentmap/ComponentMapPostProcessor;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "()V", "componentMaps", "", "Lstudio/crud/crudframework/utils/component/componentmap/ComponentMapIdentifier;", "", "", "fillComponentMapIfExists", "", "bean", "getOrCreateComponentMap", "initialKeyType", "Ljava/lang/Class;", "initialValueType", "postProcessAfterInitialization", "beanName", "", "registerComponentMapKeyIfExists", "crud-framework-utils"})
public final class ComponentMapPostProcessor
implements BeanPostProcessor {
    @NotNull
    private final Map<ComponentMapIdentifier, Map<Object, List<Object>>> componentMaps = new LinkedHashMap();

    @NotNull
    public Object postProcessAfterInitialization(@NotNull Object bean, @Nullable String beanName) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        try {
            this.registerComponentMapKeyIfExists(bean);
            this.fillComponentMapIfExists(bean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bean;
    }

    private final void fillComponentMapIfExists(Object bean) {
        Object handler = bean;
        if (handler instanceof TargetClassAware) {
            try {
                Object object = ((Advised)handler).getTargetSource().getTarget();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"handler as Advised).targetSource.target");
                handler = object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        List<Field> fields = ReflectionUtils.getFields(handler.getClass());
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ComponentMap.class)) continue;
            if (!Map.class.isAssignableFrom(field.getType())) {
                throw new IllegalStateException("@ComponentMap may only be used on maps".toString());
            }
            ComponentMap mapped = field.getAnnotation(ComponentMap.class);
            try {
                Class<?> keyClazz;
                Class valueClazz;
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
                Intrinsics.checkNotNull(FieldUtils.getGenericClass(field, 0));
                Intrinsics.checkNotNull(FieldUtils.getGenericClass(field, 1));
                boolean isList = false;
                if (Collection.class.isAssignableFrom(valueClazz)) {
                    isList = true;
                    valueClazz = FieldUtils.resolveNestedGeneric$default(field, 1, 0, 2, null);
                }
                ReflectionUtils.makeAccessible((Field)field);
                Map<Object, List<Object>> map = this.getOrCreateComponentMap(keyClazz, valueClazz);
                if (isList) {
                    field.set(handler, map);
                    continue;
                }
                field.set(handler, new SingletonComponentMap<Object, Object>(map));
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<Object, List<Object>> getOrCreateComponentMap(Class<?> initialKeyType, Class<?> initialValueType) {
        ComponentMapIdentifier identifier = new ComponentMapIdentifier(initialKeyType, initialValueType);
        Map<Object, List<Object>> map = this.componentMaps.get(identifier);
        if (map != null) {
            return map;
        }
        Lock lock = ParameterLock.getCanonicalParameterLock(initialKeyType.getCanonicalName() + '_' + initialValueType.getCanonicalName(), new String[0]);
        lock.lock();
        try {
            map = this.componentMaps.get(identifier);
            if (map != null) {
                Map<Object, List<Object>> map2 = map;
                return map2;
            }
            Map<Object, Object> map3 = this.componentMaps;
            Map map4 = new LinkedHashMap();
            map3.put(identifier, map4);
            Map<Object, List<Object>> map5 = this.componentMaps.get(identifier);
            Intrinsics.checkNotNull(map5);
            map3 = map5;
            return map3;
        }
        finally {
            lock.unlock();
        }
    }

    private final void registerComponentMapKeyIfExists(Object bean) {
        List<Method> methods = ReflectionUtils.getMethods(bean.getClass());
        for (Method method : methods) {
            ComponentMapKey annotation = (ComponentMapKey)AnnotationUtils.findAnnotation((Method)method, ComponentMapKey.class);
            if (annotation == null) continue;
            try {
                Object key = method.invoke(bean, new Object[0]);
                Class<?> keyClass = key.getClass();
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                Class<?> valueClass = ComponentMapPostProcessorKt.getMethodDeclarer(method);
                Map<Object, List<Object>> map = this.getOrCreateComponentMap(keyClass, valueClass);
                List list = map.computeIfAbsent(key, ComponentMapPostProcessor::registerComponentMapKeyIfExists$lambda-0);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map.computeIfAbsent(key) { mutableListOf() }");
                List list2 = list;
                ((Collection)list2).add(bean);
            }
            catch (Exception exception) {}
        }
    }

    private static final List registerComponentMapKeyIfExists$lambda-0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }
}

