/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.hmac;

import com.sshtools.j2ssh.transport.AlgorithmInitializationException;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacMd5
implements SshHmac {
    private Mac mac;

    public int getMacLength() {
        return this.mac.getMacLength();
    }

    public byte[] generate(long l, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[]{(byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)(l >> 0)};
        this.mac.update(byArray2);
        this.mac.update(byArray, n, n2);
        return this.mac.doFinal();
    }

    public void init(byte[] byArray) throws AlgorithmInitializationException {
        try {
            this.mac = Mac.getInstance("HmacMD5");
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "HmacMD5");
            this.mac.init(secretKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AlgorithmInitializationException("No provider exists for the HmacSha1 algorithm");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AlgorithmInitializationException("Invalid key");
        }
    }

    public boolean verify(long l, byte[] byArray) {
        int n = this.getMacLength();
        byte[] byArray2 = this.generate(l, byArray, 0, byArray.length - n);
        String string = new String(byArray2);
        String string2 = new String(byArray, byArray.length - n, n);
        return string.equals(string2);
    }
}

