/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.openssh.KeyInfo;
import com.sshtools.j2ssh.util.SimpleASNReader;
import com.sshtools.j2ssh.util.SimpleASNWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class RSAKeyInfo
implements KeyInfo {
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;

    public RSAKeyInfo(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        this.privateExponent = bigInteger3;
        this.primeP = bigInteger4;
        this.primeQ = bigInteger5;
        this.primeExponentP = bigInteger6;
        this.primeExponentQ = bigInteger7;
    }

    public KeySpec getPrivateKeySpec() {
        return new RSAPrivateKeySpec(this.modulus, this.privateExponent);
    }

    public KeySpec getPublicKeySpec() {
        return new RSAPublicKeySpec(this.modulus, this.publicExponent);
    }

    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    public BigInteger getPrimeP() {
        return this.primeP;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public static RSAKeyInfo getRSAKeyInfo(SimpleASNReader simpleASNReader) throws IOException {
        simpleASNReader.assertByte(48);
        int n = simpleASNReader.getLength();
        simpleASNReader.assertByte(2);
        byte[] byArray = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray2 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray3 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray4 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray5 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray6 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray7 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray8 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray9 = simpleASNReader.getData();
        return new RSAKeyInfo(new BigInteger(byArray2), new BigInteger(byArray3), new BigInteger(byArray4), new BigInteger(byArray5), new BigInteger(byArray6), new BigInteger(byArray7), new BigInteger(byArray8), new BigInteger(byArray9));
    }

    public static void writeRSAKeyInfo(SimpleASNWriter simpleASNWriter, RSAKeyInfo rSAKeyInfo) {
        SimpleASNWriter simpleASNWriter2 = new SimpleASNWriter();
        simpleASNWriter2.writeByte(2);
        byte[] byArray = new byte[1];
        simpleASNWriter2.writeData(byArray);
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getModulus().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getPublicExponent().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getPrivateExponent().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getPrimeP().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getPrimeQ().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getPrimeExponentP().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getPrimeExponentQ().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getCrtCoefficient().toByteArray());
        byte[] byArray2 = simpleASNWriter2.toByteArray();
        simpleASNWriter.writeByte(48);
        simpleASNWriter.writeData(byArray2);
    }
}

