/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreferencesStore {
    protected static Log log = LogFactory.getLog((Class)PreferencesStore.class);
    private static File file;
    private static boolean storeAvailable;
    private static Properties preferences;

    public static void saveTableMetrics(JTable jTable, String string) {
        for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
            int n = jTable.getColumnModel().getColumn(i).getWidth();
            PreferencesStore.put(string + ".column." + i + ".width", String.valueOf(n));
            PreferencesStore.put(string + ".column." + i + ".position", String.valueOf(jTable.convertColumnIndexToModel(i)));
        }
    }

    public static void restoreTableMetrics(JTable jTable, String string, int[] nArray) {
        if (jTable.getAutoResizeMode() != 0) {
            throw new IllegalArgumentException("Table AutoResizeMode must be JTable.AUTO_RESIZE_OFF");
        }
        for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
            try {
                jTable.moveColumn(jTable.convertColumnIndexToView(PreferencesStore.getInt(string + ".column." + i + ".position", i)), i);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(PreferencesStore.getInt(string + ".column." + i + ".width", nArray == null ? jTable.getColumnModel().getColumn(i).getPreferredWidth() : nArray[i]));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static boolean isStoreAvailable() {
        return storeAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File file) {
        PreferencesStore.file = file;
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            log.info((Object)("Creating SSHTerm preferences directory " + file2.getAbsolutePath()));
            if (!file2.mkdirs()) {
                log.error((Object)("Preferences directory " + file2.getAbsolutePath() + " could not be created. " + "Preferences will not be stored"));
            }
        }
        if (storeAvailable = file2.exists()) {
            if (file.exists()) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    preferences.load(fileInputStream);
                    storeAvailable = true;
                }
                catch (IOException iOException) {
                    log.error((Object)iOException);
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                PreferencesStore.savePreferences();
            }
        } else {
            log.warn((Object)"Preferences store not available.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePreferences() {
        if (file == null) {
            log.error((Object)"Preferences not saved as PreferencesStore has not been initialise.");
        } else {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                preferences.store(fileOutputStream, "SSHTerm preferences");
                log.info((Object)("Preferences written to " + file.getAbsolutePath()));
                storeAvailable = true;
            }
            catch (IOException iOException) {
                log.error((Object)iOException);
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static String get(String string, String string2) {
        return preferences.getProperty(string, string2);
    }

    public static void put(String string, String string2) {
        preferences.put(string, string2);
    }

    public static Rectangle getRectangle(String string, Rectangle rectangle) {
        String string2 = preferences.getProperty(string);
        if (string2 == null || string2.equals("")) {
            return rectangle;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        Rectangle rectangle2 = new Rectangle();
        try {
            rectangle2.x = Integer.parseInt(stringTokenizer.nextToken());
            rectangle2.y = Integer.parseInt(stringTokenizer.nextToken());
            rectangle2.width = Integer.parseInt(stringTokenizer.nextToken());
            rectangle2.height = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            log.warn((Object)("Preference is " + string + " is badly formatted"), (Throwable)numberFormatException);
        }
        return rectangle2;
    }

    public static void putRectangle(String string, Rectangle rectangle) {
        preferences.put(string, rectangle == null ? "" : rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height);
    }

    public static int getInt(String string, int n) {
        String string2 = preferences.getProperty(string);
        if (string2 != null && !string2.equals("")) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn((Object)("Preference is " + string + " is badly formatted"), (Throwable)numberFormatException);
            }
        }
        return n;
    }

    public static double getDouble(String string, double d) {
        String string2 = preferences.getProperty(string);
        if (string2 != null && !string2.equals("")) {
            try {
                return Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn((Object)("Preference is " + string + " is badly formatted"), (Throwable)numberFormatException);
            }
        }
        return d;
    }

    public static void putInt(String string, int n) {
        preferences.put(string, String.valueOf(n));
    }

    public static void putDouble(String string, double d) {
        preferences.put(string, String.valueOf(d));
    }

    public static boolean getBoolean(String string, boolean bl) {
        return PreferencesStore.get(string, String.valueOf(bl)).equals("true");
    }

    public static void putBoolean(String string, boolean bl) {
        preferences.put(string, String.valueOf(bl));
    }

    public static boolean preferenceExists(String string) {
        return preferences.containsKey(string);
    }

    public static boolean removePreference(String string) {
        boolean bl = PreferencesStore.preferenceExists(string);
        preferences.remove(string);
        return bl;
    }

    static {
        preferences = new Properties();
    }
}

