/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.hosts;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractHostKeyVerification
extends DefaultHandler
implements HostKeyVerification {
    private static String defaultHostFile;
    private static Log log;
    private List deniedHosts = new ArrayList();
    private Map allowedHosts = new HashMap();
    private String hostFile;
    private boolean hostFileWriteable;
    private boolean expectEndElement = false;
    private String currentElement = null;

    public AbstractHostKeyVerification() throws InvalidHostFileException {
        this(defaultHostFile);
        this.hostFile = defaultHostFile;
    }

    public AbstractHostKeyVerification(String string) throws InvalidHostFileException {
        InputStream inputStream = null;
        try {
            if (string != null) {
                File file;
                if (System.getSecurityManager() != null) {
                    AccessController.checkPermission(new FilePermission(string, "read"));
                }
                if ((file = new File(string)).exists()) {
                    inputStream = new FileInputStream(file);
                    this.hostFile = string;
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    sAXParser.parse(inputStream, (DefaultHandler)this);
                    this.hostFileWriteable = file.canWrite();
                } else if (file.createNewFile()) {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(this.toString().getBytes());
                    fileOutputStream.close();
                    this.hostFileWriteable = true;
                } else {
                    this.hostFileWriteable = false;
                }
                if (!this.hostFileWriteable) {
                    log.warn((Object)"Host file is not writeable.");
                }
            }
        }
        catch (AccessControlException accessControlException) {
            log.warn((Object)"Not enough permission to load a hosts file, so just creating an empty list");
        }
        catch (IOException iOException) {
            throw new InvalidHostFileException("Could not open or read " + string);
        }
        catch (SAXException sAXException) {
            throw new InvalidHostFileException("Failed XML parsing: " + sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InvalidHostFileException("Failed to initialize xml parser: " + parserConfigurationException.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.currentElement == null) {
            if (!string3.equals("HostAuthorizations")) throw new SAXException("Unexpected document element!");
            this.allowedHosts.clear();
            this.deniedHosts.clear();
            this.currentElement = string3;
            return;
        } else {
            if (!this.currentElement.equals("HostAuthorizations")) {
                throw new SAXException("Unexpected parent element found!");
            }
            if (string3.equals("AllowHost")) {
                String string4 = attributes.getValue("HostName");
                String string5 = attributes.getValue("Fingerprint");
                if (string4 == null || string5 == null) throw new SAXException("Requried attribute(s) missing!");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AllowHost element for host '" + string4 + "' with fingerprint '" + string5 + "'"));
                }
                this.allowedHosts.put(string4, string5);
                this.currentElement = string3;
                return;
            } else if (string3.equals("DenyHost")) {
                String string6 = attributes.getValue("HostName");
                if (string6 == null) throw new SAXException("Required attribute hostname missing");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DenyHost element for host " + string6));
                }
                this.deniedHosts.add(string6);
                this.currentElement = string3;
                return;
            } else {
                log.warn((Object)("Unexpected " + string3 + " element found in allowed hosts file"));
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.currentElement == null) {
            throw new SAXException("Unexpected end element found!");
        }
        if (this.currentElement.equals("HostAuthorizations")) {
            this.currentElement = null;
            return;
        }
        if (this.currentElement.equals("AllowHost")) {
            this.currentElement = "HostAuthorizations";
            return;
        }
        if (this.currentElement.equals("DenyHost")) {
            this.currentElement = "HostAuthorizations";
            return;
        }
    }

    public boolean isHostFileWriteable() {
        return this.hostFileWriteable;
    }

    public abstract void onDeniedHost(String var1) throws TransportProtocolException;

    public abstract void onHostKeyMismatch(String var1, String var2, String var3) throws TransportProtocolException;

    public abstract void onUnknownHost(String var1, String var2) throws TransportProtocolException;

    public void allowHost(String string, String string2, boolean bl) throws InvalidHostFileException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Allowing " + string + " with fingerprint " + string2));
        }
        this.allowedHosts.put(string, string2);
        if (bl) {
            this.saveHostFile();
        }
    }

    public Map allowedHosts() {
        return this.allowedHosts;
    }

    public List deniedHosts() {
        return this.deniedHosts;
    }

    public void removeAllowedHost(String string) {
        this.allowedHosts.remove(string);
    }

    public void removeDeniedHost(String string) {
        for (int i = this.deniedHosts.size() - 1; i >= 0; --i) {
            String string2 = (String)this.deniedHosts.get(i);
            if (!string2.equals(string)) continue;
            this.deniedHosts.remove(i);
        }
    }

    public void denyHost(String string, boolean bl) throws InvalidHostFileException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " is denied access"));
        }
        if (!this.deniedHosts.contains(string)) {
            this.deniedHosts.add(string);
        }
        if (bl) {
            this.saveHostFile();
        }
    }

    public boolean verifyHost(String string, SshPublicKey sshPublicKey) throws TransportProtocolException {
        String string2 = sshPublicKey.getFingerprint();
        log.info((Object)("Verifying " + string + " host key"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fingerprint: " + string2));
        }
        if (this.deniedHosts.contains(string)) {
            this.onDeniedHost(string);
            return false;
        }
        if (this.allowedHosts.containsKey(string)) {
            String string3 = (String)this.allowedHosts.get(string);
            if (string3.compareToIgnoreCase(string2) == 0) {
                return true;
            }
            this.onHostKeyMismatch(string, string3, string2);
            return this.checkFingerprint(string, string2);
        }
        this.onUnknownHost(string, string2);
        return this.checkFingerprint(string, string2);
    }

    private boolean checkFingerprint(String string, String string2) {
        String string3 = (String)this.allowedHosts.get(string);
        return string3 != null && string3.compareToIgnoreCase(string2) == 0;
    }

    public void saveHostFile() throws InvalidHostFileException {
        if (!this.hostFileWriteable) {
            throw new InvalidHostFileException("Host file is not writeable.");
        }
        log.info((Object)("Saving " + defaultHostFile));
        try {
            File file = new File(this.hostFile);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.toString().getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new InvalidHostFileException("Could not write to " + this.hostFile);
        }
    }

    public String toString() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<HostAuthorizations>\n";
        string = string + "<!-- Host Authorizations file, used by the abstract class HostKeyVerification to verify the servers host key -->";
        string = string + "   <!-- Allow the following hosts access if they provide the correct public key -->\n";
        Iterator iterator = this.allowedHosts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            string = string + "   <AllowHost HostName=\"" + entry.getKey().toString() + "\" Fingerprint=\"" + entry.getValue().toString() + "\"/>\n";
        }
        string = string + "   <!-- Deny the following hosts access -->\n";
        iterator = this.deniedHosts.iterator();
        while (iterator.hasNext()) {
            string = string + "   <DenyHost HostName=\"" + iterator.next().toString() + "\"/>\n";
        }
        string = string + "</HostAuthorizations>";
        return string;
    }

    static {
        log = LogFactory.getLog((Class)HostKeyVerification.class);
        log.info((Object)"Determining default host file");
        defaultHostFile = ConfigurationLoader.getConfigurationDirectory();
        if (defaultHostFile == null) {
            log.info((Object)"No configuration location, persistence of host keys will be disabled.");
        } else {
            defaultHostFile = defaultHostFile + "hosts.xml";
            log.info((Object)("Defaulting host file to " + defaultHostFile));
        }
    }
}

