/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.object.MappingSqlQuery;
import org.springframework.jdbc.support.JdbcUtils;

public class SqlFunction
extends MappingSqlQuery {
    private final SingleColumnRowMapper rowMapper = new SingleColumnRowMapper();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;

    public SqlFunction() {
        this.setRowsExpected(1);
    }

    public SqlFunction(DataSource ds, String sql) {
        this.setRowsExpected(1);
        this.setDataSource(ds);
        this.setSql(sql);
    }

    public SqlFunction(DataSource ds, String sql, int[] types) {
        this.setRowsExpected(1);
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
    }

    public SqlFunction(DataSource ds, String sql, int[] types, Class resultType) {
        this.setRowsExpected(1);
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
        this.setResultType(resultType);
    }

    public SqlFunction(DataSource ds, String sql, int retType) {
        this(ds, sql, null, retType);
    }

    public SqlFunction(DataSource ds, String sql, int[] types, int retType) {
        this.setRowsExpected(1);
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
        this.setResultType(this.determineRequiredType(retType));
    }

    public void setResultType(Class resultType) {
        this.rowMapper.setRequiredType(resultType);
    }

    private Class determineRequiredType(int sqlType) {
        int translatedType = JdbcUtils.translateType(sqlType);
        switch (translatedType) {
            case 12: {
                return class$java$lang$String == null ? (class$java$lang$String = SqlFunction.class$("java.lang.String")) : class$java$lang$String;
            }
            case 4: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = SqlFunction.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case -5: {
                return class$java$lang$Long == null ? (class$java$lang$Long = SqlFunction.class$("java.lang.Long")) : class$java$lang$Long;
            }
            case 2: {
                return class$java$lang$Double == null ? (class$java$lang$Double = SqlFunction.class$("java.lang.Double")) : class$java$lang$Double;
            }
        }
        return null;
    }

    protected Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        return this.rowMapper.mapRow(rs, rowNum);
    }

    public int run() {
        return this.run(null);
    }

    public int run(int parameter) {
        return this.run(new Object[]{new Integer(parameter)});
    }

    public int run(Object[] parameters) {
        Object obj = super.findObject(parameters);
        if (!(obj instanceof Number)) {
            throw new TypeMismatchDataAccessException("Couldn't convert result object [" + obj + "] to int");
        }
        return ((Number)obj).intValue();
    }

    public Object runGeneric() {
        return this.findObject((Object[])null);
    }

    public Object runGeneric(int parameter) {
        return this.findObject(parameter);
    }

    public Object runGeneric(Object[] parameters) {
        return this.findObject(parameters);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

