/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ReflectiveVisitorHelper;
import org.springframework.core.style.ValueStyler;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultValueStyler
implements ValueStyler {
    private static final String EMPTY = "[empty]";
    private static final String NULL = "[null]";
    private static final String COLLECTION = "collection";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final String MAP = "map";
    private static final String ARRAY = "array";
    private ReflectiveVisitorHelper reflectiveVisitorHelper = new ReflectiveVisitorHelper();

    public String style(Object value) {
        return (String)this.reflectiveVisitorHelper.invokeVisit(this, value);
    }

    String visit(String value) {
        return '\'' + value + '\'';
    }

    String visit(Number value) {
        return String.valueOf(value);
    }

    String visit(Class clazz) {
        return ClassUtils.getShortName(clazz);
    }

    String visit(Method method) {
        return method.getName() + "@" + ClassUtils.getShortName(method.getDeclaringClass());
    }

    String visit(Map value) {
        StringBuffer buffer = new StringBuffer(value.size() * 8 + 16);
        buffer.append("map[");
        Iterator i = value.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            buffer.append(this.style(entry));
            if (!i.hasNext()) continue;
            buffer.append(',').append(' ');
        }
        if (value.isEmpty()) {
            buffer.append(EMPTY);
        }
        buffer.append("]");
        return buffer.toString();
    }

    String visit(Map.Entry value) {
        return this.style(value.getKey()) + " -> " + this.style(value.getValue());
    }

    String visit(Collection value) {
        StringBuffer buffer = new StringBuffer(value.size() * 8 + 16);
        buffer.append(this.getCollectionTypeString(value) + "[");
        Iterator i = value.iterator();
        while (i.hasNext()) {
            buffer.append(this.style(i.next()));
            if (!i.hasNext()) continue;
            buffer.append(',').append(' ');
        }
        if (value.isEmpty()) {
            buffer.append(EMPTY);
        }
        buffer.append("]");
        return buffer.toString();
    }

    private String getCollectionTypeString(Collection value) {
        if (value instanceof List) {
            return LIST;
        }
        if (value instanceof Set) {
            return SET;
        }
        return COLLECTION;
    }

    String visit(Object value) {
        if (value.getClass().isArray()) {
            return this.styleArray(this.getObjectArray(value));
        }
        return String.valueOf(value);
    }

    String visitNull() {
        return NULL;
    }

    private String styleArray(Object[] array) {
        StringBuffer buffer = new StringBuffer(array.length * 8 + 16);
        buffer.append("array<" + StringUtils.delete(ClassUtils.getShortName(array.getClass()), ";") + ">[");
        for (int i = 0; i < array.length - 1; ++i) {
            buffer.append(this.style(array[i]));
            buffer.append(',').append(' ');
        }
        if (array.length > 0) {
            buffer.append(this.style(array[array.length - 1]));
        } else {
            buffer.append(EMPTY);
        }
        buffer.append("]");
        return buffer.toString();
    }

    private Object[] getObjectArray(Object value) {
        if (value.getClass().getComponentType().isPrimitive()) {
            return ObjectUtils.toObjectArray(value);
        }
        return (Object[])value;
    }
}

