/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessExceptionsException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.propertyeditors.ByteArrayPropertyEditor;
import org.springframework.beans.propertyeditors.CharacterEditor;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.FileEditor;
import org.springframework.beans.propertyeditors.InputStreamEditor;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.beans.propertyeditors.PropertiesEditor;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.beans.propertyeditors.URLEditor;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeanWrapperImpl
implements BeanWrapper {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$BeanWrapperImpl == null ? (class$org$springframework$beans$BeanWrapperImpl = BeanWrapperImpl.class$("org.springframework.beans.BeanWrapperImpl")) : class$org$springframework$beans$BeanWrapperImpl));
    private Object object;
    private String nestedPath = "";
    private Object rootObject;
    private final Map defaultEditors;
    private Map customEditors;
    private CachedIntrospectionResults cachedIntrospectionResults;
    private Map nestedBeanWrappers;
    static /* synthetic */ Class class$org$springframework$beans$BeanWrapperImpl;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class array$Lorg$springframework$core$io$Resource;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public BeanWrapperImpl() {
        this.defaultEditors = new HashMap(32);
        this.registerDefaultEditors();
    }

    public BeanWrapperImpl(Object object) {
        this();
        this.setWrappedInstance(object);
    }

    public BeanWrapperImpl(Class clazz) {
        this();
        this.setWrappedInstance(BeanUtils.instantiateClass(clazz));
    }

    public BeanWrapperImpl(Object object, String nestedPath, Object rootObject) {
        this();
        this.setWrappedInstance(object, nestedPath, rootObject);
    }

    private BeanWrapperImpl(Object object, String nestedPath, BeanWrapperImpl superBw) {
        this.defaultEditors = superBw.defaultEditors;
        this.setWrappedInstance(object, nestedPath, superBw.getWrappedInstance());
    }

    private void registerDefaultEditors() {
        this.defaultEditors.put(array$B == null ? (array$B = BeanWrapperImpl.class$("[B")) : array$B, new ByteArrayPropertyEditor());
        this.defaultEditors.put(class$java$lang$Class == null ? (class$java$lang$Class = BeanWrapperImpl.class$("java.lang.Class")) : class$java$lang$Class, new ClassEditor());
        this.defaultEditors.put(class$java$io$File == null ? (class$java$io$File = BeanWrapperImpl.class$("java.io.File")) : class$java$io$File, new FileEditor());
        this.defaultEditors.put(class$java$io$InputStream == null ? (class$java$io$InputStream = BeanWrapperImpl.class$("java.io.InputStream")) : class$java$io$InputStream, new InputStreamEditor());
        this.defaultEditors.put(class$java$util$Locale == null ? (class$java$util$Locale = BeanWrapperImpl.class$("java.util.Locale")) : class$java$util$Locale, new LocaleEditor());
        this.defaultEditors.put(class$java$util$Properties == null ? (class$java$util$Properties = BeanWrapperImpl.class$("java.util.Properties")) : class$java$util$Properties, new PropertiesEditor());
        this.defaultEditors.put(array$Lorg$springframework$core$io$Resource == null ? (array$Lorg$springframework$core$io$Resource = BeanWrapperImpl.class$("[Lorg.springframework.core.io.Resource;")) : array$Lorg$springframework$core$io$Resource, new ResourceArrayPropertyEditor());
        this.defaultEditors.put(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanWrapperImpl.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, new StringArrayPropertyEditor());
        this.defaultEditors.put(class$java$net$URL == null ? (class$java$net$URL = BeanWrapperImpl.class$("java.net.URL")) : class$java$net$URL, new URLEditor());
        this.defaultEditors.put(class$java$util$Collection == null ? (class$java$util$Collection = BeanWrapperImpl.class$("java.util.Collection")) : class$java$util$Collection, new CustomCollectionEditor(class$java$util$Collection == null ? (class$java$util$Collection = BeanWrapperImpl.class$("java.util.Collection")) : class$java$util$Collection));
        this.defaultEditors.put(class$java$util$Set == null ? (class$java$util$Set = BeanWrapperImpl.class$("java.util.Set")) : class$java$util$Set, new CustomCollectionEditor(class$java$util$Set == null ? (class$java$util$Set = BeanWrapperImpl.class$("java.util.Set")) : class$java$util$Set));
        this.defaultEditors.put(class$java$util$SortedSet == null ? (class$java$util$SortedSet = BeanWrapperImpl.class$("java.util.SortedSet")) : class$java$util$SortedSet, new CustomCollectionEditor(class$java$util$SortedSet == null ? (class$java$util$SortedSet = BeanWrapperImpl.class$("java.util.SortedSet")) : class$java$util$SortedSet));
        this.defaultEditors.put(class$java$util$List == null ? (class$java$util$List = BeanWrapperImpl.class$("java.util.List")) : class$java$util$List, new CustomCollectionEditor(class$java$util$List == null ? (class$java$util$List = BeanWrapperImpl.class$("java.util.List")) : class$java$util$List));
        CharacterEditor characterEditor = new CharacterEditor(false);
        CustomBooleanEditor booleanEditor = new CustomBooleanEditor(false);
        this.defaultEditors.put(Character.TYPE, characterEditor);
        this.defaultEditors.put(class$java$lang$Character == null ? (class$java$lang$Character = BeanWrapperImpl.class$("java.lang.Character")) : class$java$lang$Character, characterEditor);
        this.defaultEditors.put(Boolean.TYPE, booleanEditor);
        this.defaultEditors.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanWrapperImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean, booleanEditor);
        CustomNumberEditor byteEditor = new CustomNumberEditor(class$java$lang$Byte == null ? (class$java$lang$Byte = BeanWrapperImpl.class$("java.lang.Byte")) : class$java$lang$Byte, false);
        CustomNumberEditor shortEditor = new CustomNumberEditor(class$java$lang$Short == null ? (class$java$lang$Short = BeanWrapperImpl.class$("java.lang.Short")) : class$java$lang$Short, false);
        CustomNumberEditor integerEditor = new CustomNumberEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = BeanWrapperImpl.class$("java.lang.Integer")) : class$java$lang$Integer, false);
        CustomNumberEditor longEditor = new CustomNumberEditor(class$java$lang$Long == null ? (class$java$lang$Long = BeanWrapperImpl.class$("java.lang.Long")) : class$java$lang$Long, false);
        CustomNumberEditor floatEditor = new CustomNumberEditor(class$java$lang$Float == null ? (class$java$lang$Float = BeanWrapperImpl.class$("java.lang.Float")) : class$java$lang$Float, false);
        CustomNumberEditor doubleEditor = new CustomNumberEditor(class$java$lang$Double == null ? (class$java$lang$Double = BeanWrapperImpl.class$("java.lang.Double")) : class$java$lang$Double, false);
        this.defaultEditors.put(Byte.TYPE, byteEditor);
        this.defaultEditors.put(class$java$lang$Byte == null ? (class$java$lang$Byte = BeanWrapperImpl.class$("java.lang.Byte")) : class$java$lang$Byte, byteEditor);
        this.defaultEditors.put(Short.TYPE, shortEditor);
        this.defaultEditors.put(class$java$lang$Short == null ? (class$java$lang$Short = BeanWrapperImpl.class$("java.lang.Short")) : class$java$lang$Short, shortEditor);
        this.defaultEditors.put(Integer.TYPE, integerEditor);
        this.defaultEditors.put(class$java$lang$Integer == null ? (class$java$lang$Integer = BeanWrapperImpl.class$("java.lang.Integer")) : class$java$lang$Integer, integerEditor);
        this.defaultEditors.put(Long.TYPE, longEditor);
        this.defaultEditors.put(class$java$lang$Long == null ? (class$java$lang$Long = BeanWrapperImpl.class$("java.lang.Long")) : class$java$lang$Long, longEditor);
        this.defaultEditors.put(Float.TYPE, floatEditor);
        this.defaultEditors.put(class$java$lang$Float == null ? (class$java$lang$Float = BeanWrapperImpl.class$("java.lang.Float")) : class$java$lang$Float, floatEditor);
        this.defaultEditors.put(Double.TYPE, doubleEditor);
        this.defaultEditors.put(class$java$lang$Double == null ? (class$java$lang$Double = BeanWrapperImpl.class$("java.lang.Double")) : class$java$lang$Double, doubleEditor);
        this.defaultEditors.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BeanWrapperImpl.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new CustomNumberEditor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BeanWrapperImpl.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, false));
        this.defaultEditors.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = BeanWrapperImpl.class$("java.math.BigInteger")) : class$java$math$BigInteger, new CustomNumberEditor(class$java$math$BigInteger == null ? (class$java$math$BigInteger = BeanWrapperImpl.class$("java.math.BigInteger")) : class$java$math$BigInteger, false));
    }

    public void setWrappedInstance(Object object) {
        this.setWrappedInstance(object, "", null);
    }

    public void setWrappedInstance(Object object, String nestedPath, Object rootObject) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot set BeanWrapperImpl target to a null object");
        }
        this.object = object;
        this.nestedPath = nestedPath != null ? nestedPath : "";
        this.rootObject = !"".equals(this.nestedPath) ? rootObject : object;
        this.nestedBeanWrappers = null;
        this.setIntrospectionClass(object.getClass());
    }

    public Object getWrappedInstance() {
        return this.object;
    }

    public Class getWrappedClass() {
        return this.object.getClass();
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public Object getRootInstance() {
        return this.rootObject;
    }

    public Class getRootClass() {
        return this.rootObject != null ? this.rootObject.getClass() : null;
    }

    protected void setIntrospectionClass(Class clazz) {
        if (this.cachedIntrospectionResults == null || !this.cachedIntrospectionResults.getBeanClass().equals(clazz)) {
            this.cachedIntrospectionResults = CachedIntrospectionResults.forClass(clazz);
        }
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.registerCustomEditor(requiredType, null, propertyEditor);
    }

    public void registerCustomEditor(Class requiredType, String propertyPath, PropertyEditor propertyEditor) {
        if (requiredType == null && propertyPath == null) {
            throw new IllegalArgumentException("Either requiredType or propertyPath is required");
        }
        if (this.customEditors == null) {
            this.customEditors = new HashMap();
        }
        if (propertyPath != null) {
            this.customEditors.put(propertyPath, new CustomEditorHolder(propertyEditor, requiredType));
        } else {
            this.customEditors.put(requiredType, propertyEditor);
        }
    }

    public PropertyEditor findCustomEditor(Class requiredType, String propertyPath) {
        if (this.customEditors == null) {
            return null;
        }
        if (propertyPath != null) {
            PropertyEditor editor = this.getCustomEditor(propertyPath, requiredType);
            if (editor == null) {
                LinkedList strippedPaths = new LinkedList();
                this.addStrippedPropertyPaths(strippedPaths, "", propertyPath);
                Iterator it = strippedPaths.iterator();
                while (it.hasNext() && editor == null) {
                    String strippedPath = (String)it.next();
                    editor = this.getCustomEditor(strippedPath, requiredType);
                }
            }
            if (editor != null) {
                return editor;
            }
            if (requiredType == null) {
                requiredType = this.getPropertyType(propertyPath);
            }
        }
        return this.getCustomEditor(requiredType);
    }

    private PropertyEditor getCustomEditor(String propertyName, Class requiredType) {
        CustomEditorHolder holder = (CustomEditorHolder)this.customEditors.get(propertyName);
        return holder != null ? holder.getPropertyEditor(requiredType) : null;
    }

    private PropertyEditor getCustomEditor(Class requiredType) {
        if (requiredType != null) {
            PropertyEditor editor = (PropertyEditor)this.customEditors.get(requiredType);
            if (editor == null) {
                Iterator it = this.customEditors.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    if (!(key instanceof Class) || !((Class)key).isAssignableFrom(requiredType)) continue;
                    editor = (PropertyEditor)this.customEditors.get(key);
                }
            }
            return editor;
        }
        return null;
    }

    private void addStrippedPropertyPaths(List strippedPaths, String nestedPath, String propertyPath) {
        int endIndex;
        int startIndex = propertyPath.indexOf(91);
        if (startIndex != -1 && (endIndex = propertyPath.indexOf(93)) != -1) {
            String prefix = propertyPath.substring(0, startIndex);
            String key = propertyPath.substring(startIndex, endIndex + 1);
            String suffix = propertyPath.substring(endIndex + 1, propertyPath.length());
            strippedPaths.add(nestedPath + prefix + suffix);
            this.addStrippedPropertyPaths(strippedPaths, nestedPath + prefix, suffix);
            this.addStrippedPropertyPaths(strippedPaths, nestedPath + prefix + key, suffix);
        }
    }

    private int getNestedPropertySeparatorIndex(String propertyPath, boolean last) {
        int i;
        boolean inKey = false;
        int n = i = last ? propertyPath.length() - 1 : 0;
        while (last && i >= 0 || i < propertyPath.length()) {
            switch (propertyPath.charAt(i)) {
                case '[': 
                case ']': {
                    inKey = !inKey;
                    break;
                }
                case '.': {
                    if (inKey) break;
                    return i;
                }
            }
            if (last) {
                --i;
                continue;
            }
            ++i;
        }
        return -1;
    }

    private String getFinalPath(BeanWrapper bw, String nestedPath) {
        if (bw == this) {
            return nestedPath;
        }
        return nestedPath.substring(this.getNestedPropertySeparatorIndex(nestedPath, true) + 1);
    }

    protected BeanWrapperImpl getBeanWrapperForPropertyPath(String propertyPath) throws BeansException {
        int pos = this.getNestedPropertySeparatorIndex(propertyPath, false);
        if (pos > -1) {
            String nestedProperty = propertyPath.substring(0, pos);
            String nestedPath = propertyPath.substring(pos + 1);
            BeanWrapperImpl nestedBw = this.getNestedBeanWrapper(nestedProperty);
            return nestedBw.getBeanWrapperForPropertyPath(nestedPath);
        }
        return this;
    }

    private BeanWrapperImpl getNestedBeanWrapper(String nestedProperty) throws BeansException {
        if (this.nestedBeanWrappers == null) {
            this.nestedBeanWrappers = new HashMap();
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(nestedProperty);
        Object propertyValue = this.getPropertyValue(tokens);
        String canonicalName = tokens.canonicalName;
        String propertyName = tokens.actualName;
        if (propertyValue == null) {
            throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + canonicalName);
        }
        BeanWrapperImpl nestedBw = (BeanWrapperImpl)this.nestedBeanWrappers.get(canonicalName);
        if (nestedBw == null || nestedBw.getWrappedInstance() != propertyValue) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating new nested BeanWrapper for property '" + canonicalName + "'"));
            }
            nestedBw = new BeanWrapperImpl(propertyValue, this.nestedPath + canonicalName + ".", this);
            if (this.customEditors != null) {
                Iterator it = this.customEditors.entrySet().iterator();
                while (it.hasNext()) {
                    String editorPath;
                    int pos;
                    Map.Entry entry = it.next();
                    if (entry.getKey() instanceof Class) {
                        Class requiredType = (Class)entry.getKey();
                        PropertyEditor editor = (PropertyEditor)entry.getValue();
                        nestedBw.registerCustomEditor(requiredType, editor);
                        continue;
                    }
                    if (!(entry.getKey() instanceof String) || (pos = this.getNestedPropertySeparatorIndex(editorPath = (String)entry.getKey(), false)) == -1) continue;
                    String editorNestedProperty = editorPath.substring(0, pos);
                    String editorNestedPath = editorPath.substring(pos + 1);
                    if (!editorNestedProperty.equals(canonicalName) && !editorNestedProperty.equals(propertyName)) continue;
                    CustomEditorHolder editorHolder = (CustomEditorHolder)entry.getValue();
                    nestedBw.registerCustomEditor(editorHolder.getRegisteredType(), editorNestedPath, editorHolder.getPropertyEditor());
                }
            }
            this.nestedBeanWrappers.put(canonicalName, nestedBw);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using cached nested BeanWrapper for property '" + canonicalName + "'"));
        }
        return nestedBw;
    }

    private PropertyTokenHolder getPropertyNameTokens(String propertyName) {
        PropertyTokenHolder tokens = new PropertyTokenHolder();
        String actualName = null;
        ArrayList<String> keys = new ArrayList<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            String key;
            int keyEnd;
            int keyStart = propertyName.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = propertyName.indexOf("]", keyStart + "[".length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            if ((key = propertyName.substring(keyStart + "[".length(), keyEnd)).startsWith("'") && key.endsWith("'")) {
                key = key.substring(1, key.length() - 1);
            } else if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            keys.add(key);
            searchIndex = keyEnd + "]".length();
        }
        tokens.actualName = actualName != null ? actualName : propertyName;
        tokens.canonicalName = tokens.actualName;
        if (!keys.isEmpty()) {
            tokens.canonicalName = tokens.canonicalName + ("[" + StringUtils.collectionToDelimitedString(keys, "][") + "]");
            PropertyTokenHolder.access$702(tokens, keys.toArray(new String[keys.size()]));
        }
        return tokens;
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        BeanWrapperImpl nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedBw, propertyName));
        return nestedBw.getPropertyValue(tokens);
    }

    protected Object getPropertyValue(PropertyTokenHolder tokens) throws BeansException {
        String propertyName = tokens.canonicalName;
        String actualName = tokens.actualName;
        PropertyDescriptor pd = this.getPropertyDescriptorInternal(tokens.actualName);
        if (pd == null || pd.getReadMethod() == null) {
            throw new NotReadablePropertyException(this.getRootClass(), this.nestedPath + propertyName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("About to invoke read method [" + pd.getReadMethod() + "] on object of class [" + this.object.getClass().getName() + "]"));
        }
        try {
            Object value = pd.getReadMethod().invoke(this.object, (Object[])null);
            if (tokens.keys != null) {
                block5: for (int i = 0; i < tokens.keys.length; ++i) {
                    String key = tokens.keys[i];
                    if (value == null) {
                        throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value of property referenced in indexed property path '" + propertyName + "': returned null");
                    }
                    if (value.getClass().isArray()) {
                        value = Array.get(value, Integer.parseInt(key));
                        continue;
                    }
                    if (value instanceof List) {
                        List list = (List)value;
                        value = list.get(Integer.parseInt(key));
                        continue;
                    }
                    if (value instanceof Set) {
                        Set set = (Set)value;
                        int index = Integer.parseInt(key);
                        if (index < 0 || index >= set.size()) {
                            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot get element with index " + index + " from Set of size " + set.size() + ", accessed using property path '" + propertyName + "'");
                        }
                        Iterator it = set.iterator();
                        int j = 0;
                        while (it.hasNext()) {
                            Object elem = it.next();
                            if (j == index) {
                                value = elem;
                                continue block5;
                            }
                            ++j;
                        }
                        continue;
                    }
                    if (value instanceof Map) {
                        Map map = (Map)value;
                        value = map.get(key);
                        continue;
                    }
                    throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Set nor a Map; returned value was [" + value + "]");
                }
            }
            return value;
        }
        catch (InvocationTargetException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Getter for property '" + actualName + "' threw exception", ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Illegal attempt to get property '" + actualName + "' threw exception", ex);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Index of out of bounds in property path '" + propertyName + "'", ex);
        }
        catch (NumberFormatException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid index in property path '" + propertyName + "'", ex);
        }
    }

    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        BeanWrapperImpl nestedBw = null;
        try {
            nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        }
        catch (NotReadablePropertyException ex) {
            throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Nested property in path '" + propertyName + "' does not exist", ex);
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedBw, propertyName));
        nestedBw.setPropertyValue(tokens, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setPropertyValue(PropertyTokenHolder tokens, Object value) throws BeansException {
        String propertyName = tokens.canonicalName;
        if (tokens.keys != null) {
            PropertyTokenHolder getterTokens = new PropertyTokenHolder();
            getterTokens.canonicalName = tokens.canonicalName;
            getterTokens.actualName = tokens.actualName;
            PropertyTokenHolder.access$702(getterTokens, new String[tokens.keys.length - 1]);
            System.arraycopy(tokens.keys, 0, getterTokens.keys, 0, tokens.keys.length - 1);
            Object propValue = null;
            try {
                propValue = this.getPropertyValue(getterTokens);
            }
            catch (NotReadablePropertyException ex) {
                throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value in property referenced in indexed property path '" + propertyName + "'", ex);
            }
            String key = tokens.keys[tokens.keys.length - 1];
            if (propValue == null) {
                throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value in property referenced in indexed property path '" + propertyName + "': returned null");
            }
            if (propValue.getClass().isArray()) {
                Class<?> requiredType = propValue.getClass().getComponentType();
                Object newValue = this.doTypeConversionIfNecessary(propertyName, propertyName, null, value, requiredType);
                try {
                    Array.set(propValue, Integer.parseInt(key), newValue);
                    return;
                }
                catch (IllegalArgumentException ex) {
                    PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, null, newValue);
                    throw new TypeMismatchException(pce, requiredType, (Throwable)ex);
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid array index in property path '" + propertyName + "'", ex);
                }
            } else if (propValue instanceof List) {
                Object newValue = this.doTypeConversionIfNecessary(propertyName, propertyName, null, value, null);
                List list = (List)propValue;
                int index = Integer.parseInt(key);
                if (index < list.size()) {
                    list.set(index, newValue);
                    return;
                } else {
                    if (index < list.size()) return;
                    for (int i = list.size(); i < index; ++i) {
                        try {
                            list.add(null);
                            continue;
                        }
                        catch (NullPointerException ex) {
                            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot set element with index " + index + " in List of size " + list.size() + ", accessed using property path '" + propertyName + "': List does not support filling up gaps with null elements");
                        }
                    }
                    list.add(newValue);
                }
                return;
            } else {
                if (!(propValue instanceof Map)) throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Map; returned value was [" + value + "]");
                Object newValue = this.doTypeConversionIfNecessary(propertyName, propertyName, null, value, null);
                Map map = (Map)propValue;
                map.put(key, newValue);
            }
            return;
        }
        if (!this.isWritableProperty(propertyName)) {
            throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName);
        }
        PropertyDescriptor pd = this.getPropertyDescriptor(propertyName);
        Method writeMethod = pd.getWriteMethod();
        Object newValue = null;
        try {
            newValue = this.doTypeConversionIfNecessary(propertyName, propertyName, null, value, pd.getPropertyType());
            if (pd.getPropertyType().isPrimitive() && (newValue == null || "".equals(newValue))) {
                throw new IllegalArgumentException("Invalid value [" + value + "] for property '" + pd.getName() + "' of primitive type [" + pd.getPropertyType() + "]");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("About to invoke write method [" + writeMethod + "] on object of class [" + this.object.getClass().getName() + "]"));
            }
            writeMethod.invoke(this.object, newValue);
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("Invoked write method [" + writeMethod + "] with value of type [" + pd.getPropertyType().getName() + "]"));
            return;
        }
        catch (InvocationTargetException ex) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, null, value);
            if (!(ex.getTargetException() instanceof ClassCastException)) throw new MethodInvocationException(propertyChangeEvent, ex.getTargetException());
            throw new TypeMismatchException(propertyChangeEvent, pd.getPropertyType(), ex.getTargetException());
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, null, value);
            throw new TypeMismatchException(pce, pd.getPropertyType(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, null, value);
            throw new MethodInvocationException(pce, (Throwable)ex);
        }
    }

    public void setPropertyValue(PropertyValue pv) throws BeansException {
        this.setPropertyValue(pv.getName(), pv.getValue());
    }

    public void setPropertyValues(Map map) throws BeansException {
        this.setPropertyValues(new MutablePropertyValues(map));
    }

    public void setPropertyValues(PropertyValues pvs) throws BeansException {
        this.setPropertyValues(pvs, false);
    }

    public void setPropertyValues(PropertyValues propertyValues, boolean ignoreUnknown) throws BeansException {
        ArrayList<PropertyAccessException> propertyAccessExceptions = new ArrayList<PropertyAccessException>();
        PropertyValue[] pvs = propertyValues.getPropertyValues();
        for (int i = 0; i < pvs.length; ++i) {
            try {
                this.setPropertyValue(pvs[i]);
                continue;
            }
            catch (NotWritablePropertyException ex) {
                if (ignoreUnknown) continue;
                throw ex;
            }
            catch (PropertyAccessException ex) {
                propertyAccessExceptions.add(ex);
            }
        }
        if (!propertyAccessExceptions.isEmpty()) {
            PropertyAccessException[] paeArray = propertyAccessExceptions.toArray(new PropertyAccessException[propertyAccessExceptions.size()]);
            throw new PropertyAccessExceptionsException(this, paeArray);
        }
    }

    private PropertyChangeEvent createPropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        return new PropertyChangeEvent(this.rootObject != null ? this.rootObject : "constructor", propertyName != null ? this.nestedPath + propertyName : null, oldValue, newValue);
    }

    public Object doTypeConversionIfNecessary(Object newValue, Class requiredType) throws TypeMismatchException {
        return this.doTypeConversionIfNecessary(null, null, null, newValue, requiredType);
    }

    protected Object doTypeConversionIfNecessary(String propertyName, String fullPropertyName, Object oldValue, Object newValue, Class requiredType) throws TypeMismatchException {
        PropertyEditor pe;
        Object convertedValue = newValue;
        if (convertedValue != null && ((pe = this.findCustomEditor(requiredType, fullPropertyName)) != null || requiredType != null && (requiredType.isArray() || !requiredType.isAssignableFrom(convertedValue.getClass())))) {
            if (requiredType != null && pe == null && (pe = (PropertyEditor)this.defaultEditors.get(requiredType)) == null) {
                pe = PropertyEditorManager.findEditor(requiredType);
            }
            if (pe != null && !(convertedValue instanceof String)) {
                try {
                    pe.setValue(convertedValue);
                    convertedValue = pe.getValue();
                }
                catch (IllegalArgumentException ex) {
                    throw new TypeMismatchException(this.createPropertyChangeEvent(fullPropertyName, oldValue, newValue), requiredType, (Throwable)ex);
                }
            }
            if (requiredType != null && !requiredType.isArray() && convertedValue instanceof String[]) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Converting String array to comma-delimited String [" + convertedValue + "]"));
                }
                convertedValue = StringUtils.arrayToCommaDelimitedString((String[])convertedValue);
            }
            if (pe != null && convertedValue instanceof String) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Converting String to [" + requiredType + "] using property editor [" + pe + "]"));
                }
                try {
                    pe.setAsText((String)convertedValue);
                    convertedValue = pe.getValue();
                }
                catch (IllegalArgumentException ex) {
                    throw new TypeMismatchException(this.createPropertyChangeEvent(fullPropertyName, oldValue, newValue), requiredType, (Throwable)ex);
                }
            }
            if (requiredType != null) {
                if (requiredType.isArray()) {
                    Class<?> componentType = requiredType.getComponentType();
                    if (convertedValue instanceof Collection) {
                        Collection coll = (Collection)convertedValue;
                        Object result = Array.newInstance(componentType, coll.size());
                        int i = 0;
                        Iterator it = coll.iterator();
                        while (it.hasNext()) {
                            Object value = this.doTypeConversionIfNecessary(propertyName, propertyName + "[" + i + "]", null, it.next(), componentType);
                            Array.set(result, i, value);
                            ++i;
                        }
                        return result;
                    }
                    if (convertedValue != null && convertedValue.getClass().isArray()) {
                        int arrayLength = Array.getLength(convertedValue);
                        Object result = Array.newInstance(componentType, arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            Object value = this.doTypeConversionIfNecessary(propertyName, propertyName + "[" + i + "]", null, Array.get(convertedValue, i), componentType);
                            Array.set(result, i, value);
                        }
                        return result;
                    }
                    Object result = Array.newInstance(componentType, 1);
                    Object val = this.doTypeConversionIfNecessary(propertyName, propertyName + "[" + 0 + "]", null, convertedValue, componentType);
                    Array.set(result, 0, val);
                    return result;
                }
                if (convertedValue != null && !requiredType.isPrimitive() && !requiredType.isAssignableFrom(convertedValue.getClass())) {
                    throw new TypeMismatchException(this.createPropertyChangeEvent(fullPropertyName, oldValue, newValue), requiredType);
                }
            }
        }
        return convertedValue;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.cachedIntrospectionResults.getBeanInfo().getPropertyDescriptors();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws BeansException {
        if (propertyName == null) {
            throw new IllegalArgumentException("Can't find property descriptor for null property");
        }
        PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
        if (pd != null) {
            return pd;
        }
        throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "No property '" + propertyName + "' found");
    }

    protected PropertyDescriptor getPropertyDescriptorInternal(String propertyName) throws BeansException {
        Assert.state(this.object != null, "BeanWrapper does not hold a bean instance");
        BeanWrapperImpl nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        return nestedBw.cachedIntrospectionResults.getPropertyDescriptor(this.getFinalPath(nestedBw, propertyName));
    }

    public Class getPropertyType(String propertyName) throws BeansException {
        try {
            PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
            if (pd != null) {
                return pd.getPropertyType();
            }
            Object value = this.getPropertyValue(propertyName);
            if (value != null) {
                return value.getClass();
            }
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return null;
    }

    public boolean isReadableProperty(String propertyName) {
        block5: {
            if (propertyName == null) {
                throw new IllegalArgumentException("Can't find readability status for null property");
            }
            try {
                PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
                if (pd != null) {
                    if (pd.getReadMethod() != null) {
                        return true;
                    }
                    break block5;
                }
                this.getPropertyValue(propertyName);
                return true;
            }
            catch (InvalidPropertyException invalidPropertyException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isWritableProperty(String propertyName) {
        block5: {
            if (propertyName == null) {
                throw new IllegalArgumentException("Can't find writability status for null property");
            }
            try {
                PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
                if (pd != null) {
                    if (pd.getWriteMethod() != null) {
                        return true;
                    }
                    break block5;
                }
                this.getPropertyValue(propertyName);
                return true;
            }
            catch (InvalidPropertyException invalidPropertyException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BeanWrapperImpl: wrapping class [");
        sb.append(this.getWrappedClass().getName()).append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PropertyTokenHolder {
        private String canonicalName;
        private String actualName;
        private String[] keys;

        private PropertyTokenHolder() {
        }

        static /* synthetic */ String[] access$702(PropertyTokenHolder x0, String[] x1) {
            x0.keys = x1;
            return x1;
        }
    }

    private static class CustomEditorHolder {
        private final PropertyEditor propertyEditor;
        private final Class registeredType;

        private CustomEditorHolder(PropertyEditor propertyEditor, Class registeredType) {
            this.propertyEditor = propertyEditor;
            this.registeredType = registeredType;
        }

        private PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        private Class getRegisteredType() {
            return this.registeredType;
        }

        private PropertyEditor getPropertyEditor(Class requiredType) {
            if (this.registeredType == null || requiredType != null && (BeanUtils.isAssignable(this.registeredType, requiredType) || BeanUtils.isAssignable(requiredType, this.registeredType)) || requiredType == null && !(class$java$util$Collection == null ? (class$java$util$Collection = BeanWrapperImpl.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(this.registeredType) && !this.registeredType.isArray()) {
                return this.propertyEditor;
            }
            return null;
        }
    }
}

