/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.springframework.web.util.ExpressionEvaluationUtils;

public class NestedPathTag
extends TagSupport {
    public static final String NESTED_PATH_VARIABLE_NAME = "nestedPath";
    private String path;
    private String previousNestedPath = "";

    public void setPath(String path) {
        if (path == null) {
            path = "";
        }
        if (path.length() > 0 && !path.endsWith(".")) {
            path = path + ".";
        }
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public int doStartTag() throws JspException {
        String resolvedPath = ExpressionEvaluationUtils.evaluateString("path", this.getPath(), this.pageContext);
        String nestedPath = (String)this.pageContext.getAttribute(NESTED_PATH_VARIABLE_NAME, 2);
        if (nestedPath != null) {
            this.previousNestedPath = nestedPath;
            nestedPath = nestedPath + resolvedPath;
        } else {
            nestedPath = resolvedPath;
        }
        this.pageContext.setAttribute(NESTED_PATH_VARIABLE_NAME, (Object)nestedPath, 2);
        return 1;
    }

    public int doEndTag() {
        if (this.previousNestedPath != null) {
            this.pageContext.setAttribute(NESTED_PATH_VARIABLE_NAME, (Object)this.previousNestedPath);
        } else {
            this.pageContext.removeAttribute(NESTED_PATH_VARIABLE_NAME);
        }
        return 6;
    }
}

