/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.MethodOverrides;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.beans.factory.xml.XmlBeanDefinitionParser;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXmlBeanDefinitionParser
implements XmlBeanDefinitionParser {
    public static final String BEAN_NAME_DELIMITERS = ",; ";
    public static final String TRUE_VALUE = "true";
    public static final String DEFAULT_VALUE = "default";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String AUTOWIRE_BY_NAME_VALUE = "byName";
    public static final String AUTOWIRE_BY_TYPE_VALUE = "byType";
    public static final String AUTOWIRE_CONSTRUCTOR_VALUE = "constructor";
    public static final String AUTOWIRE_AUTODETECT_VALUE = "autodetect";
    public static final String DEPENDENCY_CHECK_ALL_ATTRIBUTE_VALUE = "all";
    public static final String DEPENDENCY_CHECK_SIMPLE_ATTRIBUTE_VALUE = "simple";
    public static final String DEPENDENCY_CHECK_OBJECTS_ATTRIBUTE_VALUE = "objects";
    public static final String DEFAULT_LAZY_INIT_ATTRIBUTE = "default-lazy-init";
    public static final String DEFAULT_DEPENDENCY_CHECK_ATTRIBUTE = "default-dependency-check";
    public static final String DEFAULT_AUTOWIRE_ATTRIBUTE = "default-autowire";
    public static final String IMPORT_ELEMENT = "import";
    public static final String RESOURCE_ATTRIBUTE = "resource";
    public static final String BEAN_ELEMENT = "bean";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String PARENT_ATTRIBUTE = "parent";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String ABSTRACT_ATTRIBUTE = "abstract";
    public static final String SINGLETON_ATTRIBUTE = "singleton";
    public static final String LAZY_INIT_ATTRIBUTE = "lazy-init";
    public static final String AUTOWIRE_ATTRIBUTE = "autowire";
    public static final String DEPENDENCY_CHECK_ATTRIBUTE = "dependency-check";
    public static final String DEPENDS_ON_ATTRIBUTE = "depends-on";
    public static final String INIT_METHOD_ATTRIBUTE = "init-method";
    public static final String DESTROY_METHOD_ATTRIBUTE = "destroy-method";
    public static final String FACTORY_METHOD_ATTRIBUTE = "factory-method";
    public static final String FACTORY_BEAN_ATTRIBUTE = "factory-bean";
    public static final String CONSTRUCTOR_ARG_ELEMENT = "constructor-arg";
    public static final String INDEX_ATTRIBUTE = "index";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String LOOKUP_METHOD_ELEMENT = "lookup-method";
    public static final String REPLACED_METHOD_ELEMENT = "replaced-method";
    public static final String REPLACER_ATTRIBUTE = "replacer";
    public static final String ARG_TYPE_ELEMENT = "arg-type";
    public static final String ARG_TYPE_MATCH_ATTRIBUTE = "match";
    public static final String REF_ELEMENT = "ref";
    public static final String IDREF_ELEMENT = "idref";
    public static final String BEAN_REF_ATTRIBUTE = "bean";
    public static final String LOCAL_REF_ATTRIBUTE = "local";
    public static final String PARENT_REF_ATTRIBUTE = "parent";
    public static final String LIST_ELEMENT = "list";
    public static final String SET_ELEMENT = "set";
    public static final String MAP_ELEMENT = "map";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String PROPS_ELEMENT = "props";
    public static final String PROP_ELEMENT = "prop";
    public static final String VALUE_ELEMENT = "value";
    public static final String NULL_ELEMENT = "null";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private BeanDefinitionReader beanDefinitionReader;
    private Resource resource;
    private String defaultLazyInit;
    private String defaultDependencyCheck;
    private String defaultAutowire;

    public int registerBeanDefinitions(BeanDefinitionReader reader, Document doc, Resource resource) throws BeansException {
        this.beanDefinitionReader = reader;
        this.resource = resource;
        this.logger.debug((Object)"Loading bean definitions");
        Element root = doc.getDocumentElement();
        this.defaultLazyInit = root.getAttribute(DEFAULT_LAZY_INIT_ATTRIBUTE);
        this.defaultDependencyCheck = root.getAttribute(DEFAULT_DEPENDENCY_CHECK_ATTRIBUTE);
        this.defaultAutowire = root.getAttribute(DEFAULT_AUTOWIRE_ATTRIBUTE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Default lazy init '" + this.defaultLazyInit + "'"));
            this.logger.debug((Object)("Default dependency check '" + this.defaultDependencyCheck + "'"));
            this.logger.debug((Object)("Default autowire '" + this.defaultAutowire + "'"));
        }
        NodeList nl = root.getChildNodes();
        int beanDefinitionCounter = 0;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            if (IMPORT_ELEMENT.equals(node.getNodeName())) {
                this.importBeanDefinitionResource(ele);
                continue;
            }
            if (!"bean".equals(node.getNodeName())) continue;
            ++beanDefinitionCounter;
            BeanDefinitionHolder bdHolder = this.parseBeanDefinition(ele);
            BeanDefinitionReaderUtils.registerBeanDefinition(bdHolder, this.beanDefinitionReader.getBeanFactory());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found " + beanDefinitionCounter + " <" + "bean" + "> elements defining beans"));
        }
        return beanDefinitionCounter;
    }

    protected BeanDefinitionReader getBeanDefinitionReader() {
        return this.beanDefinitionReader;
    }

    protected String getDefaultLazyInit() {
        return this.defaultLazyInit;
    }

    protected String getDefaultDependencyCheck() {
        return this.defaultDependencyCheck;
    }

    protected String getDefaultAutowire() {
        return this.defaultAutowire;
    }

    protected Resource getResource() {
        return this.resource;
    }

    protected void importBeanDefinitionResource(Element ele) {
        String location = ele.getAttribute(RESOURCE_ATTRIBUTE);
        try {
            Resource relativeResource = this.resource.createRelative(location);
            this.beanDefinitionReader.loadBeanDefinitions(relativeResource);
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("Invalid relative resource location [" + location + "] to import bean definitions from", ex);
        }
    }

    protected BeanDefinitionHolder parseBeanDefinition(Element ele) {
        String beanName;
        String id = ele.getAttribute(ID_ATTRIBUTE);
        String nameAttr = ele.getAttribute(NAME_ATTRIBUTE);
        ArrayList<String> aliases = new ArrayList<String>();
        if (StringUtils.hasLength(nameAttr)) {
            String[] nameArr = StringUtils.tokenizeToStringArray(nameAttr, BEAN_NAME_DELIMITERS);
            aliases.addAll(Arrays.asList(nameArr));
        }
        if (!StringUtils.hasText(beanName = id) && !aliases.isEmpty()) {
            beanName = (String)aliases.remove(0);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No XML 'id' specified - using '" + beanName + "' as bean name and " + aliases + " as aliases"));
            }
        }
        BeanDefinition beanDefinition = this.parseBeanDefinition(ele, beanName);
        if (!StringUtils.hasText(beanName) && beanDefinition instanceof AbstractBeanDefinition) {
            beanName = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)beanDefinition, this.beanDefinitionReader.getBeanFactory());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Neither XML 'id' nor 'name' specified - using generated bean name [" + beanName + "]"));
            }
        }
        String[] aliasesArray = aliases.toArray(new String[aliases.size()]);
        return new BeanDefinitionHolder(beanDefinition, beanName, aliasesArray);
    }

    protected BeanDefinition parseBeanDefinition(Element ele, String beanName) {
        String className = null;
        if (ele.hasAttribute(CLASS_ATTRIBUTE)) {
            className = ele.getAttribute(CLASS_ATTRIBUTE);
        }
        String parent = null;
        if (ele.hasAttribute("parent")) {
            parent = ele.getAttribute("parent");
        }
        try {
            String lazyInit;
            String destroyMethodName;
            String dependencyCheck;
            ConstructorArgumentValues cargs = this.getConstructorArgSubElements(ele, beanName);
            MutablePropertyValues pvs = this.getPropertyValueSubElements(ele, beanName);
            AbstractBeanDefinition bd = BeanDefinitionReaderUtils.createBeanDefinition(className, parent, cargs, pvs, this.beanDefinitionReader.getBeanClassLoader());
            if (ele.hasAttribute(DEPENDS_ON_ATTRIBUTE)) {
                String dependsOn = ele.getAttribute(DEPENDS_ON_ATTRIBUTE);
                bd.setDependsOn(StringUtils.tokenizeToStringArray(dependsOn, BEAN_NAME_DELIMITERS));
            }
            if (ele.hasAttribute(FACTORY_METHOD_ATTRIBUTE)) {
                bd.setFactoryMethodName(ele.getAttribute(FACTORY_METHOD_ATTRIBUTE));
            }
            if (ele.hasAttribute(FACTORY_BEAN_ATTRIBUTE)) {
                bd.setFactoryBeanName(ele.getAttribute(FACTORY_BEAN_ATTRIBUTE));
            }
            if (DEFAULT_VALUE.equals(dependencyCheck = ele.getAttribute(DEPENDENCY_CHECK_ATTRIBUTE))) {
                dependencyCheck = this.defaultDependencyCheck;
            }
            bd.setDependencyCheck(this.getDependencyCheck(dependencyCheck));
            String autowire = ele.getAttribute(AUTOWIRE_ATTRIBUTE);
            if (DEFAULT_VALUE.equals(autowire)) {
                autowire = this.defaultAutowire;
            }
            bd.setAutowireMode(this.getAutowireMode(autowire));
            String initMethodName = ele.getAttribute(INIT_METHOD_ATTRIBUTE);
            if (!initMethodName.equals("")) {
                bd.setInitMethodName(initMethodName);
            }
            if (!(destroyMethodName = ele.getAttribute(DESTROY_METHOD_ATTRIBUTE)).equals("")) {
                bd.setDestroyMethodName(destroyMethodName);
            }
            this.getLookupOverrideSubElements(ele, beanName, bd.getMethodOverrides());
            this.getReplacedMethodSubElements(ele, beanName, bd.getMethodOverrides());
            bd.setResourceDescription(this.resource.getDescription());
            if (ele.hasAttribute(ABSTRACT_ATTRIBUTE)) {
                bd.setAbstract(TRUE_VALUE.equals(ele.getAttribute(ABSTRACT_ATTRIBUTE)));
            }
            if (ele.hasAttribute(SINGLETON_ATTRIBUTE)) {
                bd.setSingleton(TRUE_VALUE.equals(ele.getAttribute(SINGLETON_ATTRIBUTE)));
            }
            if (DEFAULT_VALUE.equals(lazyInit = ele.getAttribute(LAZY_INIT_ATTRIBUTE)) && bd.isSingleton()) {
                lazyInit = this.defaultLazyInit;
            }
            bd.setLazyInit(TRUE_VALUE.equals(lazyInit));
            return bd;
        }
        catch (ClassNotFoundException ex) {
            throw new BeanDefinitionStoreException(this.resource, beanName, "Bean class [" + className + "] not found", (Throwable)ex);
        }
        catch (NoClassDefFoundError err) {
            throw new BeanDefinitionStoreException(this.resource, beanName, "Class that bean class [" + className + "] depends on not found", (Throwable)err);
        }
    }

    protected ConstructorArgumentValues getConstructorArgSubElements(Element beanEle, String beanName) throws ClassNotFoundException {
        NodeList nl = beanEle.getChildNodes();
        ConstructorArgumentValues cargs = new ConstructorArgumentValues();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !CONSTRUCTOR_ARG_ELEMENT.equals(node.getNodeName())) continue;
            this.parseConstructorArgElement((Element)node, beanName, cargs);
        }
        return cargs;
    }

    protected MutablePropertyValues getPropertyValueSubElements(Element beanEle, String beanName) {
        NodeList nl = beanEle.getChildNodes();
        MutablePropertyValues pvs = new MutablePropertyValues();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !PROPERTY_ELEMENT.equals(node.getNodeName())) continue;
            this.parsePropertyElement((Element)node, beanName, pvs);
        }
        return pvs;
    }

    protected void getLookupOverrideSubElements(Element beanEle, String beanName, MethodOverrides overrides) {
        NodeList nl = beanEle.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !LOOKUP_METHOD_ELEMENT.equals(node.getNodeName())) continue;
            Element ele = (Element)node;
            String methodName = ele.getAttribute(NAME_ATTRIBUTE);
            String beanRef = ele.getAttribute("bean");
            overrides.addOverride(new LookupOverride(methodName, beanRef));
        }
    }

    protected void getReplacedMethodSubElements(Element beanEle, String beanName, MethodOverrides overrides) {
        NodeList nl = beanEle.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !REPLACED_METHOD_ELEMENT.equals(node.getNodeName())) continue;
            Element replacedMethodEle = (Element)node;
            String name = replacedMethodEle.getAttribute(NAME_ATTRIBUTE);
            String callback = replacedMethodEle.getAttribute(REPLACER_ATTRIBUTE);
            ReplaceOverride replaceOverride = new ReplaceOverride(name, callback);
            NodeList argTypeNodes = replacedMethodEle.getElementsByTagName(ARG_TYPE_ELEMENT);
            for (int j = 0; j < argTypeNodes.getLength(); ++j) {
                Element argTypeEle = (Element)argTypeNodes.item(j);
                replaceOverride.addTypeIdentifier(argTypeEle.getAttribute(ARG_TYPE_MATCH_ATTRIBUTE));
            }
            overrides.addOverride(replaceOverride);
        }
    }

    protected void parseConstructorArgElement(Element ele, String beanName, ConstructorArgumentValues cargs) throws DOMException, ClassNotFoundException {
        Object val = this.getPropertyValue(ele, beanName, null);
        String indexAttr = ele.getAttribute(INDEX_ATTRIBUTE);
        String typeAttr = ele.getAttribute(TYPE_ATTRIBUTE);
        if (StringUtils.hasLength(indexAttr)) {
            try {
                int index = Integer.parseInt(indexAttr);
                if (index < 0) {
                    throw new BeanDefinitionStoreException(this.resource, beanName, "'index' cannot be lower than 0");
                }
                if (StringUtils.hasLength(typeAttr)) {
                    cargs.addIndexedArgumentValue(index, val, typeAttr);
                }
                cargs.addIndexedArgumentValue(index, val);
            }
            catch (NumberFormatException ex) {
                throw new BeanDefinitionStoreException(this.resource, beanName, "Attribute 'index' of tag 'constructor-arg' must be an integer");
            }
        } else if (StringUtils.hasLength(typeAttr)) {
            cargs.addGenericArgumentValue(val, typeAttr);
        } else {
            cargs.addGenericArgumentValue(val);
        }
    }

    protected void parsePropertyElement(Element ele, String beanName, MutablePropertyValues pvs) {
        String propertyName = ele.getAttribute(NAME_ATTRIBUTE);
        if (!StringUtils.hasLength(propertyName)) {
            throw new BeanDefinitionStoreException(this.resource, beanName, "Tag 'property' must have a 'name' attribute");
        }
        if (pvs.contains(propertyName)) {
            throw new BeanDefinitionStoreException(this.resource, beanName, "Multiple 'property' definitions for property '" + propertyName + "'");
        }
        Object val = this.getPropertyValue(ele, beanName, propertyName);
        pvs.addPropertyValue(propertyName, val);
    }

    protected Object getPropertyValue(Element ele, String beanName, String propertyName) {
        NodeList nl = ele.getChildNodes();
        Element valueRefOrCollectionElement = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element candidateEle;
            if (!(nl.item(i) instanceof Element) || DESCRIPTION_ELEMENT.equals((candidateEle = (Element)nl.item(i)).getTagName())) continue;
            valueRefOrCollectionElement = candidateEle;
        }
        if (valueRefOrCollectionElement == null) {
            String elementName = propertyName != null ? "<property> element for property '" + propertyName + "'" : "<constructor-arg> element";
            throw new BeanDefinitionStoreException(this.resource, beanName, elementName + " must have a subelement like <value> or <ref>");
        }
        return this.parsePropertySubelement(valueRefOrCollectionElement, beanName);
    }

    protected Object parsePropertySubelement(Element ele, String beanName) {
        if (ele.getTagName().equals("bean")) {
            return this.parseBeanDefinition(ele);
        }
        if (ele.getTagName().equals(REF_ELEMENT)) {
            String beanRef = ele.getAttribute("bean");
            if (!StringUtils.hasLength(beanRef) && !StringUtils.hasLength(beanRef = ele.getAttribute(LOCAL_REF_ATTRIBUTE))) {
                beanRef = ele.getAttribute("parent");
                if (!StringUtils.hasLength(beanRef)) {
                    throw new BeanDefinitionStoreException(this.resource, beanName, "'bean', 'local' or 'parent' is required for a reference");
                }
                return new RuntimeBeanReference(beanRef, true);
            }
            return new RuntimeBeanReference(beanRef);
        }
        if (ele.getTagName().equals(IDREF_ELEMENT)) {
            String beanRef = ele.getAttribute("bean");
            if (!StringUtils.hasLength(beanRef) && !StringUtils.hasLength(beanRef = ele.getAttribute(LOCAL_REF_ATTRIBUTE))) {
                throw new BeanDefinitionStoreException(this.resource, beanName, "Either 'bean' or 'local' is required for an idref");
            }
            return beanRef;
        }
        if (ele.getTagName().equals(LIST_ELEMENT)) {
            return this.getList(ele, beanName);
        }
        if (ele.getTagName().equals(SET_ELEMENT)) {
            return this.getSet(ele, beanName);
        }
        if (ele.getTagName().equals(MAP_ELEMENT)) {
            return this.getMap(ele, beanName);
        }
        if (ele.getTagName().equals(PROPS_ELEMENT)) {
            return this.getProps(ele, beanName);
        }
        if (ele.getTagName().equals(VALUE_ELEMENT)) {
            return this.getTextValue(ele, beanName);
        }
        if (ele.getTagName().equals(NULL_ELEMENT)) {
            return null;
        }
        throw new BeanDefinitionStoreException(this.resource, beanName, "Unknown subelement of <property>: <" + ele.getTagName() + ">");
    }

    protected List getList(Element collectionEle, String beanName) {
        NodeList nl = collectionEle.getChildNodes();
        ManagedList list = new ManagedList(nl.getLength());
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element ele = (Element)nl.item(i);
            list.add(this.parsePropertySubelement(ele, beanName));
        }
        return list;
    }

    protected Set getSet(Element collectionEle, String beanName) {
        NodeList nl = collectionEle.getChildNodes();
        ManagedSet set = new ManagedSet(nl.getLength());
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element ele = (Element)nl.item(i);
            set.add(this.parsePropertySubelement(ele, beanName));
        }
        return set;
    }

    protected Map getMap(Element mapEle, String beanName) {
        List list = this.getChildElementsByTagName(mapEle, ENTRY_ELEMENT);
        ManagedMap map = new ManagedMap(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Element entryEle = (Element)list.get(i);
            String key = entryEle.getAttribute(KEY_ATTRIBUTE);
            NodeList subEles = entryEle.getElementsByTagName("*");
            map.put(key, this.parsePropertySubelement((Element)subEles.item(0), beanName));
        }
        return map;
    }

    protected List getChildElementsByTagName(Element mapEle, String elementName) {
        NodeList nl = mapEle.getChildNodes();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element) || !elementName.equals(n.getNodeName())) continue;
            nodes.add(n);
        }
        return nodes;
    }

    protected Properties getProps(Element propsEle, String beanName) {
        Properties props = new Properties();
        NodeList nl = propsEle.getElementsByTagName(PROP_ELEMENT);
        for (int i = 0; i < nl.getLength(); ++i) {
            Element propEle = (Element)nl.item(i);
            String key = propEle.getAttribute(KEY_ATTRIBUTE);
            String value = this.getTextValue(propEle, beanName).trim();
            props.setProperty(key, value);
        }
        return props;
    }

    protected String getTextValue(Element ele, String beanName) {
        StringBuffer value = new StringBuffer();
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if (item instanceof CharacterData) {
                if (item instanceof Comment) continue;
                value.append(item.getNodeValue());
                continue;
            }
            throw new BeanDefinitionStoreException(this.resource, beanName, "<value> element is just allowed to have text and comment nodes, not: " + item.getClass().getName());
        }
        return value.toString();
    }

    protected int getDependencyCheck(String att) {
        int dependencyCheckCode = 0;
        if (DEPENDENCY_CHECK_ALL_ATTRIBUTE_VALUE.equals(att)) {
            dependencyCheckCode = 3;
        } else if (DEPENDENCY_CHECK_SIMPLE_ATTRIBUTE_VALUE.equals(att)) {
            dependencyCheckCode = 2;
        } else if (DEPENDENCY_CHECK_OBJECTS_ATTRIBUTE_VALUE.equals(att)) {
            dependencyCheckCode = 1;
        }
        return dependencyCheckCode;
    }

    protected int getAutowireMode(String att) {
        int autowire = 0;
        if (AUTOWIRE_BY_NAME_VALUE.equals(att)) {
            autowire = 1;
        } else if (AUTOWIRE_BY_TYPE_VALUE.equals(att)) {
            autowire = 2;
        } else if (AUTOWIRE_CONSTRUCTOR_VALUE.equals(att)) {
            autowire = 3;
        } else if (AUTOWIRE_AUTODETECT_VALUE.equals(att)) {
            autowire = 4;
        }
        return autowire;
    }
}

