/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public abstract class AbstractCachingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver {
    private Map viewMap = new HashMap();
    private boolean cache = true;

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean isCache() {
        return this.cache;
    }

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        View view = null;
        if (!this.cache) {
            this.logger.warn((Object)"View caching is SWITCHED OFF -- DEVELOPMENT SETTING ONLY: This will severely impair performance");
            view = this.loadAndCacheView(viewName, locale);
        } else {
            view = (View)this.viewMap.get(this.getCacheKey(viewName, locale));
            if (view == null) {
                view = this.loadAndCacheView(viewName, locale);
            }
        }
        return view;
    }

    private View loadAndCacheView(String viewName, Locale locale) throws Exception {
        View view = this.loadView(viewName, locale);
        if (view instanceof ApplicationContextAware) {
            ((ApplicationContextAware)((Object)view)).setApplicationContext(this.getApplicationContext());
        }
        String cacheKey = this.getCacheKey(viewName, locale);
        this.logger.info((Object)("Cached view '" + cacheKey + "'"));
        this.viewMap.put(cacheKey, view);
        return view;
    }

    protected String getCacheKey(String viewName, Locale locale) {
        return viewName + "_" + locale;
    }

    protected abstract View loadView(String var1, Locale var2) throws Exception;
}

