/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.web.servlet.ServletConfigPropertyValues;

public abstract class HttpServletBean
extends HttpServlet {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private List requiredProperties = new ArrayList();

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    public final void init() throws ServletException {
        this.logger.info((Object)("Initializing servlet '" + this.getServletName() + "'"));
        try {
            ServletConfigPropertyValues pvs = new ServletConfigPropertyValues(this.getServletConfig(), this.requiredProperties);
            BeanWrapperImpl bw = new BeanWrapperImpl((Object)this);
            bw.setPropertyValues(pvs);
        }
        catch (BeansException ex) {
            String msg = "Failed to set bean properties on servlet '" + this.getServletName() + "': " + ex.getMessage();
            this.logger.error((Object)msg, (Throwable)ex);
            throw new ServletException(msg, (Throwable)ex);
        }
        this.initServletBean();
        this.logger.info((Object)("Servlet '" + this.getServletName() + "' configured successfully"));
    }

    protected void initServletBean() throws ServletException {
    }
}

