/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public abstract class AbstractDataFieldMaxValueIncrementer
implements DataFieldMaxValueIncrementer,
InitializingBean {
    private DataSource dataSource;
    private String incrementerName;
    private String columnName;
    private int cacheSize = 1;
    private boolean dirty = true;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public AbstractDataFieldMaxValueIncrementer() {
    }

    public AbstractDataFieldMaxValueIncrementer(DataSource ds, String incrementerName) {
        this.dataSource = ds;
        this.incrementerName = incrementerName;
    }

    public AbstractDataFieldMaxValueIncrementer(DataSource ds, String incrementerName, String columnName) {
        this.dataSource = ds;
        this.incrementerName = incrementerName;
        this.columnName = columnName;
    }

    public AbstractDataFieldMaxValueIncrementer(DataSource ds, String incrementerName, int cacheSize) {
        this.dataSource = ds;
        this.incrementerName = incrementerName;
        this.cacheSize = cacheSize;
    }

    public AbstractDataFieldMaxValueIncrementer(DataSource ds, String incrementerName, String columnName, int cacheSize) {
        this.dataSource = ds;
        this.incrementerName = incrementerName;
        this.columnName = columnName;
        this.cacheSize = cacheSize;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.dirty = true;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setIncrementerName(String incrementerName) {
        this.incrementerName = incrementerName;
        this.dirty = true;
    }

    public String getIncrementerName() {
        return this.incrementerName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
        this.dirty = true;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        this.dirty = true;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void afterPropertiesSet() throws DataAccessException {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("DataSource property must be set on " + this.getClass().getName());
        }
    }

    public int nextIntValue() throws DataAccessException {
        return this.incrementIntValue();
    }

    public long nextLongValue() throws DataAccessException {
        return this.incrementLongValue();
    }

    public double nextDoubleValue() throws DataAccessException {
        return this.incrementDoubleValue();
    }

    public String nextStringValue() throws DataAccessException {
        return this.incrementStringValue();
    }

    public Object nextValue(Class keyClass) throws DataAccessException {
        if (Integer.TYPE.getName().equals(keyClass.getName()) || (class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractDataFieldMaxValueIncrementer.class$("java.lang.Integer")) : class$java$lang$Integer).getName().equals(keyClass.getName())) {
            return new Integer(this.incrementIntValue());
        }
        if (Long.TYPE.getName().equals(keyClass.getName()) || (class$java$lang$Long == null ? (class$java$lang$Long = AbstractDataFieldMaxValueIncrementer.class$("java.lang.Long")) : class$java$lang$Long).getName().equals(keyClass.getName())) {
            return new Long(this.incrementLongValue());
        }
        if (Double.TYPE.getName().equals(keyClass.getName()) || (class$java$lang$Double == null ? (class$java$lang$Double = AbstractDataFieldMaxValueIncrementer.class$("java.lang.Double")) : class$java$lang$Double).getName().equals(keyClass.getName())) {
            return new Double(this.incrementDoubleValue());
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = AbstractDataFieldMaxValueIncrementer.class$("java.lang.String")) : class$java$lang$String).getName().equals(keyClass.getName())) {
            return this.incrementStringValue();
        }
        throw new IllegalArgumentException("Invalid key class: " + keyClass.getName());
    }

    protected abstract int incrementIntValue() throws DataAccessException;

    protected abstract long incrementLongValue() throws DataAccessException;

    protected abstract double incrementDoubleValue() throws DataAccessException;

    protected abstract String incrementStringValue() throws DataAccessException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

