/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanCircularReferenceException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;

public abstract class AbstractBeanFactory
implements AutowireCapableBeanFactory,
ConfigurableBeanFactory {
    public static final String FACTORY_BEAN_PREFIX = "&";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private BeanFactory parentBeanFactory;
    private Map customEditors = new HashMap();
    private final List beanPostProcessors = new ArrayList();
    private final Set ignoreDependencyTypes = new HashSet();
    private final Map singletonCache = new HashMap();
    private final Map aliasMap = new HashMap();
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanFactory;
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public AbstractBeanFactory() {
        this.ignoreDependencyType(class$org$springframework$beans$factory$BeanFactory == null ? (class$org$springframework$beans$factory$BeanFactory = AbstractBeanFactory.class$("org.springframework.beans.factory.BeanFactory")) : class$org$springframework$beans$factory$BeanFactory);
    }

    public AbstractBeanFactory(BeanFactory parentBeanFactory) {
        this();
        this.parentBeanFactory = parentBeanFactory;
    }

    private String transformedBeanName(String name) throws NoSuchBeanDefinitionException {
        String canonicalName;
        if (name == null) {
            throw new NoSuchBeanDefinitionException(name, "Cannot get bean with null name");
        }
        if (name.startsWith(FACTORY_BEAN_PREFIX)) {
            name = name.substring(FACTORY_BEAN_PREFIX.length());
        }
        return (canonicalName = (String)this.aliasMap.get(name)) != null ? canonicalName : name;
    }

    private boolean isFactoryDereference(String name) {
        return name.startsWith(FACTORY_BEAN_PREFIX);
    }

    public Object getBean(String name) throws BeansException {
        String beanName = this.transformedBeanName(name);
        Object sharedInstance = this.singletonCache.get(beanName);
        if (sharedInstance != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning cached instance of singleton bean '" + beanName + "'"));
            }
            return this.getObjectForSharedInstance(name, sharedInstance);
        }
        RootBeanDefinition mergedBeanDefinition = null;
        try {
            mergedBeanDefinition = this.getMergedBeanDefinition(beanName, false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (this.parentBeanFactory != null) {
                return this.parentBeanFactory.getBean(name);
            }
            throw ex;
        }
        if (mergedBeanDefinition.isSingleton()) {
            this.logger.info((Object)("Creating shared instance of singleton bean '" + beanName + "'"));
            sharedInstance = this.createBean(beanName, mergedBeanDefinition);
            return this.getObjectForSharedInstance(name, sharedInstance);
        }
        return this.createBean(name, mergedBeanDefinition);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        Object bean = this.getBean(name);
        if (!requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean);
        }
        return bean;
    }

    public boolean containsBean(String name) {
        String beanName = this.transformedBeanName(name);
        if (this.singletonCache.containsKey(beanName)) {
            return true;
        }
        try {
            this.getBeanDefinition(beanName);
            return true;
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (this.parentBeanFactory != null) {
                return this.parentBeanFactory.containsBean(beanName);
            }
            return false;
        }
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        try {
            Class beanClass = null;
            boolean singleton = true;
            Object beanInstance = this.singletonCache.get(beanName);
            if (beanInstance != null) {
                beanClass = beanInstance.getClass();
                singleton = true;
            } else {
                RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
                beanClass = bd.getBeanClass();
                singleton = bd.isSingleton();
            }
            if ((class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass) && !this.isFactoryDereference(name)) {
                FactoryBean factoryBean = (FactoryBean)this.getBean(FACTORY_BEAN_PREFIX + beanName);
                return factoryBean.isSingleton();
            }
            return singleton;
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (this.parentBeanFactory != null) {
                return this.parentBeanFactory.isSingleton(beanName);
            }
            throw ex;
        }
    }

    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        try {
            if (!this.singletonCache.containsKey(beanName)) {
                this.getBeanDefinition(beanName);
            }
            ArrayList aliases = new ArrayList();
            Iterator it = this.aliasMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!entry.getValue().equals(beanName)) continue;
                aliases.add(entry.getKey());
            }
            return aliases.toArray(new String[aliases.size()]);
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (this.parentBeanFactory != null) {
                return this.parentBeanFactory.getAliases(beanName);
            }
            throw ex;
        }
    }

    public BeanFactory getParentBeanFactory() {
        return this.parentBeanFactory;
    }

    public Object autowire(Class beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass, autowireMode, dependencyCheck);
        if (bd.getResolvedAutowireMode() == 3) {
            return this.autowireConstructor(beanClass.getName(), bd).getWrappedInstance();
        }
        Object bean = BeanUtils.instantiateClass(beanClass);
        this.populateBean(bean.getClass().getName(), bd, new BeanWrapperImpl(bean));
        return bean;
    }

    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        if (autowireMode != 1 && autowireMode != 2) {
            throw new IllegalArgumentException("Just constants AUTOWIRE_BY_NAME and AUTOWIRE_BY_TYPE allowed");
        }
        RootBeanDefinition bd = new RootBeanDefinition(existingBean.getClass(), autowireMode, dependencyCheck);
        this.populateBean(existingBean.getClass().getName(), bd, new BeanWrapperImpl(existingBean));
    }

    public Object applyBeanPostProcessorsBeforeInitialization(Object bean, String name) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking BeanPostProcessors before initialization of bean '" + name + "'"));
        }
        Object result = bean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessBeforeInitialization(result, name);
        }
        return result;
    }

    public Object applyBeanPostProcessorsAfterInitialization(Object bean, String name) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking BeanPostProcessors after initialization of bean '" + name + "'"));
        }
        Object result = bean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessAfterInitialization(result, name);
        }
        return result;
    }

    public void setParentBeanFactory(BeanFactory parentBeanFactory) {
        this.parentBeanFactory = parentBeanFactory;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.customEditors.put(requiredType, propertyEditor);
    }

    public Map getCustomEditors() {
        return this.customEditors;
    }

    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        this.beanPostProcessors.add(beanPostProcessor);
    }

    public List getBeanPostProcessors() {
        return this.beanPostProcessors;
    }

    public void ignoreDependencyType(Class type) {
        this.ignoreDependencyTypes.add(type);
    }

    public Set getIgnoredDependencyTypes() {
        return this.ignoreDependencyTypes;
    }

    public MutablePropertyValues getPropertyValues(String beanName) throws BeansException {
        return this.getBeanDefinition(beanName).getPropertyValues();
    }

    public ConstructorArgumentValues getConstructorArgumentValues(String beanName) throws BeansException {
        AbstractBeanDefinition bd = this.getBeanDefinition(beanName);
        return bd instanceof RootBeanDefinition ? ((RootBeanDefinition)bd).getConstructorArgumentValues() : null;
    }

    public void registerAlias(String beanName, String alias) throws BeanDefinitionStoreException {
        this.logger.debug((Object)("Registering alias '" + alias + "' for bean with name '" + beanName + "'"));
        Object registeredName = this.aliasMap.get(alias);
        if (registeredName != null) {
            throw new BeanDefinitionStoreException("Cannot register alias '" + alias + "' for bean name '" + beanName + "': it's already registered for bean name '" + registeredName + "'");
        }
        this.aliasMap.put(alias, beanName);
    }

    public void registerSingleton(String beanName, Object singletonObject) throws BeanDefinitionStoreException {
        Object oldObject = this.singletonCache.get(beanName);
        if (oldObject != null) {
            throw new BeanDefinitionStoreException("Could not register object [" + singletonObject + "] under bean name '" + beanName + "': there's already object [" + oldObject + " bound");
        }
        this.singletonCache.put(beanName, singletonObject);
    }

    public void destroySingletons() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Destroying singletons in factory {" + this + "}"));
        }
        HashSet singletonCacheKeys = new HashSet(this.singletonCache.keySet());
        Iterator it = singletonCacheKeys.iterator();
        while (it.hasNext()) {
            this.destroyBean((String)it.next());
        }
    }

    public String[] getSingletonNames(Class type) {
        Set keys = this.singletonCache.keySet();
        HashSet<String> matches = new HashSet<String>();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            Object singletonObject = this.singletonCache.get(name);
            if (type != null && !type.isAssignableFrom(singletonObject.getClass())) continue;
            matches.add(name);
        }
        return matches.toArray(new String[matches.size()]);
    }

    public RootBeanDefinition getMergedBeanDefinition(String beanName, boolean includingAncestors) throws BeansException {
        try {
            return this.getMergedBeanDefinition(beanName, this.getBeanDefinition(beanName));
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (includingAncestors && this.parentBeanFactory instanceof AbstractBeanFactory) {
                return ((AbstractBeanFactory)this.parentBeanFactory).getMergedBeanDefinition(beanName, true);
            }
            throw ex;
        }
    }

    protected RootBeanDefinition getMergedBeanDefinition(String beanName, AbstractBeanDefinition bd) {
        if (bd instanceof RootBeanDefinition) {
            return (RootBeanDefinition)bd;
        }
        if (bd instanceof ChildBeanDefinition) {
            ChildBeanDefinition cbd = (ChildBeanDefinition)bd;
            RootBeanDefinition rbd = new RootBeanDefinition(this.getMergedBeanDefinition(cbd.getParentName(), true));
            for (int i = 0; i < cbd.getPropertyValues().getPropertyValues().length; ++i) {
                rbd.getPropertyValues().addPropertyValue(cbd.getPropertyValues().getPropertyValues()[i]);
            }
            rbd.setSingleton(cbd.isSingleton());
            rbd.setLazyInit(cbd.isLazyInit());
            rbd.setResourceDescription(cbd.getResourceDescription());
            return rbd;
        }
        throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanName, "Definition is neither a RootBeanDefinition nor a ChildBeanDefinition");
    }

    protected Object getObjectForSharedInstance(String name, Object beanInstance) {
        String beanName = this.transformedBeanName(name);
        if (this.isFactoryDereference(name) && !(beanInstance instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(beanName, beanInstance);
        }
        if (beanInstance instanceof FactoryBean) {
            if (!this.isFactoryDereference(name)) {
                FactoryBean factory = (FactoryBean)beanInstance;
                this.logger.debug((Object)("Bean with name '" + beanName + "' is a factory bean"));
                try {
                    beanInstance = factory.getObject();
                }
                catch (BeansException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new BeanCreationException("FactoryBean threw exception on object creation", ex);
                }
                if (beanInstance == null) {
                    throw new FactoryBeanCircularReferenceException("Factory bean '" + beanName + "' returned null object - " + "possible cause: not fully initialized due to circular bean reference");
                }
            } else {
                this.logger.debug((Object)("Calling code asked for FactoryBean instance for name '" + beanName + "'"));
            }
        }
        return beanInstance;
    }

    protected Object createBean(String beanName, RootBeanDefinition mergedBeanDefinition) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating instance of bean '" + beanName + "' with merged definition [" + mergedBeanDefinition + "]"));
        }
        if (mergedBeanDefinition.getDependsOn() != null) {
            for (int i = 0; i < mergedBeanDefinition.getDependsOn().length; ++i) {
                this.getBean(mergedBeanDefinition.getDependsOn()[i]);
            }
        }
        BeanWrapper instanceWrapper = null;
        if (mergedBeanDefinition.getResolvedAutowireMode() == 3 || mergedBeanDefinition.hasConstructorArgumentValues()) {
            instanceWrapper = this.autowireConstructor(beanName, mergedBeanDefinition);
        } else {
            instanceWrapper = new BeanWrapperImpl(mergedBeanDefinition.getBeanClass());
            this.initBeanWrapper(instanceWrapper);
        }
        Object bean = instanceWrapper.getWrappedInstance();
        if (mergedBeanDefinition.isSingleton()) {
            this.singletonCache.put(beanName, bean);
        }
        this.populateBean(beanName, mergedBeanDefinition, instanceWrapper);
        try {
            if (bean instanceof BeanNameAware) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking setBeanName() on BeanNameAware bean '" + beanName + "'"));
                }
                ((BeanNameAware)bean).setBeanName(beanName);
            }
            if (bean instanceof BeanFactoryAware) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking setBeanFactory() on BeanFactoryAware bean '" + beanName + "'"));
                }
                ((BeanFactoryAware)bean).setBeanFactory(this);
            }
            bean = this.applyBeanPostProcessorsBeforeInitialization(bean, beanName);
            this.invokeInitMethods(bean, beanName, mergedBeanDefinition, instanceWrapper);
            bean = this.applyBeanPostProcessorsAfterInitialization(bean, beanName);
        }
        catch (MethodInvocationException ex) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Initialization method of bean failed", ex.getCause());
        }
        catch (Exception ex) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Initialization method of bean failed", ex);
        }
        if (mergedBeanDefinition.isSingleton()) {
            this.singletonCache.put(beanName, bean);
        }
        return bean;
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        Iterator it = this.customEditors.keySet().iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            bw.registerCustomEditor(clazz, (PropertyEditor)this.customEditors.get(clazz));
        }
    }

    protected BeanWrapper autowireConstructor(String beanName, RootBeanDefinition mergedBeanDefinition) throws BeansException {
        ConstructorArgumentValues cargs = mergedBeanDefinition.getConstructorArgumentValues();
        ConstructorArgumentValues resolvedValues = new ConstructorArgumentValues();
        int minNrOfArgs = 0;
        if (cargs != null) {
            minNrOfArgs = cargs.getNrOfArguments();
            Iterator it = cargs.getIndexedArgumentValues().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int index = (Integer)entry.getKey();
                if (index < 0) {
                    throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Invalid constructor argument index: " + index);
                }
                if (index > minNrOfArgs) {
                    minNrOfArgs = index + 1;
                }
                String argName = "constructor argument with index " + index;
                Object resolvedValue = this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName, entry.getValue());
                resolvedValues.addIndexedArgumentValue(index, resolvedValue);
            }
            it = cargs.getGenericArgumentValues().iterator();
            while (it.hasNext()) {
                Map.Entry value = it.next();
                String argName = "constructor argument";
                Object resolvedValue = this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName, value);
                resolvedValues.addGenericArgumentValue(resolvedValue);
            }
        }
        Constructor<?>[] constructors = mergedBeanDefinition.getBeanClass().getConstructors();
        Arrays.sort(constructors, new Comparator(){

            public int compare(Object o1, Object o2) {
                int c1pl = ((Constructor)o1).getParameterTypes().length;
                int c2pl = ((Constructor)o2).getParameterTypes().length;
                return new Integer(c1pl).compareTo(new Integer(c2pl)) * -1;
            }
        });
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.initBeanWrapper(bw);
        Constructor<?> constructorToUse = null;
        Object[] argsToUse = null;
        int minTypeDiffWeight = Integer.MAX_VALUE;
        for (int i = 0; i < constructors.length; ++i) {
            try {
                Constructor<?> constructor = constructors[i];
                if (constructor.getParameterTypes().length < minNrOfArgs) {
                    throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, minNrOfArgs + " constructor arguments specified but no matching constructor found in bean '" + beanName + "' (hint: specify index arguments for simple parameters to avoid type ambiguities)");
                }
                Class[] argTypes = constructor.getParameterTypes();
                Object[] args = new Object[argTypes.length];
                for (int j = 0; j < argTypes.length; ++j) {
                    args[j] = resolvedValues.getArgumentValue(j, argTypes[j]);
                    if (args[j] != null) {
                        args[j] = bw.doTypeConversionIfNecessary(args[j], argTypes[j]);
                        continue;
                    }
                    if (mergedBeanDefinition.getResolvedAutowireMode() != 3) {
                        throw new UnsatisfiedDependencyException(beanName, j, argTypes[j]);
                    }
                    Map matchingBeans = this.findMatchingBeans(argTypes[j]);
                    if (matchingBeans.size() != 1) {
                        throw new UnsatisfiedDependencyException(beanName, j, argTypes[j], "There are " + matchingBeans.size() + " beans of type [" + argTypes[j] + "] for autowiring constructor. " + "There should have been 1 to be able to autowire constructor of bean '" + beanName + "'.");
                    }
                    args[j] = matchingBeans.values().iterator().next();
                    this.logger.info((Object)("Autowiring by type from bean name '" + beanName + "' via constructor to bean named '" + matchingBeans.keySet().iterator().next() + "'"));
                }
                int typeDiffWeight = this.getTypeDifferenceWeight(argTypes, args);
                if (typeDiffWeight >= minTypeDiffWeight) continue;
                constructorToUse = constructor;
                argsToUse = args;
                minTypeDiffWeight = typeDiffWeight;
                continue;
            }
            catch (BeansException ex) {
                this.logger.debug((Object)("Ignoring constructor [" + constructors[i] + "] of bean '" + beanName + "': could not satisfy dependencies. Detail: " + ex.getMessage()));
                if (i != constructors.length - 1 || constructorToUse != null) continue;
                throw ex;
            }
        }
        bw.setWrappedInstance(BeanUtils.instantiateClass(constructorToUse, argsToUse));
        this.logger.info((Object)("Bean '" + beanName + "' instantiated via constructor [" + constructorToUse + "]"));
        return bw;
    }

    private int getTypeDifferenceWeight(Class[] argTypes, Object[] args) {
        int result = 0;
        for (int i = 0; i < argTypes.length; ++i) {
            if (!argTypes[i].isInstance(args[i])) continue;
            Class<?> superClass = args[i].getClass().getSuperclass();
            while (superClass != null) {
                if (argTypes[i].isAssignableFrom(superClass)) {
                    ++result;
                    superClass = superClass.getSuperclass();
                    continue;
                }
                superClass = null;
            }
        }
        return result;
    }

    protected void populateBean(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw) {
        MutablePropertyValues pvs = mergedBeanDefinition.getPropertyValues();
        if (mergedBeanDefinition.getResolvedAutowireMode() == 1 || mergedBeanDefinition.getResolvedAutowireMode() == 2) {
            MutablePropertyValues mpvs = new MutablePropertyValues(pvs);
            if (mergedBeanDefinition.getResolvedAutowireMode() == 1) {
                this.autowireByName(beanName, mergedBeanDefinition, bw, mpvs);
            }
            if (mergedBeanDefinition.getResolvedAutowireMode() == 2) {
                this.autowireByType(beanName, mergedBeanDefinition, bw, mpvs);
            }
            pvs = mpvs;
        }
        this.dependencyCheck(beanName, mergedBeanDefinition, bw, pvs);
        this.applyPropertyValues(beanName, mergedBeanDefinition, bw, pvs);
    }

    protected void autowireByName(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, MutablePropertyValues pvs) {
        String[] propertyNames = this.unsatisfiedObjectProperties(mergedBeanDefinition, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (this.containsBean(propertyName)) {
                Object bean = this.getBean(propertyName);
                pvs.addPropertyValue(propertyName, bean);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added autowiring by name from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + propertyName + "'"));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by name: no matching bean found"));
        }
    }

    protected void autowireByType(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, MutablePropertyValues pvs) {
        String[] propertyNames = this.unsatisfiedObjectProperties(mergedBeanDefinition, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            Class<?> requiredType = bw.getPropertyDescriptor(propertyName).getPropertyType();
            Map matchingBeans = this.findMatchingBeans(requiredType);
            if (matchingBeans.size() == 1) {
                pvs.addPropertyValue(propertyName, matchingBeans.values().iterator().next());
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + matchingBeans.keySet().iterator().next() + "'"));
                continue;
            }
            if (matchingBeans.size() > 1) {
                throw new UnsatisfiedDependencyException(beanName, propertyName, "There are " + matchingBeans.size() + " beans of type [" + requiredType + "] for autowire by type. " + "There should have been 1 to be able to autowire property '" + propertyName + "' of bean '" + beanName + "'.");
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by type: no matching bean found"));
        }
    }

    protected void dependencyCheck(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, PropertyValues pvs) throws UnsatisfiedDependencyException {
        int dependencyCheck = mergedBeanDefinition.getDependencyCheck();
        if (dependencyCheck == 0) {
            return;
        }
        Set ignoreTypes = this.getIgnoredDependencyTypes();
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            boolean unsatisfied;
            if (pds[i].getWriteMethod() == null || ignoreTypes.contains(pds[i].getPropertyType()) || pvs.getPropertyValue(pds[i].getName()) != null) continue;
            boolean isSimple = BeanUtils.isSimpleProperty(pds[i].getPropertyType());
            boolean bl = unsatisfied = dependencyCheck == 3 || isSimple && dependencyCheck == 2 || !isSimple && dependencyCheck == 1;
            if (!unsatisfied) continue;
            throw new UnsatisfiedDependencyException(beanName, pds[i].getName());
        }
    }

    protected String[] unsatisfiedObjectProperties(RootBeanDefinition mergedBeanDefinition, BeanWrapper bw) {
        TreeSet<String> result = new TreeSet<String>();
        Set ignoreTypes = this.getIgnoredDependencyTypes();
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            String name = pds[i].getName();
            if (pds[i].getWriteMethod() == null || BeanUtils.isSimpleProperty(pds[i].getPropertyType()) || ignoreTypes.contains(pds[i].getPropertyType()) || mergedBeanDefinition.getPropertyValues().getPropertyValue(name) != null) continue;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    protected void applyPropertyValues(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, PropertyValues pvs) throws BeansException {
        if (pvs == null) {
            return;
        }
        MutablePropertyValues deepCopy = new MutablePropertyValues(pvs);
        PropertyValue[] pvals = deepCopy.getPropertyValues();
        for (int i = 0; i < pvals.length; ++i) {
            Object value = this.resolveValueIfNecessary(beanName, mergedBeanDefinition, pvals[i].getName(), pvals[i].getValue());
            PropertyValue pv = new PropertyValue(pvals[i].getName(), value);
            deepCopy.setPropertyValueAt(pv, i);
        }
        try {
            bw.setPropertyValues(deepCopy);
        }
        catch (BeansException ex) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Error setting property values", ex);
        }
    }

    protected Object resolveValueIfNecessary(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, Object value) throws BeansException {
        if (value instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition bd = (AbstractBeanDefinition)value;
            bd.setSingleton(false);
            String innerBeanName = "(inner bean for property '" + beanName + "." + argName + "')";
            Object beanInstance = this.createBean(innerBeanName, this.getMergedBeanDefinition(innerBeanName, bd));
            return this.getObjectForSharedInstance(innerBeanName, beanInstance);
        }
        if (value instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref = (RuntimeBeanReference)value;
            return this.resolveReference(mergedBeanDefinition, beanName, argName, ref);
        }
        if (value instanceof ManagedList) {
            return this.resolveManagedList(beanName, mergedBeanDefinition, argName, (ManagedList)value);
        }
        if (value instanceof ManagedSet) {
            return this.resolveManagedSet(beanName, mergedBeanDefinition, argName, (ManagedSet)value);
        }
        if (value instanceof ManagedMap) {
            ManagedMap mm = (ManagedMap)value;
            return this.resolveManagedMap(beanName, mergedBeanDefinition, argName, mm);
        }
        return value;
    }

    protected Object resolveReference(RootBeanDefinition mergedBeanDefinition, String beanName, String argName, RuntimeBeanReference ref) throws BeansException {
        try {
            this.logger.debug((Object)("Resolving reference from property '" + argName + "' in bean '" + beanName + "' to bean '" + ref.getBeanName() + "'"));
            return this.getBean(ref.getBeanName());
        }
        catch (BeansException ex) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Can't resolve reference to bean '" + ref.getBeanName() + "' while setting property '" + argName + "'", ex);
        }
    }

    protected List resolveManagedList(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, ManagedList ml) throws BeansException {
        ArrayList<Object> resolved = new ArrayList<Object>();
        for (int i = 0; i < ml.size(); ++i) {
            resolved.add(this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName + "[" + i + "]", ml.get(i)));
        }
        return resolved;
    }

    protected Set resolveManagedSet(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, ManagedSet ms) throws BeansException {
        HashSet<Object> resolved = new HashSet<Object>();
        Iterator it = ms.iterator();
        while (it.hasNext()) {
            resolved.add(this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName + "[(set-element)]", it.next()));
        }
        return resolved;
    }

    protected Map resolveManagedMap(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, ManagedMap mm) throws BeansException {
        HashMap resolved = new HashMap();
        Iterator keys = mm.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            resolved.put(key, this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName + "[" + key + "]", mm.get(key)));
        }
        return resolved;
    }

    protected void invokeInitMethods(Object bean, String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw) throws Exception {
        if (bean instanceof InitializingBean) {
            this.logger.debug((Object)("Calling afterPropertiesSet() on bean with beanName '" + beanName + "'"));
            ((InitializingBean)bean).afterPropertiesSet();
        }
        if (mergedBeanDefinition.getInitMethodName() != null) {
            this.logger.debug((Object)("Calling custom init method '" + mergedBeanDefinition.getInitMethodName() + "' on bean with beanName '" + beanName + "'"));
            bw.invoke(mergedBeanDefinition.getInitMethodName(), null);
        }
    }

    protected void destroyBean(String beanName) {
        Object bean = this.singletonCache.get(beanName);
        if (bean != null) {
            this.logger.debug((Object)("Retrieving depending beans for bean '" + beanName + "'"));
            String[] dependingBeans = this.getDependingBeanNames(beanName);
            for (int i = 0; i < dependingBeans.length; ++i) {
                this.destroyBean(dependingBeans[i]);
            }
            if (bean instanceof DisposableBean) {
                this.logger.debug((Object)("Calling destroy() on bean with name '" + beanName + "'"));
                try {
                    ((DisposableBean)bean).destroy();
                }
                catch (Exception ex) {
                    this.logger.error((Object)("destroy() on bean with name '" + beanName + "' threw an exception"), (Throwable)ex);
                }
            }
            try {
                RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
                if (bd.getDestroyMethodName() != null) {
                    this.logger.debug((Object)("Calling custom destroy method '" + bd.getDestroyMethodName() + "' on bean with name '" + beanName + "'"));
                    BeanWrapperImpl bw = new BeanWrapperImpl(bean);
                    try {
                        bw.invoke(bd.getDestroyMethodName(), null);
                    }
                    catch (MethodInvocationException ex) {
                        this.logger.error((Object)ex.getMessage(), ex.getCause());
                    }
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                // empty catch block
            }
            this.singletonCache.remove(beanName);
        }
    }

    public abstract AbstractBeanDefinition getBeanDefinition(String var1) throws BeansException;

    protected abstract String[] getDependingBeanNames(String var1) throws BeansException;

    protected abstract Map findMatchingBeans(Class var1) throws BeansException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

