/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.adapter;

import java.util.LinkedList;
import java.util.List;
import org.aopalliance.intercept.Interceptor;
import org.springframework.aop.Advisor;
import org.springframework.aop.InterceptionAroundAdvisor;
import org.springframework.aop.framework.adapter.AdvisorAdapter;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.AfterReturningAdviceAdapter;
import org.springframework.aop.framework.adapter.BeforeAdviceAdapter;
import org.springframework.aop.framework.adapter.ThrowsAdviceAdapter;
import org.springframework.aop.framework.adapter.UnknownAdviceTypeException;
import org.springframework.aop.support.DefaultInterceptionAroundAdvisor;

public class DefaultAdvisorAdapterRegistry
implements AdvisorAdapterRegistry {
    private List adapters = new LinkedList();

    public DefaultAdvisorAdapterRegistry() {
        this.registerAdvisorAdapter(new BeforeAdviceAdapter());
        this.registerAdvisorAdapter(new AfterReturningAdviceAdapter());
        this.registerAdvisorAdapter(new ThrowsAdviceAdapter());
    }

    public Advisor wrap(Object advice) throws UnknownAdviceTypeException {
        if (advice instanceof Advisor) {
            return (Advisor)advice;
        }
        if (advice instanceof Interceptor) {
            return new DefaultInterceptionAroundAdvisor((Interceptor)advice);
        }
        for (int i = 0; i < this.adapters.size(); ++i) {
            AdvisorAdapter adapter = (AdvisorAdapter)this.adapters.get(i);
            if (!adapter.supportsAdvice(advice)) continue;
            return adapter.wrap(advice);
        }
        throw new UnknownAdviceTypeException(advice);
    }

    public Interceptor getInterceptor(Advisor advisor) throws UnknownAdviceTypeException {
        if (advisor instanceof InterceptionAroundAdvisor) {
            return ((InterceptionAroundAdvisor)advisor).getInterceptor();
        }
        for (int i = 0; i < this.adapters.size(); ++i) {
            AdvisorAdapter adapter = (AdvisorAdapter)this.adapters.get(i);
            if (!adapter.supportsAdvisor(advisor)) continue;
            return adapter.getInterceptor(advisor);
        }
        throw new UnknownAdviceTypeException(advisor);
    }

    public void registerAdvisorAdapter(AdvisorAdapter adapter) {
        this.adapters.add(adapter);
    }
}

