/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.web.filter.FilterConfigPropertyValues;

public abstract class GenericFilterBean
implements Filter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List requiredProperties = new ArrayList();
    private FilterConfig filterConfig;

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        this.logger.info((Object)("Initializing filter '" + filterConfig.getFilterName() + "'"));
        this.filterConfig = filterConfig;
        try {
            FilterConfigPropertyValues pvs = new FilterConfigPropertyValues(filterConfig, this.requiredProperties);
            BeanWrapperImpl bw = new BeanWrapperImpl(this);
            bw.setPropertyValues(pvs);
        }
        catch (BeansException ex) {
            String msg = "Failed to set bean properties on filter '" + filterConfig.getFilterName() + "': " + ex.getMessage();
            this.logger.error((Object)msg, (Throwable)ex);
            throw new ServletException(msg, (Throwable)ex);
        }
        this.initFilterBean();
        this.logger.info((Object)("Filter '" + filterConfig.getFilterName() + "' configured successfully"));
    }

    protected final FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected final String getFilterName() {
        return this.filterConfig.getFilterName();
    }

    protected final ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected void initFilterBean() throws ServletException {
    }

    public void destroy() {
    }
}

