/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.util.Properties;
import org.aopalliance.intercept.AspectException;
import org.aopalliance.intercept.Interceptor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.support.AopUtils;
import org.springframework.aop.support.DefaultInterceptionAroundAdvisor;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSourceTransactionAroundAdvisor;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class TransactionProxyFactoryBean
extends ProxyConfig
implements FactoryBean,
InitializingBean {
    private PlatformTransactionManager transactionManager;
    private Object target;
    private Properties transactionAttributes;
    private Class[] interfaces;
    private Pointcut pointcut;
    private Interceptor[] preInterceptors;
    private Interceptor[] postInterceptors;
    private Object proxy;

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setTransactionAttributes(Properties transactionAttributes) {
        this.transactionAttributes = transactionAttributes;
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public void setPreInterceptors(Interceptor[] preInterceptors) {
        this.preInterceptors = preInterceptors;
    }

    public void setPostInterceptors(Interceptor[] preInterceptors) {
        this.postInterceptors = preInterceptors;
    }

    public void setProxyInterfaces(String[] interfaceNames) throws AspectException, ClassNotFoundException {
        this.interfaces = AopUtils.toInterfaceArray(interfaceNames);
    }

    public void afterPropertiesSet() throws AopConfigException {
        if (this.target == null) {
            throw new AopConfigException("Target must be set");
        }
        if (this.transactionAttributes == null) {
            throw new AopConfigException("'transactionAttributes' property must be set: if there are no transaction methods, don't use a transactional proxy");
        }
        NameMatchTransactionAttributeSource tas = new NameMatchTransactionAttributeSource();
        tas.setProperties(this.transactionAttributes);
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor();
        transactionInterceptor.setTransactionManager(this.transactionManager);
        transactionInterceptor.setTransactionAttributeSource(tas);
        transactionInterceptor.afterPropertiesSet();
        ProxyFactory proxyFactory = new ProxyFactory();
        if (this.preInterceptors != null) {
            for (int i = 0; i < this.preInterceptors.length; ++i) {
                proxyFactory.addInterceptor(this.preInterceptors[i]);
            }
        }
        if (this.pointcut != null) {
            DefaultInterceptionAroundAdvisor advice = new DefaultInterceptionAroundAdvisor(this.pointcut, (Interceptor)transactionInterceptor);
            proxyFactory.addAdvisor(advice);
        } else {
            proxyFactory.addAdvisor(new TransactionAttributeSourceTransactionAroundAdvisor(transactionInterceptor));
        }
        if (this.postInterceptors != null) {
            for (int i = 0; i < this.postInterceptors.length; ++i) {
                proxyFactory.addInterceptor(this.postInterceptors[i]);
            }
        }
        proxyFactory.copyFrom(this);
        proxyFactory.setTargetSource(this.createTargetSource(this.target));
        if (this.interfaces != null) {
            proxyFactory.setInterfaces(this.interfaces);
        } else if (!this.getProxyTargetClass()) {
            proxyFactory.setInterfaces(AopUtils.getAllInterfaces(this.target));
        }
        this.proxy = proxyFactory.getProxy();
    }

    protected TargetSource createTargetSource(Object pTarget) {
        if (pTarget instanceof TargetSource) {
            return (TargetSource)pTarget;
        }
        return new SingletonTargetSource(pTarget);
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        if (this.proxy != null) {
            return this.proxy.getClass();
        }
        if (this.target != null) {
            return this.target.getClass();
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }
}

