/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.support;

import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.BeanFactoryLoader;
import org.springframework.beans.factory.support.BootstrapException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jndi.JndiTemplate;
import org.springframework.util.StringUtils;

public class XmlBeanFactoryLoader
implements BeanFactoryLoader {
    public static final String BEAN_FACTORY_PATH_ENVIRONMENT_KEY = "java:comp/env/ejb/BeanFactoryPath";
    public static final String BEAN_FACTORY_PATH_DELIMITERS = ",; ";
    private final Log logger = LogFactory.getLog(this.getClass());

    public BeanFactory loadBeanFactory() throws BootstrapException {
        String beanFactoryPath = null;
        try {
            beanFactoryPath = (String)new JndiTemplate().lookup(BEAN_FACTORY_PATH_ENVIRONMENT_KEY);
            this.logger.info((Object)("BeanFactoryPath from JNDI is [" + beanFactoryPath + "]"));
            DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(beanFactory);
            String[] paths = StringUtils.tokenizeToStringArray(beanFactoryPath, BEAN_FACTORY_PATH_DELIMITERS, true, true);
            for (int i = 0; i < paths.length; ++i) {
                reader.loadBeanDefinitions(new ClassPathResource(paths[i]));
            }
            beanFactory.preInstantiateSingletons();
            this.logger.info((Object)("Loaded BeanFactory [" + beanFactory + "]"));
            return beanFactory;
        }
        catch (NamingException ex) {
            throw new BootstrapException("Define an environment variable 'ejb/BeanFactoryPath' containing the location on the class path of an XmlBeanFactory" + ex.getMessage(), ex);
        }
        catch (BeanDefinitionStoreException ex) {
            throw new BootstrapException("Found resource at '" + beanFactoryPath + "' but it's not a valid Spring bean definition XML file: " + ex.getMessage(), null);
        }
    }

    public void unloadBeanFactory(BeanFactory beanFactory) throws FatalBeanException {
    }
}

