/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.jasperreports;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRBshCompiler;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.Resource;
import org.springframework.ui.jasperreports.JasperReportsUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public abstract class AbstractJasperReportsView
extends AbstractUrlBasedView {
    private static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_DISPOSITION_INLINE = "inline";
    private String reportDataKey;
    private Properties subReportUrls;
    private String[] subReportDataKeys;
    private JasperReport report;
    private Map subReports;
    private Properties headers;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JRDataSource;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public void setReportDataKey(String reportDataKey) {
        this.reportDataKey = reportDataKey;
    }

    public void setSubReportUrls(Properties subReports) {
        this.subReportUrls = subReports;
    }

    public void setSubReportDataKeys(String[] subReportDataKeys) {
        this.subReportDataKeys = subReportDataKeys;
    }

    public void setHeaders(Properties headers) {
        this.headers = headers;
    }

    protected void initApplicationContext() throws ApplicationContextException {
        super.initApplicationContext();
        Resource mainReport = this.getApplicationContext().getResource(this.getUrl());
        this.report = this.loadReport(mainReport);
        if (this.subReportUrls != null) {
            if (this.subReportDataKeys != null && this.subReportDataKeys.length > 0 && this.reportDataKey == null) {
                throw new ApplicationContextException("'reportDataKey' for main report is required when specifying a value for 'subReportDataKeys'");
            }
            this.subReports = new HashMap(this.subReportUrls.size());
            Enumeration<?> urls = this.subReportUrls.propertyNames();
            while (urls.hasMoreElements()) {
                String key = (String)urls.nextElement();
                String path = this.subReportUrls.getProperty(key);
                Resource resource = this.getApplicationContext().getResource(path);
                this.subReports.put(key, this.loadReport(resource));
            }
        }
        if (this.headers == null) {
            this.headers = new Properties();
        }
        if (!this.headers.containsKey(HEADER_CONTENT_DISPOSITION)) {
            this.headers.setProperty(HEADER_CONTENT_DISPOSITION, CONTENT_DISPOSITION_INLINE);
        }
    }

    private JasperReport loadReport(Resource resource) {
        try {
            String fileName = resource.getFilename();
            if (fileName.endsWith(".jasper")) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loading pre-compiled Jasper Report from " + resource));
                }
                return (JasperReport)JRLoader.loadObject((InputStream)resource.getInputStream());
            }
            if (fileName.endsWith(".jrxml")) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Compiling Jasper Report loaded from " + resource));
                }
                JasperDesign design = JRXmlLoader.load((InputStream)resource.getInputStream());
                return this.getReportCompiler().compileReport(design);
            }
            throw new IllegalArgumentException("Report URL [" + this.getUrl() + "] must end in either .jasper or .jrxml");
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Could not load JasperReports report for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
        catch (JRException ex) {
            throw new ApplicationContextException("Could not parse JasperReports report for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
    }

    protected JRCompiler getReportCompiler() {
        return new JRBshCompiler();
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(this.getContentType());
        JRDataSource dataSource = this.getReportData(model);
        if (this.subReports != null) {
            model.putAll(this.subReports);
            if (this.subReportDataKeys != null) {
                for (int i = 0; i < this.subReportDataKeys.length; ++i) {
                    String key = this.subReportDataKeys[i];
                    model.put(key, this.convertReportData(model.get(key)));
                }
            }
        }
        this.renderReport(this.report, model, dataSource, response);
    }

    protected JRDataSource getReportData(Map model) throws IllegalArgumentException {
        if (this.reportDataKey != null) {
            Object value = model.get(this.reportDataKey);
            return this.convertReportData(value);
        }
        Object value = CollectionUtils.findValueOfType(model.values(), (Class[])this.getReportDataTypes());
        if (value != null) {
            return this.convertReportData(value);
        }
        throw new IllegalArgumentException("No report data supplied in model " + model);
    }

    protected JRDataSource convertReportData(Object value) throws IllegalArgumentException {
        return JasperReportsUtils.convertReportData((Object)value);
    }

    protected Class[] getReportDataTypes() {
        return new Class[]{class$net$sf$jasperreports$engine$JRDataSource == null ? (class$net$sf$jasperreports$engine$JRDataSource = AbstractJasperReportsView.class$("net.sf.jasperreports.engine.JRDataSource")) : class$net$sf$jasperreports$engine$JRDataSource, class$java$util$Collection == null ? (class$java$util$Collection = AbstractJasperReportsView.class$("java.util.Collection")) : class$java$util$Collection, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbstractJasperReportsView.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
    }

    protected void renderReport(JasperReport report, Map parameters, JRDataSource dataSource, HttpServletResponse response) throws Exception {
        JRAbstractExporter exporter = this.createExporter();
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, (Map)parameters, (JRDataSource)dataSource);
        Enumeration<?> en = this.headers.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            response.addHeader(key, this.headers.getProperty(key));
        }
        if (this.useWriter()) {
            JasperReportsUtils.render((JRAbstractExporter)exporter, (JasperPrint)print, (Writer)response.getWriter());
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JasperReportsUtils.render((JRAbstractExporter)exporter, (JasperPrint)print, (OutputStream)baos);
            response.setContentLength(baos.size());
            ServletOutputStream out = response.getOutputStream();
            baos.writeTo((OutputStream)out);
            out.flush();
        }
    }

    protected abstract JRAbstractExporter createExporter();

    protected abstract boolean useWriter();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

