/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.util.HtmlUtils;

public class BindStatus {
    private final RequestContext requestContext;
    private final String path;
    private final boolean htmlEscape;
    private final String expression;
    private Object value;
    private final String[] errorCodes;
    private final String[] errorMessages;
    private final Errors errors;
    private PropertyEditor editor;

    public BindStatus(RequestContext requestContext, String path, boolean htmlEscape) throws IllegalStateException {
        this.requestContext = requestContext;
        this.path = path;
        this.htmlEscape = htmlEscape;
        String beanName = null;
        int dotPos = path.indexOf(46);
        if (dotPos == -1) {
            beanName = path;
            this.expression = null;
        } else {
            beanName = path.substring(0, dotPos);
            this.expression = path.substring(dotPos + 1);
        }
        this.errors = requestContext.getErrors(beanName, false);
        if (this.errors != null) {
            List objectErrors = null;
            if (this.expression != null) {
                if ("*".equals(this.expression)) {
                    objectErrors = this.errors.getAllErrors();
                } else if (this.expression.endsWith("*")) {
                    objectErrors = this.errors.getFieldErrors(this.expression);
                } else {
                    objectErrors = this.errors.getFieldErrors(this.expression);
                    this.value = this.errors.getFieldValue(this.expression);
                    if (this.errors instanceof BindException) {
                        this.editor = ((BindException)this.errors).getCustomEditor(this.expression);
                    }
                    if (htmlEscape && this.value instanceof String) {
                        this.value = HtmlUtils.htmlEscape((String)((String)this.value));
                    }
                }
            } else {
                objectErrors = this.errors.getGlobalErrors();
            }
            this.errorCodes = this.getErrorCodes(objectErrors);
            this.errorMessages = this.getErrorMessages(objectErrors);
        } else {
            Object target = requestContext.getModelObject(beanName);
            if (target == null) {
                throw new IllegalStateException("Neither Errors instance nor plain target object for bean name " + beanName + " available as request attribute");
            }
            if (this.expression != null && !"*".equals(this.expression) && !this.expression.endsWith("*")) {
                BeanWrapperImpl bw = new BeanWrapperImpl(target);
                this.value = bw.getPropertyValue(this.expression);
            }
            this.errorCodes = new String[0];
            this.errorMessages = new String[0];
        }
    }

    private String[] getErrorCodes(List objectErrors) {
        String[] codes = new String[objectErrors.size()];
        for (int i = 0; i < objectErrors.size(); ++i) {
            ObjectError error = (ObjectError)objectErrors.get(i);
            codes[i] = error.getCode();
        }
        return codes;
    }

    private String[] getErrorMessages(List objectErrors) throws NoSuchMessageException {
        String[] messages = new String[objectErrors.size()];
        for (int i = 0; i < objectErrors.size(); ++i) {
            ObjectError error = (ObjectError)objectErrors.get(i);
            messages[i] = this.requestContext.getMessage((MessageSourceResolvable)error, this.htmlEscape);
        }
        return messages;
    }

    public String getPath() {
        return this.path;
    }

    public String getExpression() {
        return this.expression;
    }

    public Object getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        return this.value != null ? this.value.toString() : "";
    }

    public boolean isError() {
        return this.errorCodes != null && this.errorCodes.length > 0;
    }

    public String[] getErrorCodes() {
        return this.errorCodes;
    }

    public String getErrorCode() {
        return this.errorCodes.length > 0 ? this.errorCodes[0] : "";
    }

    public String[] getErrorMessages() {
        return this.errorMessages;
    }

    public String getErrorMessage() {
        return this.errorMessages.length > 0 ? this.errorMessages[0] : "";
    }

    public String getErrorMessagesAsString(String delimiter) {
        return StringUtils.arrayToDelimitedString((Object[])this.errorMessages, (String)delimiter);
    }

    public Errors getErrors() {
        return this.errors;
    }

    public PropertyEditor getEditor() {
        return this.editor;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BindStatus: ");
        sb.append("expression=[").append(this.expression).append("]; ");
        sb.append("value=[").append(this.value).append("]");
        if (this.isError()) {
            sb.append("; errorCodes='" + Arrays.asList(this.errorCodes) + "'; ");
            sb.append("errorMessages='" + Arrays.asList(this.errorMessages));
        }
        return sb.toString();
    }
}

