/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.velocity;

import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.tools.VelocityFormatter;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.velocity.VelocityConfig;

public class VelocityView
extends AbstractUrlBasedView {
    public static final int DEFAULT_WRITER_POOL_SIZE = 40;
    public static final int OUTPUT_BUFFER_SIZE = 4096;
    private String encoding = null;
    private String velocityFormatterAttribute;
    private String dateToolAttribute;
    private String numberToolAttribute;
    private boolean cacheTemplate;
    private VelocityEngine velocityEngine;
    private Template template;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$velocity$VelocityConfig;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public void setVelocityFormatterAttribute(String velocityFormatterAttribute) {
        this.velocityFormatterAttribute = velocityFormatterAttribute;
    }

    public void setDateToolAttribute(String dateToolAttribute) {
        this.dateToolAttribute = dateToolAttribute;
    }

    public void setNumberToolAttribute(String numberToolAttribute) {
        this.numberToolAttribute = numberToolAttribute;
    }

    public void setCacheTemplate(boolean cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    protected VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        if (this.velocityEngine == null) {
            try {
                VelocityConfig velocityConfig = (VelocityConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), (Class)(class$org$springframework$web$servlet$view$velocity$VelocityConfig == null ? (class$org$springframework$web$servlet$view$velocity$VelocityConfig = VelocityView.class$("org.springframework.web.servlet.view.velocity.VelocityConfig")) : class$org$springframework$web$servlet$view$velocity$VelocityConfig), (boolean)true, (boolean)true);
                this.velocityEngine = velocityConfig.getVelocityEngine();
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new ApplicationContextException("Must define a single VelocityConfig bean in this web application context (may be inherited): VelocityConfigurer is the usual implementation. This bean may be given any name.", (Throwable)ex);
            }
        }
        try {
            this.template = this.getTemplate();
        }
        catch (ResourceNotFoundException ex) {
            throw new ApplicationContextException("Cannot find Velocity template for URL [" + this.getUrl() + "]: Did you specify the correct resource loader path?", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new ApplicationContextException("Cannot load Velocity template for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Template template = this.template;
        if (!this.cacheTemplate) {
            template = this.getTemplate();
        }
        response.setContentType(this.getContentType());
        VelocityContext velocityContext = new VelocityContext(model);
        this.exposeHelpers((Context)velocityContext, request);
        if (this.velocityFormatterAttribute != null) {
            velocityContext.put(this.velocityFormatterAttribute, (Object)new VelocityFormatter((Context)velocityContext));
        }
        if (this.dateToolAttribute != null || this.numberToolAttribute != null) {
            Locale locale = RequestContextUtils.getLocale(request);
            if (this.dateToolAttribute != null) {
                velocityContext.put(this.dateToolAttribute, (Object)new LocaleAwareDateTool(locale));
            }
            if (this.numberToolAttribute != null) {
                velocityContext.put(this.numberToolAttribute, (Object)new LocaleAwareNumberTool(locale));
            }
        }
        this.mergeTemplate(template, (Context)velocityContext, response);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Merged with Velocity template '" + this.getUrl() + "' in VelocityView '" + this.getBeanName() + "'"));
        }
    }

    protected Template getTemplate() throws Exception {
        return this.encoding != null ? this.velocityEngine.getTemplate(this.getUrl(), this.encoding) : this.velocityEngine.getTemplate(this.getUrl());
    }

    protected void exposeHelpers(Context velocityContext, HttpServletRequest request) throws Exception {
    }

    protected void mergeTemplate(Template template, Context context, HttpServletResponse response) throws Exception {
        template.merge(context, (Writer)response.getWriter());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LocaleAwareNumberTool
    extends NumberTool {
        private Locale locale;

        private LocaleAwareNumberTool(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }

    private static class LocaleAwareDateTool
    extends DateTool {
        private Locale locale;

        private LocaleAwareDateTool(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

