/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.tags.HtmlEscapeTag;
import org.springframework.web.util.ExpressionEvaluationUtils;

public abstract class RequestContextAwareTag
extends TagSupport {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String htmlEscape;
    private RequestContext requestContext;

    public final void setHtmlEscape(String htmlEscape) {
        this.htmlEscape = htmlEscape;
    }

    protected final boolean isHtmlEscape() throws JspException {
        if (this.htmlEscape != null) {
            return ExpressionEvaluationUtils.evaluateBoolean((String)"htmlEscape", (String)this.htmlEscape, (PageContext)this.pageContext);
        }
        return HtmlEscapeTag.isDefaultHtmlEscape(this.pageContext);
    }

    protected final RequestContext getRequestContext() {
        return this.requestContext;
    }

    public final int doStartTag() throws JspException {
        try {
            this.requestContext = new RequestContext((HttpServletRequest)this.pageContext.getRequest());
            return this.doStartTagInternal();
        }
        catch (JspException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.pageContext.getServletContext().log("Exception in custom tag", (Throwable)ex);
            throw new JspTagException(ex.getMessage());
        }
    }

    protected int doStartTagInternal() throws Exception {
        return super.doStartTag();
    }
}

