/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.ObjectDeletedException;
import net.sf.hibernate.ObjectNotFoundException;
import net.sf.hibernate.PersistentObjectException;
import net.sf.hibernate.Query;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.TransientObjectException;
import net.sf.hibernate.UnresolvableObjectException;
import net.sf.hibernate.WrongClassException;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.orm.hibernate.HibernateJdbcException;
import org.springframework.orm.hibernate.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate.HibernateOptimisticLockingFailureException;
import org.springframework.orm.hibernate.HibernateQueryException;
import org.springframework.orm.hibernate.HibernateSystemException;
import org.springframework.orm.hibernate.LocalDataSourceConnectionProvider;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class SessionFactoryUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$orm$hibernate$SessionFactoryUtils == null ? (class$org$springframework$orm$hibernate$SessionFactoryUtils = SessionFactoryUtils.class$("org.springframework.orm.hibernate.SessionFactoryUtils")) : class$org$springframework$orm$hibernate$SessionFactoryUtils));
    private static ThreadLocal deferredCloseHolder = new ThreadLocal();
    static /* synthetic */ Class class$org$springframework$orm$hibernate$SessionFactoryUtils;

    public static DataSource getDataSource(SessionFactory sessionFactory) {
        ConnectionProvider cp;
        if (sessionFactory instanceof SessionFactoryImplementor && (cp = ((SessionFactoryImplementor)sessionFactory).getConnectionProvider()) instanceof LocalDataSourceConnectionProvider) {
            return ((LocalDataSourceConnectionProvider)cp).getDataSource();
        }
        return null;
    }

    public static SQLExceptionTranslator newJdbcExceptionTranslator(SessionFactory sessionFactory) {
        DataSource ds = SessionFactoryUtils.getDataSource(sessionFactory);
        if (ds != null) {
            return new SQLErrorCodeSQLExceptionTranslator(ds);
        }
        return new SQLStateSQLExceptionTranslator();
    }

    public static TransactionManager getJtaTransactionManager(SessionFactory sessionFactory, Session session) {
        SessionFactory internalFactory;
        SessionFactoryImplementor sessionFactoryImpl = null;
        if (sessionFactory instanceof SessionFactoryImplementor) {
            sessionFactoryImpl = (SessionFactoryImplementor)sessionFactory;
        } else if (session != null && (internalFactory = session.getSessionFactory()) instanceof SessionFactoryImplementor) {
            sessionFactoryImpl = (SessionFactoryImplementor)internalFactory;
        }
        return sessionFactoryImpl != null ? sessionFactoryImpl.getTransactionManager() : null;
    }

    public static Session getSession(SessionFactory sessionFactory, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return SessionFactoryUtils.getSession(sessionFactory, null, null, true, allowCreate);
    }

    public static Session getSession(SessionFactory sessionFactory, Interceptor entityInterceptor, SQLExceptionTranslator jdbcExceptionTranslator) {
        return SessionFactoryUtils.getSession(sessionFactory, entityInterceptor, jdbcExceptionTranslator, true);
    }

    public static Session getSession(SessionFactory sessionFactory, Interceptor entityInterceptor, SQLExceptionTranslator jdbcExceptionTranslator, boolean allowSynchronization) throws DataAccessResourceFailureException {
        return SessionFactoryUtils.getSession(sessionFactory, entityInterceptor, jdbcExceptionTranslator, allowSynchronization, true);
    }

    private static Session getSession(SessionFactory sessionFactory, Interceptor entityInterceptor, SQLExceptionTranslator jdbcExceptionTranslator, boolean allowSynchronization, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        SessionHolder sessionHolder;
        block21: {
            sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
            if (sessionHolder != null) {
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    if (allowSynchronization && !sessionHolder.isSynchronizedWithTransaction()) {
                        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, false));
                        sessionHolder.setSynchronizedWithTransaction(true);
                    }
                    return sessionHolder.getSession();
                }
                TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, sessionHolder.getAnySession());
                if (jtaTm != null) {
                    try {
                        Session session;
                        int jtaStatus = jtaTm.getStatus();
                        if ((jtaStatus == 0 || jtaStatus == 1) && (session = sessionHolder.getSession(jtaTm.getTransaction())) != null) {
                            return session;
                        }
                        break block21;
                    }
                    catch (SystemException ex) {
                        throw new DataAccessResourceFailureException("Could not check JTA transaction", (Throwable)ex);
                    }
                }
                return sessionHolder.getSession();
            }
        }
        if (!allowCreate) {
            throw new IllegalStateException("No Hibernate session bound to thread, and configuration does not allow creation of new one here");
        }
        logger.debug((Object)"Opening Hibernate session");
        try {
            Session session;
            Session session2 = session = entityInterceptor != null ? sessionFactory.openSession(entityInterceptor) : sessionFactory.openSession();
            if (allowSynchronization) {
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    logger.debug((Object)"Registering Spring transaction synchronization for Hibernate session");
                    sessionHolder = new SessionHolder(session);
                    sessionHolder.setSynchronizedWithTransaction(true);
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, true));
                    TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
                } else {
                    TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, session);
                    if (jtaTm != null) {
                        try {
                            int jtaStatus = jtaTm.getStatus();
                            if (jtaStatus == 0 || jtaStatus == 1) {
                                logger.debug((Object)"Registering JTA transaction synchronization for Hibernate session");
                                Transaction jtaTx = jtaTm.getTransaction();
                                boolean newHolder = false;
                                if (sessionHolder == null) {
                                    sessionHolder = new SessionHolder(jtaTx, session);
                                    sessionHolder.setSynchronizedWithTransaction(true);
                                    newHolder = true;
                                } else {
                                    sessionHolder.addSession(jtaTx, session);
                                }
                                jtaTx.registerSynchronization((Synchronization)new JtaSessionSynchronization(new SpringSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, true), jtaTm));
                                if (newHolder) {
                                    TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
                                }
                            }
                        }
                        catch (Exception ex) {
                            throw new DataAccessResourceFailureException("Could not register synchronization with JTA TransactionManager", (Throwable)ex);
                        }
                    }
                }
            }
            return session;
        }
        catch (JDBCException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate session", (Throwable)ex.getSQLException());
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate session", (Throwable)ex);
        }
    }

    public static void applyTransactionTimeout(Query query, SessionFactory sessionFactory) {
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null && sessionHolder.hasTimeout()) {
            query.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static void applyTransactionTimeout(Criteria criteria, SessionFactory sessionFactory) {
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null && sessionHolder.hasTimeout()) {
            criteria.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCException) {
            return new HibernateJdbcException((JDBCException)((Object)ex));
        }
        if (ex instanceof UnresolvableObjectException) {
            return new HibernateObjectRetrievalFailureException((UnresolvableObjectException)ex);
        }
        if (ex instanceof ObjectNotFoundException) {
            return new HibernateObjectRetrievalFailureException((ObjectNotFoundException)ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new HibernateObjectRetrievalFailureException((ObjectDeletedException)ex);
        }
        if (ex instanceof WrongClassException) {
            return new HibernateObjectRetrievalFailureException((WrongClassException)ex);
        }
        if (ex instanceof StaleObjectStateException) {
            return new HibernateOptimisticLockingFailureException((StaleObjectStateException)ex);
        }
        if (ex instanceof QueryException) {
            return new HibernateQueryException((QueryException)ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage());
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage());
        }
        return new HibernateSystemException(ex);
    }

    public static boolean isDeferredCloseActive(SessionFactory sessionFactory) {
        Map holderMap = (Map)deferredCloseHolder.get();
        return holderMap != null && holderMap.containsKey(sessionFactory);
    }

    public static void initDeferredClose(SessionFactory sessionFactory) {
        logger.debug((Object)"Initializing deferred close of Hibernate sessions");
        HashMap holderMap = (HashMap)deferredCloseHolder.get();
        if (holderMap == null) {
            holderMap = new HashMap();
            deferredCloseHolder.set(holderMap);
        }
        holderMap.put(sessionFactory, new HashSet());
    }

    public static void processDeferredClose(SessionFactory sessionFactory) {
        Map holderMap = (Map)deferredCloseHolder.get();
        if (holderMap == null || !holderMap.containsKey(sessionFactory)) {
            throw new IllegalStateException("Deferred close not active for SessionFactory [" + sessionFactory + "]");
        }
        logger.debug((Object)"Processing deferred close of Hibernate sessions");
        Set sessions = (Set)holderMap.remove(sessionFactory);
        Iterator it = sessions.iterator();
        while (it.hasNext()) {
            SessionFactoryUtils.doClose((Session)it.next());
        }
        if (holderMap.isEmpty()) {
            deferredCloseHolder.set(null);
        }
    }

    public static void closeSessionIfNecessary(Session session, SessionFactory sessionFactory) {
        if (session == null) {
            return;
        }
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null && sessionHolder.containsSession(session)) {
            return;
        }
        SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, sessionFactory);
    }

    private static void closeSessionOrRegisterDeferredClose(Session session, SessionFactory sessionFactory) {
        Map holderMap = (Map)deferredCloseHolder.get();
        if (holderMap != null && holderMap.containsKey(sessionFactory)) {
            logger.debug((Object)"Registering Hibernate session for deferred close");
            Set sessions = (Set)holderMap.get(sessionFactory);
            sessions.add(session);
        } else {
            SessionFactoryUtils.doClose(session);
        }
    }

    private static void doClose(Session session) {
        logger.debug((Object)"Closing Hibernate session");
        try {
            session.close();
        }
        catch (JDBCException ex) {
            logger.error((Object)"Could not close Hibernate session", (Throwable)ex.getSQLException());
        }
        catch (HibernateException ex) {
            logger.error((Object)"Could not close Hibernate session");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JtaSessionSynchronization
    implements Synchronization {
        private final SpringSessionSynchronization springSessionSynchronization;
        private final TransactionManager jtaTransactionManager;

        private JtaSessionSynchronization(SpringSessionSynchronization springSessionSynchronization, TransactionManager jtaTransactionManager) {
            this.springSessionSynchronization = springSessionSynchronization;
            this.jtaTransactionManager = jtaTransactionManager;
        }

        public void beforeCompletion() {
            try {
                this.springSessionSynchronization.beforeCommit(false);
            }
            catch (Throwable ex) {
                logger.error((Object)"beforeCommit callback threw exception", ex);
                try {
                    this.jtaTransactionManager.setRollbackOnly();
                }
                catch (SystemException ex2) {
                    logger.error((Object)"Could not set JTA transaction rollback-only", (Throwable)ex2);
                }
            }
        }

        public void afterCompletion(int status) {
            this.springSessionSynchronization.beforeCompletion();
            this.springSessionSynchronization.afterCompletion(-1);
        }
    }

    private static class SpringSessionSynchronization
    implements TransactionSynchronization {
        private final SessionHolder sessionHolder;
        private final SessionFactory sessionFactory;
        private final SQLExceptionTranslator jdbcExceptionTranslator;
        private final boolean newSession;
        private boolean hibernateTransactionCompletion = false;
        private Transaction jtaTransaction = null;

        private SpringSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator, boolean newSession) {
            this.sessionHolder = sessionHolder;
            this.sessionFactory = sessionFactory;
            this.jdbcExceptionTranslator = jdbcExceptionTranslator;
            this.newSession = newSession;
            TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, sessionHolder.getAnySession());
            if (jtaTm != null) {
                this.hibernateTransactionCompletion = true;
                try {
                    int jtaStatus = jtaTm.getStatus();
                    if (jtaStatus == 0 || jtaStatus == 1) {
                        this.jtaTransaction = jtaTm.getTransaction();
                    }
                }
                catch (SystemException ex) {
                    throw new DataAccessResourceFailureException("Could not check JTA transaction", (Throwable)ex);
                }
            }
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
        }

        public void beforeCommit(boolean readOnly) throws DataAccessException {
            if (!readOnly) {
                Session session;
                logger.debug((Object)"Flushing Hibernate session on transaction synchronization");
                Session session2 = session = this.jtaTransaction != null ? this.sessionHolder.getSession(this.jtaTransaction) : this.sessionHolder.getSession();
                if (!session.getFlushMode().equals(FlushMode.NEVER)) {
                    try {
                        session.flush();
                    }
                    catch (JDBCException ex) {
                        if (this.jdbcExceptionTranslator != null) {
                            throw this.jdbcExceptionTranslator.translate("SessionSynchronization", null, ex.getSQLException());
                        }
                        throw new HibernateJdbcException(ex);
                    }
                    catch (HibernateException ex) {
                        throw SessionFactoryUtils.convertHibernateAccessException(ex);
                    }
                }
            }
        }

        public void beforeCompletion() {
            if (this.jtaTransaction != null) {
                Session session = this.sessionHolder.removeSession(this.jtaTransaction);
                if (this.sessionHolder.isEmpty()) {
                    TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                }
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.sessionFactory);
            } else if (this.newSession) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                if (this.hibernateTransactionCompletion) {
                    SessionFactoryUtils.closeSessionOrRegisterDeferredClose(this.sessionHolder.getSession(), this.sessionFactory);
                }
            }
        }

        public void afterCompletion(int status) {
            if (!this.hibernateTransactionCompletion) {
                Session session = this.sessionHolder.getSession();
                if (session instanceof SessionImplementor) {
                    ((SessionImplementor)session).afterTransactionCompletion(status == 0);
                }
                if (this.newSession) {
                    SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.sessionFactory);
                }
            }
            this.sessionHolder.setSynchronizedWithTransaction(false);
        }
    }
}

