/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;

public class MockPageContext
extends PageContext {
    private final ServletContext servletContext;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletConfig servletConfig;
    private final Hashtable attributes = new Hashtable();

    public MockPageContext() {
        this(new MockServletContext());
    }

    public MockPageContext(ServletContext servletContext) {
        this(servletContext, new MockHttpServletRequest(servletContext));
    }

    public MockPageContext(ServletContext servletContext, HttpServletRequest request) {
        this(servletContext, request, new MockHttpServletResponse());
    }

    public MockPageContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this(servletContext, request, response, new MockServletConfig(servletContext));
    }

    public MockPageContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, ServletConfig servletConfig) {
        this.servletContext = servletContext;
        this.servletConfig = servletConfig;
        this.request = request;
        this.response = response;
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) {
        throw new UnsupportedOperationException("Use appropriate constructor");
    }

    public void release() {
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object value, int scope) {
        switch (scope) {
            case 1: {
                this.setAttribute(name, value);
                break;
            }
            case 2: {
                this.request.setAttribute(name, value);
                break;
            }
            case 3: {
                this.request.getSession().setAttribute(name, value);
                break;
            }
            case 4: {
                this.servletContext.setAttribute(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope: " + scope);
            }
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                return this.getAttribute(name);
            }
            case 2: {
                return this.request.getAttribute(name);
            }
            case 3: {
                HttpSession session = this.request.getSession(false);
                return session != null ? session.getAttribute(name) : null;
            }
            case 4: {
                return this.servletContext.getAttribute(name);
            }
        }
        throw new IllegalArgumentException("Invalid scope: " + scope);
    }

    public Object findAttribute(String name) {
        Object value = this.getAttribute(name);
        if (value == null && (value = this.getAttribute(name, 2)) == null && (value = this.getAttribute(name, 3)) == null) {
            value = this.getAttribute(name, 4);
        }
        return value;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void removeAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                this.removeAttribute(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
                break;
            }
            case 3: {
                this.request.getSession().removeAttribute(name);
                break;
            }
            case 4: {
                this.servletContext.removeAttribute(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope: " + scope);
            }
        }
    }

    public int getAttributesScope(String name) {
        if (this.getAttribute(name) != null) {
            return 1;
        }
        if (this.getAttribute(name, 2) != null) {
            return 2;
        }
        if (this.getAttribute(name, 3) != null) {
            return 3;
        }
        if (this.getAttribute(name, 4) != null) {
            return 4;
        }
        return 0;
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                return this.getAttributeNames();
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                HttpSession session = this.request.getSession(false);
                return session != null ? session.getAttributeNames() : null;
            }
            case 4: {
                return this.servletContext.getAttributeNames();
            }
        }
        throw new IllegalArgumentException("Invalid scope: " + scope);
    }

    public JspWriter getOut() {
        throw new UnsupportedOperationException("getOut");
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public Object getPage() {
        throw new UnsupportedOperationException("getPage");
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        throw new UnsupportedOperationException("getException");
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void forward(String url) throws ServletException, IOException {
        throw new UnsupportedOperationException("forward");
    }

    public void include(String url) throws ServletException, IOException {
        throw new UnsupportedOperationException("include");
    }

    public void handlePageException(Exception ex) throws ServletException, IOException {
        throw new UnsupportedOperationException("handlePageException");
    }

    public void handlePageException(Throwable throwable) throws ServletException, IOException {
        throw new UnsupportedOperationException("handlePageException");
    }
}

