/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.AbstractSpringContextTests;

public abstract class AbstractDependencyInjectionSpringContextTests
extends AbstractSpringContextTests {
    private boolean populateProtectedVariables = false;
    private Object contextKey;
    protected ConfigurableApplicationContext applicationContext;
    protected String[] managedVariableNames;
    private int loadCount = 0;
    static /* synthetic */ Class class$org$springframework$test$AbstractSpringContextTests;

    public void setPopulateProtectedVariables(boolean populateFields) {
        this.populateProtectedVariables = populateFields;
    }

    public boolean isPopulateProtectedVariables() {
        return this.populateProtectedVariables;
    }

    public final int getLoadCount() {
        return this.loadCount;
    }

    public void setDirty() {
        this.setDirty(this.getConfigLocations());
    }

    protected final void setUp() throws Exception {
        if (this.contextKey == null) {
            this.contextKey = this.contextKey();
        }
        this.applicationContext = this.getContext(this.contextKey);
        if (this.isPopulateProtectedVariables()) {
            if (this.managedVariableNames == null) {
                this.initManagedVariableNames();
            }
            this.populateProtectedVariables();
        } else {
            this.applicationContext.getBeanFactory().autowireBeanProperties((Object)this, 2, true);
        }
        try {
            this.onSetUp();
        }
        catch (Exception ex) {
            this.logger.error((Object)("Setup error: " + ex));
            throw ex;
        }
    }

    protected Object contextKey() {
        return this.getConfigLocations();
    }

    protected ConfigurableApplicationContext loadContextLocations(String[] locations) {
        ++this.loadCount;
        return super.loadContextLocations(locations);
    }

    protected void initManagedVariableNames() throws IllegalAccessException {
        LinkedList<String> managedVarNames = new LinkedList<String>();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        do {
            Field[] fields = clazz.getDeclaredFields();
            this.logger.debug((Object)(fields.length + " fields on " + clazz));
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                f.setAccessible(true);
                this.logger.debug((Object)("Candidate field " + f));
                if (Modifier.isStatic(f.getModifiers()) || !Modifier.isProtected(f.getModifiers())) continue;
                Object oldValue = f.get((Object)this);
                if (oldValue == null) {
                    managedVarNames.add(f.getName());
                    this.logger.info((Object)("Added managed variable '" + f.getName() + "'"));
                    continue;
                }
                this.logger.info((Object)("Rejected managed variable '" + f.getName() + "'"));
            }
        } while ((clazz = clazz.getSuperclass()) != (class$org$springframework$test$AbstractSpringContextTests == null ? AbstractDependencyInjectionSpringContextTests.class$("org.springframework.test.AbstractSpringContextTests") : class$org$springframework$test$AbstractSpringContextTests));
        this.managedVariableNames = managedVarNames.toArray(new String[managedVarNames.size()]);
    }

    protected void populateProtectedVariables() throws IllegalAccessException {
        for (int i = 0; i < this.managedVariableNames.length; ++i) {
            Object bean = null;
            Field f = null;
            try {
                f = this.findField(((Object)((Object)this)).getClass(), this.managedVariableNames[i]);
                bean = this.applicationContext.getBean(this.managedVariableNames[i]);
                f.set((Object)this, bean);
                this.logger.info((Object)("Populated " + f));
                continue;
            }
            catch (NoSuchFieldException ex) {
                this.logger.warn((Object)("No field with name '" + this.managedVariableNames[i] + "'"));
                continue;
            }
            catch (IllegalArgumentException ex) {
                this.logger.error((Object)("Value " + bean + " not compatible with " + f));
                continue;
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.logger.warn((Object)("No bean with name '" + this.managedVariableNames[i] + "'"));
            }
        }
    }

    private Field findField(Class clazz, String name) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            Class superclass = clazz.getSuperclass();
            if (superclass != (class$org$springframework$test$AbstractSpringContextTests == null ? (class$org$springframework$test$AbstractSpringContextTests = AbstractDependencyInjectionSpringContextTests.class$("org.springframework.test.AbstractSpringContextTests")) : class$org$springframework$test$AbstractSpringContextTests)) {
                return this.findField(superclass, name);
            }
            throw ex;
        }
    }

    protected void onSetUp() throws Exception {
    }

    protected final void tearDown() {
        try {
            this.onTearDown();
        }
        catch (Exception ex) {
            this.logger.error((Object)"onTearDown error", (Throwable)ex);
        }
    }

    protected void onTearDown() throws Exception {
    }

    protected abstract String[] getConfigLocations();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

