/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.CannotSerializeTransactionException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.InvalidResultSetAccessException;
import org.springframework.jdbc.support.CustomSQLErrorCodesTranslation;
import org.springframework.jdbc.support.SQLErrorCodes;
import org.springframework.jdbc.support.SQLErrorCodesFactory;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

public class SQLErrorCodeSQLExceptionTranslator
implements SQLExceptionTranslator {
    private static final int MESSAGE_ONLY_CONSTRUCTOR = 1;
    private static final int MESSAGE_THROWABLE_CONSTRUCTOR = 2;
    private static final int MESSAGE_SQLEX_CONSTRUCTOR = 3;
    private static final int MESSAGE_SQL_THROWABLE_CONSTRUCTOR = 4;
    private static final int MESSAGE_SQL_SQLEX_CONSTRUCTOR = 5;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SQLErrorCodes sqlErrorCodes;
    private SQLExceptionTranslator fallbackTranslator = new SQLStateSQLExceptionTranslator();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$sql$SQLException;

    public SQLErrorCodeSQLExceptionTranslator() {
    }

    public SQLErrorCodeSQLExceptionTranslator(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public SQLErrorCodeSQLExceptionTranslator(String dbName) {
        this.setDatabaseProductName(dbName);
    }

    public SQLErrorCodeSQLExceptionTranslator(SQLErrorCodes sec) {
        this.sqlErrorCodes = sec;
    }

    public void setDataSource(DataSource dataSource) {
        this.sqlErrorCodes = SQLErrorCodesFactory.getInstance().getErrorCodes(dataSource);
    }

    public void setDatabaseProductName(String dbName) {
        this.sqlErrorCodes = SQLErrorCodesFactory.getInstance().getErrorCodes(dbName);
    }

    public void setSqlErrorCodes(SQLErrorCodes sec) {
        this.sqlErrorCodes = sec;
    }

    public SQLErrorCodes getSqlErrorCodes() {
        return this.sqlErrorCodes;
    }

    public void setFallbackTranslator(SQLExceptionTranslator fallback) {
        this.fallbackTranslator = fallback;
    }

    public SQLExceptionTranslator getFallbackTranslator() {
        return this.fallbackTranslator;
    }

    public DataAccessException translate(String task, String sql, SQLException sqlEx) {
        DataAccessException dex;
        if (task == null) {
            task = "";
        }
        if (sql == null) {
            sql = "";
        }
        if ((dex = this.customTranslate(task, sql, sqlEx)) != null) {
            return dex;
        }
        if (this.sqlErrorCodes != null) {
            String errorCode = null;
            errorCode = this.sqlErrorCodes.isUseSqlStateForTranslation() ? sqlEx.getSQLState() : Integer.toString(sqlEx.getErrorCode());
            if (errorCode != null) {
                CustomSQLErrorCodesTranslation[] customTranslations = this.sqlErrorCodes.getCustomTranslations();
                if (customTranslations != null) {
                    for (int i = 0; i < customTranslations.length; ++i) {
                        DataAccessException customException;
                        CustomSQLErrorCodesTranslation customTranslation = customTranslations[i];
                        if (Arrays.binarySearch(customTranslation.getErrorCodes(), errorCode) < 0 || customTranslation.getExceptionClass() == null || (customException = this.createCustomException(task, sql, sqlEx, customTranslation.getExceptionClass())) == null) continue;
                        this.logTranslation(task, sql, sqlEx, true);
                        return customException;
                    }
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getBadSqlGrammarCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, sqlEx, false);
                    return new BadSqlGrammarException(task, sql, sqlEx);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getInvalidResultSetAccessCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, sqlEx, false);
                    return new InvalidResultSetAccessException(task, sql, sqlEx);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getDataAccessResourceFailureCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, sqlEx, false);
                    return new DataAccessResourceFailureException(task + ": " + sqlEx.getMessage(), (Throwable)sqlEx);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getDataIntegrityViolationCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, sqlEx, false);
                    return new DataIntegrityViolationException(task + ": " + sqlEx.getMessage(), (Throwable)sqlEx);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getCannotAcquireLockCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, sqlEx, false);
                    return new CannotAcquireLockException(task + ": " + sqlEx.getMessage(), (Throwable)sqlEx);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getDeadlockLoserCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, sqlEx, false);
                    return new DeadlockLoserDataAccessException(task + ": " + sqlEx.getMessage(), (Throwable)sqlEx);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getCannotSerializeTransactionCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, sqlEx, false);
                    return new CannotSerializeTransactionException(task + ": " + sqlEx.getMessage(), (Throwable)sqlEx);
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unable to translate SQLException with errorCode '" + sqlEx.getErrorCode() + "', will now try the fallback translator"));
        }
        return this.fallbackTranslator.translate(task, sql, sqlEx);
    }

    protected DataAccessException customTranslate(String task, String sql, SQLException sqlEx) {
        return null;
    }

    protected DataAccessException createCustomException(String task, String sql, SQLException sqlEx, Class exceptionClass) {
        try {
            int constructorType = 0;
            Constructor<?>[] constructors = exceptionClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Class<?>[] parameterTypes = constructors[i].getParameterTypes();
                if (parameterTypes.length == 1 && parameterTypes[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && constructorType < 1) {
                    constructorType = 1;
                }
                if (parameterTypes.length == 2 && parameterTypes[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && parameterTypes[1].equals(class$java$lang$Throwable == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.Throwable") : class$java$lang$Throwable) && constructorType < 2) {
                    constructorType = 2;
                }
                if (parameterTypes.length == 2 && parameterTypes[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && parameterTypes[1].equals(class$java$sql$SQLException == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.sql.SQLException") : class$java$sql$SQLException) && constructorType < 3) {
                    constructorType = 3;
                }
                if (parameterTypes.length == 3 && parameterTypes[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && parameterTypes[1].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && parameterTypes[2].equals(class$java$lang$Throwable == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.Throwable") : class$java$lang$Throwable) && constructorType < 4) {
                    constructorType = 4;
                }
                if (parameterTypes.length != 3 || !parameterTypes[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) || !parameterTypes[1].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) || !parameterTypes[2].equals(class$java$sql$SQLException == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.sql.SQLException") : class$java$sql$SQLException) || constructorType >= 5) continue;
                constructorType = 5;
            }
            Constructor exceptionConstructor = null;
            switch (constructorType) {
                case 5: {
                    Class[] messageAndSqlAndSqlExArgsClass = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String, class$java$sql$SQLException == null ? (class$java$sql$SQLException = SQLErrorCodeSQLExceptionTranslator.class$("java.sql.SQLException")) : class$java$sql$SQLException};
                    Object[] messageAndSqlAndSqlExArgs = new Object[]{task, sql, sqlEx};
                    exceptionConstructor = exceptionClass.getConstructor(messageAndSqlAndSqlExArgsClass);
                    return (DataAccessException)exceptionConstructor.newInstance(messageAndSqlAndSqlExArgs);
                }
                case 4: {
                    Class[] messageAndSqlAndThrowableArgsClass = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.Throwable")) : class$java$lang$Throwable};
                    Object[] messageAndSqlAndThrowableArgs = new Object[]{task, sql, sqlEx};
                    exceptionConstructor = exceptionClass.getConstructor(messageAndSqlAndThrowableArgsClass);
                    return (DataAccessException)exceptionConstructor.newInstance(messageAndSqlAndThrowableArgs);
                }
                case 3: {
                    Class[] messageAndSqlExArgsClass = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String, class$java$sql$SQLException == null ? (class$java$sql$SQLException = SQLErrorCodeSQLExceptionTranslator.class$("java.sql.SQLException")) : class$java$sql$SQLException};
                    Object[] messageAndSqlExArgs = new Object[]{task + ": " + sqlEx.getMessage(), sqlEx};
                    exceptionConstructor = exceptionClass.getConstructor(messageAndSqlExArgsClass);
                    return (DataAccessException)exceptionConstructor.newInstance(messageAndSqlExArgs);
                }
                case 2: {
                    Class[] messageAndThrowableArgsClass = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.Throwable")) : class$java$lang$Throwable};
                    Object[] messageAndThrowableArgs = new Object[]{task + ": " + sqlEx.getMessage(), sqlEx};
                    exceptionConstructor = exceptionClass.getConstructor(messageAndThrowableArgsClass);
                    return (DataAccessException)exceptionConstructor.newInstance(messageAndThrowableArgs);
                }
                case 1: {
                    Class[] messageOnlyArgsClass = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String};
                    Object[] messageOnlyArgs = new Object[]{task + ": " + sqlEx.getMessage()};
                    exceptionConstructor = exceptionClass.getConstructor(messageOnlyArgsClass);
                    return (DataAccessException)exceptionConstructor.newInstance(messageOnlyArgs);
                }
            }
            this.logger.warn((Object)("Unable to find appropriate constructor of custom exception class [" + exceptionClass.getName() + "]"));
            return null;
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Unable to instantiate custom exception class [" + exceptionClass + "]"), (Throwable)ex);
            return null;
        }
    }

    private void logTranslation(String task, String sql, SQLException sqlEx, boolean custom) {
        if (this.logger.isDebugEnabled()) {
            String intro = custom ? "Custom translation of" : "Translating";
            this.logger.debug((Object)(intro + " SQLException with SQLState '" + sqlEx.getSQLState() + "' and errorCode '" + sqlEx.getErrorCode() + "' and message [" + sqlEx.getMessage() + "]; SQL was [" + sql + "] for task [" + task + "]"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

