/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FileCopyUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$util$FileCopyUtils == null ? (class$org$springframework$util$FileCopyUtils = FileCopyUtils.class$("org.springframework.util.FileCopyUtils")) : class$org$springframework$util$FileCopyUtils));
    public static final int BLOCK_SIZE = 4096;
    static /* synthetic */ Class class$org$springframework$util$FileCopyUtils;

    public static void copy(File in, File out) throws IOException {
        FileCopyUtils.copy(new BufferedInputStream(new FileInputStream(in)), (OutputStream)new BufferedOutputStream(new FileOutputStream(out)));
    }

    public static void copy(byte[] in, File out) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(in);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(out));
        FileCopyUtils.copy(inStream, (OutputStream)outStream);
    }

    public static byte[] copyToByteArray(File in) throws IOException {
        return FileCopyUtils.copyToByteArray(new BufferedInputStream(new FileInputStream(in)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            byte[] buffer = new byte[4096];
            int nrOfBytes = -1;
            while ((nrOfBytes = in.read(buffer)) != -1) {
                out.write(buffer, 0, nrOfBytes);
            }
            out.flush();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                in.close();
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not close InputStream", (Throwable)ex);
            }
            try {
                out.close();
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not close OutputStream", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            logger.warn((Object)"Could not close InputStream", (Throwable)ex);
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            logger.warn((Object)"Could not close OutputStream", (Throwable)ex);
        }
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        FileCopyUtils.copy(new ByteArrayInputStream(in), out);
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileCopyUtils.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader in, Writer out) throws IOException {
        try {
            char[] buffer = new char[4096];
            int nrOfBytes = -1;
            while ((nrOfBytes = in.read(buffer)) != -1) {
                out.write(buffer, 0, nrOfBytes);
            }
            out.flush();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                in.close();
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not close Reader", (Throwable)ex);
            }
            try {
                out.close();
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not close Writer", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            logger.warn((Object)"Could not close Reader", (Throwable)ex);
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            logger.warn((Object)"Could not close Writer", (Throwable)ex);
        }
    }

    public static void copy(String in, Writer out) throws IOException {
        FileCopyUtils.copy(new StringReader(in), out);
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        FileCopyUtils.copy(in, (Writer)out);
        return out.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

