/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class BeanDefinitionReaderUtils {
    public static AbstractBeanDefinition createBeanDefinition(String className, String parent, ConstructorArgumentValues cargs, MutablePropertyValues pvs, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> beanClass = null;
        if (className != null && classLoader != null) {
            beanClass = Class.forName(className, true, classLoader);
        }
        if (parent == null) {
            if (beanClass != null) {
                return new RootBeanDefinition(beanClass, cargs, pvs);
            }
            return new RootBeanDefinition(className, cargs, pvs);
        }
        if (beanClass != null) {
            return new ChildBeanDefinition(parent, beanClass, cargs, pvs);
        }
        return new ChildBeanDefinition(parent, className, cargs, pvs);
    }
}

