/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.util.StringUtils;

public class MutablePropertyValues
implements PropertyValues,
Serializable {
    private List propertyValueList = new ArrayList();
    private PropertyValue[] propertyValueArray = new PropertyValue[0];

    public MutablePropertyValues() {
    }

    public MutablePropertyValues(PropertyValues source) {
        if (source != null) {
            PropertyValue[] pvs = source.getPropertyValues();
            this.propertyValueArray = new PropertyValue[pvs.length];
            for (int i = 0; i < pvs.length; ++i) {
                PropertyValue newPv;
                this.propertyValueArray[i] = newPv = new PropertyValue(pvs[i].getName(), pvs[i].getValue());
                this.propertyValueList.add(newPv);
            }
        }
    }

    public MutablePropertyValues(Map source) {
        this.addPropertyValues(source);
        this.recache();
    }

    private void recache() {
        this.propertyValueArray = this.propertyValueList.toArray(new PropertyValue[this.propertyValueList.size()]);
    }

    public MutablePropertyValues addPropertyValues(PropertyValues source) {
        if (source != null) {
            PropertyValue[] pvs = source.getPropertyValues();
            for (int i = 0; i < pvs.length; ++i) {
                this.addPropertyValue(new PropertyValue(pvs[i].getName(), pvs[i].getValue()));
            }
            this.recache();
        }
        return this;
    }

    public MutablePropertyValues addPropertyValues(Map source) {
        if (source != null) {
            Iterator it = source.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.addPropertyValue(new PropertyValue(key, source.get(key)));
            }
            this.recache();
        }
        return this;
    }

    public MutablePropertyValues addPropertyValue(PropertyValue pv) {
        for (int i = 0; i < this.propertyValueList.size(); ++i) {
            PropertyValue currentPv = (PropertyValue)this.propertyValueList.get(i);
            if (!currentPv.getName().equals(pv.getName())) continue;
            this.setPropertyValueAt(pv, i);
            return this;
        }
        this.propertyValueList.add(pv);
        this.recache();
        return this;
    }

    public void addPropertyValue(String propertyName, Object propertyValue) {
        this.addPropertyValue(new PropertyValue(propertyName, propertyValue));
    }

    public void removePropertyValue(PropertyValue pv) {
        this.propertyValueList.remove(pv);
        this.recache();
    }

    public void removePropertyValue(String propertyName) {
        this.removePropertyValue(this.getPropertyValue(propertyName));
    }

    public void setPropertyValueAt(PropertyValue pv, int i) {
        this.propertyValueList.set(i, pv);
        this.propertyValueArray[i] = pv;
    }

    public PropertyValue[] getPropertyValues() {
        return this.propertyValueArray;
    }

    public PropertyValue getPropertyValue(String propertyName) {
        for (int i = 0; i < this.propertyValueArray.length; ++i) {
            if (!this.propertyValueArray[i].getName().equals(propertyName)) continue;
            return this.propertyValueArray[i];
        }
        return null;
    }

    public boolean contains(String propertyName) {
        return this.getPropertyValue(propertyName) != null;
    }

    public PropertyValues changesSince(PropertyValues old) {
        MutablePropertyValues changes = new MutablePropertyValues();
        if (old == this) {
            return changes;
        }
        for (int i = 0; i < this.propertyValueArray.length; ++i) {
            PropertyValue newPv = this.propertyValueArray[i];
            PropertyValue pvOld = old.getPropertyValue(newPv.getName());
            if (pvOld == null) {
                changes.addPropertyValue(newPv);
                continue;
            }
            if (pvOld.equals(newPv)) continue;
            changes.addPropertyValue(newPv);
        }
        return changes;
    }

    public String toString() {
        Object[] pvs = this.getPropertyValues();
        StringBuffer sb = new StringBuffer("MutablePropertyValues: length=" + pvs.length + "; ");
        sb.append(StringUtils.arrayToDelimitedString(pvs, ","));
        return sb.toString();
    }
}

