/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanCircularReferenceException;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;

public abstract class AbstractBeanFactory
implements ConfigurableBeanFactory,
HierarchicalBeanFactory {
    public static final String FACTORY_BEAN_PREFIX = "&";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private BeanFactory parentBeanFactory;
    private Map customEditors = new HashMap();
    private final Set ignoreDependencyTypes = new HashSet();
    private final List beanPostProcessors = new ArrayList();
    private final Map aliasMap = Collections.synchronizedMap(new HashMap());
    private final Map singletonCache = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanFactory;
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public AbstractBeanFactory() {
        this.ignoreDependencyType(class$org$springframework$beans$factory$BeanFactory == null ? (class$org$springframework$beans$factory$BeanFactory = AbstractBeanFactory.class$("org.springframework.beans.factory.BeanFactory")) : class$org$springframework$beans$factory$BeanFactory);
    }

    public AbstractBeanFactory(BeanFactory parentBeanFactory) {
        this();
        this.parentBeanFactory = parentBeanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBean(String name) throws BeansException {
        String beanName = this.transformedBeanName(name);
        Object sharedInstance = this.singletonCache.get(beanName);
        if (sharedInstance != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning cached instance of singleton bean '" + beanName + "'"));
            }
            return this.getObjectForSharedInstance(name, sharedInstance);
        }
        RootBeanDefinition mergedBeanDefinition = null;
        try {
            mergedBeanDefinition = this.getMergedBeanDefinition(beanName, false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (this.parentBeanFactory != null) {
                return this.parentBeanFactory.getBean(name);
            }
            throw ex;
        }
        if (mergedBeanDefinition.isSingleton()) {
            Map map = this.singletonCache;
            synchronized (map) {
                sharedInstance = this.singletonCache.get(beanName);
                if (sharedInstance == null) {
                    this.logger.info((Object)("Creating shared instance of singleton bean '" + beanName + "'"));
                    sharedInstance = this.createBean(beanName, mergedBeanDefinition);
                    this.addSingleton(beanName, sharedInstance);
                }
            }
            return this.getObjectForSharedInstance(name, sharedInstance);
        }
        return this.createBean(name, mergedBeanDefinition);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        Object bean = this.getBean(name);
        if (!requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean);
        }
        return bean;
    }

    public boolean containsBean(String name) {
        String beanName = this.transformedBeanName(name);
        if (this.singletonCache.containsKey(beanName)) {
            return true;
        }
        if (this.containsBeanDefinition(beanName)) {
            return true;
        }
        if (this.parentBeanFactory != null) {
            return this.parentBeanFactory.containsBean(beanName);
        }
        return false;
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        try {
            Class beanClass = null;
            boolean singleton = true;
            Object beanInstance = this.singletonCache.get(beanName);
            if (beanInstance != null) {
                beanClass = beanInstance.getClass();
                singleton = true;
            } else {
                RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
                beanClass = bd.getBeanClass();
                singleton = bd.isSingleton();
            }
            if ((class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass) && !this.isFactoryDereference(name)) {
                FactoryBean factoryBean = (FactoryBean)this.getBean(FACTORY_BEAN_PREFIX + beanName);
                return factoryBean.isSingleton();
            }
            return singleton;
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (this.parentBeanFactory != null) {
                return this.parentBeanFactory.isSingleton(beanName);
            }
            throw ex;
        }
    }

    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        if (this.singletonCache.containsKey(beanName) || this.containsBeanDefinition(beanName)) {
            ArrayList aliases = new ArrayList();
            Iterator it = this.aliasMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!entry.getValue().equals(beanName)) continue;
                aliases.add(entry.getKey());
            }
            return aliases.toArray(new String[aliases.size()]);
        }
        if (this.parentBeanFactory != null) {
            return this.parentBeanFactory.getAliases(beanName);
        }
        throw new NoSuchBeanDefinitionException(beanName, this.toString());
    }

    public BeanFactory getParentBeanFactory() {
        return this.parentBeanFactory;
    }

    public void setParentBeanFactory(BeanFactory parentBeanFactory) {
        this.parentBeanFactory = parentBeanFactory;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.customEditors.put(requiredType, propertyEditor);
    }

    public Map getCustomEditors() {
        return this.customEditors;
    }

    public void ignoreDependencyType(Class type) {
        this.ignoreDependencyTypes.add(type);
    }

    public Set getIgnoredDependencyTypes() {
        return this.ignoreDependencyTypes;
    }

    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        this.beanPostProcessors.add(beanPostProcessor);
    }

    public List getBeanPostProcessors() {
        return this.beanPostProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAlias(String beanName, String alias) throws BeanDefinitionStoreException {
        this.logger.debug((Object)("Registering alias '" + alias + "' for bean with name '" + beanName + "'"));
        Map map = this.aliasMap;
        synchronized (map) {
            Object registeredName = this.aliasMap.get(alias);
            if (registeredName != null) {
                throw new BeanDefinitionStoreException("Cannot register alias '" + alias + "' for bean name '" + beanName + "': it's already registered for bean name '" + registeredName + "'");
            }
            this.aliasMap.put(alias, beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSingleton(String beanName, Object singletonObject) throws BeanDefinitionStoreException {
        Map map = this.singletonCache;
        synchronized (map) {
            Object oldObject = this.singletonCache.get(beanName);
            if (oldObject != null) {
                throw new BeanDefinitionStoreException("Could not register object [" + singletonObject + "] under bean name '" + beanName + "': there's already object [" + oldObject + " bound");
            }
            this.addSingleton(beanName, singletonObject);
        }
    }

    protected void addSingleton(String beanName, Object singletonObject) {
        this.singletonCache.put(beanName, singletonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingletons() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Destroying singletons in factory {" + this + "}"));
        }
        Map map = this.singletonCache;
        synchronized (map) {
            HashSet singletonCacheKeys = new HashSet(this.singletonCache.keySet());
            Iterator it = singletonCacheKeys.iterator();
            while (it.hasNext()) {
                this.destroySingleton((String)it.next());
            }
        }
    }

    protected void destroySingleton(String beanName) {
        Object singletonInstance = this.singletonCache.remove(beanName);
        if (singletonInstance != null) {
            this.destroyBean(beanName, singletonInstance);
        }
    }

    protected String transformedBeanName(String name) throws NoSuchBeanDefinitionException {
        String canonicalName;
        if (name == null) {
            throw new NoSuchBeanDefinitionException(name, "Cannot get bean with null name");
        }
        if (name.startsWith(FACTORY_BEAN_PREFIX)) {
            name = name.substring(FACTORY_BEAN_PREFIX.length());
        }
        return (canonicalName = (String)this.aliasMap.get(name)) != null ? canonicalName : name;
    }

    protected boolean isFactoryDereference(String name) {
        return name.startsWith(FACTORY_BEAN_PREFIX);
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        Iterator it = this.customEditors.keySet().iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            bw.registerCustomEditor(clazz, (PropertyEditor)this.customEditors.get(clazz));
        }
    }

    public String[] getSingletonNames(Class type) {
        Set keys = this.singletonCache.keySet();
        HashSet<String> matches = new HashSet<String>();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            Object singletonObject = this.singletonCache.get(name);
            if (type != null && !type.isAssignableFrom(singletonObject.getClass())) continue;
            matches.add(name);
        }
        return matches.toArray(new String[matches.size()]);
    }

    protected Object getObjectForSharedInstance(String name, Object beanInstance) {
        String beanName = this.transformedBeanName(name);
        if (this.isFactoryDereference(name) && !(beanInstance instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(beanName, beanInstance);
        }
        if (beanInstance instanceof FactoryBean) {
            if (!this.isFactoryDereference(name)) {
                FactoryBean factory = (FactoryBean)beanInstance;
                this.logger.debug((Object)("Bean with name '" + beanName + "' is a factory bean"));
                try {
                    beanInstance = factory.getObject();
                }
                catch (BeansException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new BeanCreationException("FactoryBean threw exception on object creation", ex);
                }
                if (beanInstance == null) {
                    throw new FactoryBeanCircularReferenceException("Factory bean '" + beanName + "' returned null object - " + "possible cause: not fully initialized due to circular bean reference");
                }
            } else {
                this.logger.debug((Object)("Calling code asked for FactoryBean instance for name '" + beanName + "'"));
            }
        }
        return beanInstance;
    }

    public RootBeanDefinition getMergedBeanDefinition(String beanName, boolean includingAncestors) throws BeansException {
        try {
            return this.getMergedBeanDefinition(beanName, this.getBeanDefinition(beanName));
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (includingAncestors && this.getParentBeanFactory() instanceof AbstractAutowireCapableBeanFactory) {
                return ((AbstractAutowireCapableBeanFactory)this.getParentBeanFactory()).getMergedBeanDefinition(beanName, true);
            }
            throw ex;
        }
    }

    protected RootBeanDefinition getMergedBeanDefinition(String beanName, BeanDefinition bd) {
        if (bd instanceof RootBeanDefinition) {
            return (RootBeanDefinition)bd;
        }
        if (bd instanceof ChildBeanDefinition) {
            ChildBeanDefinition cbd = (ChildBeanDefinition)bd;
            RootBeanDefinition rbd = new RootBeanDefinition(this.getMergedBeanDefinition(cbd.getParentName(), true));
            for (int i = 0; i < cbd.getPropertyValues().getPropertyValues().length; ++i) {
                rbd.getPropertyValues().addPropertyValue(cbd.getPropertyValues().getPropertyValues()[i]);
            }
            rbd.setSingleton(cbd.isSingleton());
            rbd.setLazyInit(cbd.isLazyInit());
            rbd.setResourceDescription(cbd.getResourceDescription());
            return rbd;
        }
        throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanName, "Definition is neither a RootBeanDefinition nor a ChildBeanDefinition");
    }

    public abstract boolean containsBeanDefinition(String var1);

    public abstract BeanDefinition getBeanDefinition(String var1) throws BeansException;

    protected abstract Object createBean(String var1, RootBeanDefinition var2) throws BeansException;

    protected abstract void destroyBean(String var1, Object var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

