/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;

public abstract class AbstractAutowireCapableBeanFactory
extends AbstractBeanFactory
implements AutowireCapableBeanFactory {
    private final Set disposableInnerBeans = Collections.synchronizedSet(new HashSet());
    static /* synthetic */ Class class$org$springframework$beans$factory$DisposableBean;

    public AbstractAutowireCapableBeanFactory() {
    }

    public AbstractAutowireCapableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public Object autowire(Class beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass, autowireMode, dependencyCheck);
        if (bd.getResolvedAutowireMode() == 3) {
            return this.autowireConstructor(beanClass.getName(), bd).getWrappedInstance();
        }
        Object bean = BeanUtils.instantiateClass(beanClass);
        this.populateBean(bean.getClass().getName(), bd, new BeanWrapperImpl(bean));
        return bean;
    }

    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        if (autowireMode != 1 && autowireMode != 2) {
            throw new IllegalArgumentException("Just constants AUTOWIRE_BY_NAME and AUTOWIRE_BY_TYPE allowed");
        }
        RootBeanDefinition bd = new RootBeanDefinition(existingBean.getClass(), autowireMode, dependencyCheck);
        this.populateBean(existingBean.getClass().getName(), bd, new BeanWrapperImpl(existingBean));
    }

    public Object applyBeanPostProcessorsBeforeInitialization(Object bean, String name) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking BeanPostProcessors before initialization of bean '" + name + "'"));
        }
        Object result = bean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessBeforeInitialization(result, name);
            if (result != null) continue;
            throw new BeanCreationException("postProcessBeforeInitialization method of BeanPostProcessor [" + beanProcessor + "] returned null for bean [" + result + "] with name [" + name + "]");
        }
        return result;
    }

    public Object applyBeanPostProcessorsAfterInitialization(Object bean, String name) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking BeanPostProcessors after initialization of bean '" + name + "'"));
        }
        Object result = bean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessAfterInitialization(result, name);
            if (result != null) continue;
            throw new BeanCreationException("postProcessAfterInitialization method of BeanPostProcessor [" + beanProcessor + "] returned null for bean [" + result + "] with name [" + name + "]");
        }
        return result;
    }

    protected Object createBean(String beanName, RootBeanDefinition mergedBeanDefinition) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating instance of bean '" + beanName + "' with merged definition [" + mergedBeanDefinition + "]"));
        }
        if (mergedBeanDefinition.getDependsOn() != null) {
            for (int i = 0; i < mergedBeanDefinition.getDependsOn().length; ++i) {
                this.getBean(mergedBeanDefinition.getDependsOn()[i]);
            }
        }
        BeanWrapper instanceWrapper = null;
        if (mergedBeanDefinition.getResolvedAutowireMode() == 3 || mergedBeanDefinition.hasConstructorArgumentValues()) {
            instanceWrapper = this.autowireConstructor(beanName, mergedBeanDefinition);
        } else {
            instanceWrapper = new BeanWrapperImpl(mergedBeanDefinition.getBeanClass());
            this.initBeanWrapper(instanceWrapper);
        }
        Object bean = instanceWrapper.getWrappedInstance();
        if (mergedBeanDefinition.isSingleton()) {
            this.addSingleton(beanName, bean);
        }
        this.populateBean(beanName, mergedBeanDefinition, instanceWrapper);
        try {
            if (bean instanceof BeanNameAware) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking setBeanName() on BeanNameAware bean '" + beanName + "'"));
                }
                ((BeanNameAware)bean).setBeanName(beanName);
            }
            if (bean instanceof BeanFactoryAware) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking setBeanFactory() on BeanFactoryAware bean '" + beanName + "'"));
                }
                ((BeanFactoryAware)bean).setBeanFactory(this);
            }
            bean = this.applyBeanPostProcessorsBeforeInitialization(bean, beanName);
            this.invokeInitMethods(beanName, mergedBeanDefinition, bean);
            bean = this.applyBeanPostProcessorsAfterInitialization(bean, beanName);
        }
        catch (BeanCreationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Initialization of bean failed", ex);
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BeanWrapper autowireConstructor(String beanName, RootBeanDefinition mergedBeanDefinition) throws BeansException {
        ConstructorArgumentValues cargs = mergedBeanDefinition.getConstructorArgumentValues();
        ConstructorArgumentValues resolvedValues = new ConstructorArgumentValues();
        int minNrOfArgs = 0;
        if (cargs != null) {
            minNrOfArgs = cargs.getNrOfArguments();
            Iterator it = cargs.getIndexedArgumentValues().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int index = (Integer)entry.getKey();
                if (index < 0) {
                    throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Invalid constructor argument index: " + index);
                }
                if (index > minNrOfArgs) {
                    minNrOfArgs = index + 1;
                }
                String argName = "constructor argument with index " + index;
                ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)entry.getValue();
                Object resolvedValue = this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName, valueHolder.getValue());
                resolvedValues.addIndexedArgumentValue(index, resolvedValue, valueHolder.getType());
            }
            it = cargs.getGenericArgumentValues().iterator();
            while (it.hasNext()) {
                ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)((Object)it.next());
                String argName = "constructor argument";
                Object resolvedValue = this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName, valueHolder.getValue());
                resolvedValues.addGenericArgumentValue(resolvedValue, valueHolder.getType());
            }
        }
        Constructor<?>[] constructors = mergedBeanDefinition.getBeanClass().getConstructors();
        Arrays.sort(constructors, new Comparator(){

            public int compare(Object o1, Object o2) {
                int c1pl = ((Constructor)o1).getParameterTypes().length;
                int c2pl = ((Constructor)o2).getParameterTypes().length;
                return new Integer(c1pl).compareTo(new Integer(c2pl)) * -1;
            }
        });
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.initBeanWrapper(bw);
        Constructor<?> constructorToUse = null;
        Object[] argsToUse = null;
        int minTypeDiffWeight = Integer.MAX_VALUE;
        for (int i = 0; i < constructors.length; ++i) {
            try {
                Constructor<?> constructor = constructors[i];
                if (constructor.getParameterTypes().length < minNrOfArgs) {
                    throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, minNrOfArgs + " constructor arguments specified but no matching constructor found in bean '" + beanName + "' (hint: specify index arguments for simple parameters to avoid type ambiguities)");
                }
                Class[] argTypes = constructor.getParameterTypes();
                Object[] args = new Object[argTypes.length];
                for (int j = 0; j < argTypes.length; ++j) {
                    ConstructorArgumentValues.ValueHolder valueHolder = resolvedValues.getArgumentValue(j, argTypes[j]);
                    if (valueHolder != null) {
                        if (!this.getCustomEditors().isEmpty()) {
                            AbstractAutowireCapableBeanFactory abstractAutowireCapableBeanFactory = this;
                            synchronized (abstractAutowireCapableBeanFactory) {
                                args[j] = bw.doTypeConversionIfNecessary(valueHolder.getValue(), argTypes[j]);
                                continue;
                            }
                        }
                        args[j] = bw.doTypeConversionIfNecessary(valueHolder.getValue(), argTypes[j]);
                        continue;
                    }
                    if (mergedBeanDefinition.getResolvedAutowireMode() != 3) {
                        throw new UnsatisfiedDependencyException(beanName, j, argTypes[j], "Did you specify the correct bean references as generic constructor arguments?");
                    }
                    Map matchingBeans = this.findMatchingBeans(argTypes[j]);
                    if (matchingBeans == null || matchingBeans.size() != 1) {
                        throw new UnsatisfiedDependencyException(beanName, j, argTypes[j], "There are " + matchingBeans.size() + " beans of type [" + argTypes[j] + "] for autowiring constructor. " + "There should have been 1 to be able to autowire constructor of bean '" + beanName + "'.");
                    }
                    args[j] = matchingBeans.values().iterator().next();
                    this.logger.info((Object)("Autowiring by type from bean name '" + beanName + "' via constructor to bean named '" + matchingBeans.keySet().iterator().next() + "'"));
                }
                int typeDiffWeight = this.getTypeDifferenceWeight(argTypes, args);
                if (typeDiffWeight >= minTypeDiffWeight) continue;
                constructorToUse = constructor;
                argsToUse = args;
                minTypeDiffWeight = typeDiffWeight;
                continue;
            }
            catch (BeansException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring constructor [" + constructors[i] + "] of bean '" + beanName + "': could not satisfy dependencies. Detail: " + ex.getMessage()));
                }
                if (i != constructors.length - 1 || constructorToUse != null) continue;
                throw ex;
            }
        }
        if (constructorToUse == null) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Could not resolve matching constructor");
        }
        bw.setWrappedInstance(BeanUtils.instantiateClass(constructorToUse, argsToUse));
        this.logger.info((Object)("Bean '" + beanName + "' instantiated via constructor [" + constructorToUse + "]"));
        return bw;
    }

    private int getTypeDifferenceWeight(Class[] argTypes, Object[] args) {
        int result = 0;
        for (int i = 0; i < argTypes.length; ++i) {
            if (!BeanUtils.isAssignable(argTypes[i], args[i])) {
                return Integer.MAX_VALUE;
            }
            if (args[i] == null) continue;
            Class<?> superClass = args[i].getClass().getSuperclass();
            while (superClass != null) {
                if (argTypes[i].isAssignableFrom(superClass)) {
                    ++result;
                    superClass = superClass.getSuperclass();
                    continue;
                }
                superClass = null;
            }
        }
        return result;
    }

    protected void populateBean(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw) {
        MutablePropertyValues pvs = mergedBeanDefinition.getPropertyValues();
        if (mergedBeanDefinition.getResolvedAutowireMode() == 1 || mergedBeanDefinition.getResolvedAutowireMode() == 2) {
            MutablePropertyValues mpvs = new MutablePropertyValues(pvs);
            if (mergedBeanDefinition.getResolvedAutowireMode() == 1) {
                this.autowireByName(beanName, mergedBeanDefinition, bw, mpvs);
            }
            if (mergedBeanDefinition.getResolvedAutowireMode() == 2) {
                this.autowireByType(beanName, mergedBeanDefinition, bw, mpvs);
            }
            pvs = mpvs;
        }
        this.dependencyCheck(beanName, mergedBeanDefinition, bw, pvs);
        this.applyPropertyValues(beanName, mergedBeanDefinition, bw, pvs);
    }

    protected void autowireByName(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, MutablePropertyValues pvs) {
        String[] propertyNames = this.unsatisfiedObjectProperties(mergedBeanDefinition, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (this.containsBean(propertyName)) {
                Object bean = this.getBean(propertyName);
                pvs.addPropertyValue(propertyName, bean);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added autowiring by name from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + propertyName + "'"));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by name: no matching bean found"));
        }
    }

    protected void autowireByType(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, MutablePropertyValues pvs) {
        String[] propertyNames = this.unsatisfiedObjectProperties(mergedBeanDefinition, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            Class<?> requiredType = bw.getPropertyDescriptor(propertyName).getPropertyType();
            Map matchingBeans = this.findMatchingBeans(requiredType);
            if (matchingBeans != null && matchingBeans.size() == 1) {
                pvs.addPropertyValue(propertyName, matchingBeans.values().iterator().next());
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + matchingBeans.keySet().iterator().next() + "'"));
                continue;
            }
            if (matchingBeans != null && matchingBeans.size() > 1) {
                throw new UnsatisfiedDependencyException(beanName, propertyName, "There are " + matchingBeans.size() + " beans of type [" + requiredType + "] for autowire by type. " + "There should have been 1 to be able to autowire property '" + propertyName + "' of bean '" + beanName + "'.");
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by type: no matching bean found"));
        }
    }

    protected void dependencyCheck(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, PropertyValues pvs) throws UnsatisfiedDependencyException {
        int dependencyCheck = mergedBeanDefinition.getDependencyCheck();
        if (dependencyCheck == 0) {
            return;
        }
        Set ignoreTypes = this.getIgnoredDependencyTypes();
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            boolean unsatisfied;
            if (pds[i].getWriteMethod() == null || ignoreTypes.contains(pds[i].getPropertyType()) || pvs.getPropertyValue(pds[i].getName()) != null) continue;
            boolean isSimple = BeanUtils.isSimpleProperty(pds[i].getPropertyType());
            boolean bl = unsatisfied = dependencyCheck == 3 || isSimple && dependencyCheck == 2 || !isSimple && dependencyCheck == 1;
            if (!unsatisfied) continue;
            throw new UnsatisfiedDependencyException(beanName, pds[i].getName(), null);
        }
    }

    protected String[] unsatisfiedObjectProperties(RootBeanDefinition mergedBeanDefinition, BeanWrapper bw) {
        TreeSet<String> result = new TreeSet<String>();
        Set ignoreTypes = this.getIgnoredDependencyTypes();
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            String name = pds[i].getName();
            if (pds[i].getWriteMethod() == null || BeanUtils.isSimpleProperty(pds[i].getPropertyType()) || ignoreTypes.contains(pds[i].getPropertyType()) || mergedBeanDefinition.getPropertyValues().getPropertyValue(name) != null) continue;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyPropertyValues(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, PropertyValues pvs) throws BeansException {
        block8: {
            if (pvs == null) {
                return;
            }
            MutablePropertyValues deepCopy = new MutablePropertyValues(pvs);
            PropertyValue[] pvals = deepCopy.getPropertyValues();
            for (int i = 0; i < pvals.length; ++i) {
                Object value = this.resolveValueIfNecessary(beanName, mergedBeanDefinition, pvals[i].getName(), pvals[i].getValue());
                PropertyValue pv = new PropertyValue(pvals[i].getName(), value);
                deepCopy.setPropertyValueAt(pv, i);
            }
            try {
                if (!this.getCustomEditors().isEmpty()) {
                    AbstractAutowireCapableBeanFactory i = this;
                    synchronized (i) {
                        bw.setPropertyValues(deepCopy);
                        break block8;
                    }
                }
                bw.setPropertyValues(deepCopy);
            }
            catch (BeansException ex) {
                throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Error setting property values", ex);
            }
        }
    }

    protected Object resolveValueIfNecessary(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, Object value) throws BeansException {
        if (value instanceof AbstractBeanDefinition) {
            String innerBeanName;
            Object bean;
            BeanDefinition bd = (BeanDefinition)value;
            if (bd instanceof AbstractBeanDefinition) {
                ((AbstractBeanDefinition)bd).setSingleton(false);
            }
            if ((bean = this.createBean(innerBeanName = "(inner bean for property '" + beanName + "." + argName + "')", this.getMergedBeanDefinition(innerBeanName, bd))) instanceof DisposableBean) {
                this.disposableInnerBeans.add(bean);
            }
            return this.getObjectForSharedInstance(innerBeanName, bean);
        }
        if (value instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref = (RuntimeBeanReference)value;
            return this.resolveReference(beanName, mergedBeanDefinition, argName, ref);
        }
        if (value instanceof ManagedList) {
            return this.resolveManagedList(beanName, mergedBeanDefinition, argName, (ManagedList)value);
        }
        if (value instanceof ManagedSet) {
            return this.resolveManagedSet(beanName, mergedBeanDefinition, argName, (ManagedSet)value);
        }
        if (value instanceof ManagedMap) {
            ManagedMap mm = (ManagedMap)value;
            return this.resolveManagedMap(beanName, mergedBeanDefinition, argName, mm);
        }
        return value;
    }

    protected Object resolveReference(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, RuntimeBeanReference ref) throws BeansException {
        try {
            this.logger.debug((Object)("Resolving reference from property '" + argName + "' in bean '" + beanName + "' to bean '" + ref.getBeanName() + "'"));
            return this.getBean(ref.getBeanName());
        }
        catch (BeansException ex) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Can't resolve reference to bean '" + ref.getBeanName() + "' while setting property '" + argName + "'", ex);
        }
    }

    protected List resolveManagedList(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, ManagedList ml) throws BeansException {
        ArrayList<Object> resolved = new ArrayList<Object>();
        for (int i = 0; i < ml.size(); ++i) {
            resolved.add(this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName + "[" + i + "]", ml.get(i)));
        }
        return resolved;
    }

    protected Set resolveManagedSet(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, ManagedSet ms) throws BeansException {
        HashSet<Object> resolved = new HashSet<Object>();
        Iterator it = ms.iterator();
        while (it.hasNext()) {
            resolved.add(this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName + "[(set-element)]", it.next()));
        }
        return resolved;
    }

    protected Map resolveManagedMap(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, ManagedMap mm) throws BeansException {
        HashMap resolved = new HashMap();
        Iterator keys = mm.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            resolved.put(key, this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName + "[" + key + "]", mm.get(key)));
        }
        return resolved;
    }

    protected void invokeInitMethods(String beanName, RootBeanDefinition mergedBeanDefinition, Object bean) throws Exception {
        if (bean instanceof InitializingBean) {
            this.logger.debug((Object)("Calling afterPropertiesSet() on bean with beanName '" + beanName + "'"));
            ((InitializingBean)bean).afterPropertiesSet();
        }
        if (mergedBeanDefinition.getInitMethodName() != null) {
            this.logger.debug((Object)("Calling custom init method '" + mergedBeanDefinition.getInitMethodName() + "' on bean with beanName '" + beanName + "'"));
            try {
                bean.getClass().getMethod(mergedBeanDefinition.getInitMethodName(), null).invoke(bean, null);
            }
            catch (InvocationTargetException ex) {
                throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Initialization method '" + mergedBeanDefinition.getInitMethodName() + "' threw exception", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Invocation of initialization method '" + mergedBeanDefinition.getInitMethodName() + "' failed", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingletons() {
        super.destroySingletons();
        Set set = this.disposableInnerBeans;
        synchronized (set) {
            Iterator it = this.disposableInnerBeans.iterator();
            while (it.hasNext()) {
                Object bean = it.next();
                it.remove();
                this.destroyBean("(inner bean of type " + bean.getClass().getName() + ")", bean);
            }
        }
    }

    protected void destroyBean(String beanName, Object bean) {
        int i;
        this.logger.debug((Object)("Retrieving depending beans for bean '" + beanName + "'"));
        String[] dependingBeans = this.getDependingBeanNames(beanName);
        if (dependingBeans != null) {
            for (i = 0; i < dependingBeans.length; ++i) {
                this.destroySingleton(dependingBeans[i]);
            }
        }
        this.logger.debug((Object)("Applying DestructionAwareBeanPostProcessors to bean with name '" + beanName + "'"));
        for (i = this.getBeanPostProcessors().size() - 1; i >= 0; --i) {
            Object beanProcessor = this.getBeanPostProcessors().get(i);
            if (!(beanProcessor instanceof DestructionAwareBeanPostProcessor)) continue;
            ((DestructionAwareBeanPostProcessor)beanProcessor).postProcessBeforeDestruction(bean, beanName);
        }
        if (bean instanceof DisposableBean) {
            this.logger.debug((Object)("Calling destroy() on bean with name '" + beanName + "'"));
            try {
                ((DisposableBean)bean).destroy();
            }
            catch (Exception ex) {
                this.logger.error((Object)("destroy() on bean with name '" + beanName + "' threw an exception"), (Throwable)ex);
            }
        }
        try {
            RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
            if (bd.getDestroyMethodName() != null) {
                this.logger.debug((Object)("Calling custom destroy method '" + bd.getDestroyMethodName() + "' on bean with name '" + beanName + "'"));
                this.invokeCustomDestroyMethod(beanName, bean, bd.getDestroyMethodName());
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            // empty catch block
        }
    }

    protected void invokeCustomDestroyMethod(String beanName, Object bean, String destroyMethodName) {
        Method[] methods = bean.getClass().getMethods();
        Method targetMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(destroyMethodName) || targetMethod != null && methods[i].getParameterTypes().length >= targetMethod.getParameterTypes().length) continue;
            targetMethod = methods[i];
        }
        if (targetMethod == null) {
            this.logger.error((Object)("Couldn't find a method named '" + destroyMethodName + "' on bean with name '" + beanName + "'"));
        } else {
            Class<?>[] paramTypes = targetMethod.getParameterTypes();
            if (paramTypes.length > 1) {
                this.logger.error((Object)("Method '" + destroyMethodName + "' of bean '" + beanName + "' has more than one parameter - not supported as destroy method"));
            } else if (paramTypes.length == 1 && !paramTypes[0].equals(Boolean.TYPE)) {
                this.logger.error((Object)("Method '" + destroyMethodName + "' of bean '" + beanName + "' has a non-boolean parameter - not supported as destroy method"));
            } else {
                Object[] args = new Object[paramTypes.length];
                if (paramTypes.length == 1) {
                    args[0] = Boolean.TRUE;
                }
                try {
                    targetMethod.invoke(bean, args);
                }
                catch (InvocationTargetException ex) {
                    this.logger.error((Object)("Couldn't invoke destroy method '" + destroyMethodName + "' of bean with name '" + beanName + "'"), ex.getTargetException());
                }
                catch (Exception ex) {
                    this.logger.error((Object)("Couldn't invoke destroy method '" + destroyMethodName + "' of bean with name '" + beanName + "'"), (Throwable)ex);
                }
            }
        }
    }

    protected abstract Map findMatchingBeans(Class var1) throws BeansException;

    protected abstract String[] getDependingBeanNames(String var1) throws BeansException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        (class$org$springframework$beans$factory$DisposableBean == null ? (class$org$springframework$beans$factory$DisposableBean = AbstractAutowireCapableBeanFactory.class$("org.springframework.beans.factory.DisposableBean")) : class$org$springframework$beans$factory$DisposableBean).getName();
    }
}

