/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanCircularReferenceException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.StringUtils;

public class DefaultListableBeanFactory
extends AbstractBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry {
    private boolean allowBeanDefinitionOverriding = true;
    private Map beanDefinitionMap = new HashMap();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    public String[] getBeanDefinitionNames() {
        return this.getBeanDefinitionNames(null);
    }

    public String[] getBeanDefinitionNames(Class type) {
        Set keys = this.beanDefinitionMap.keySet();
        HashSet<String> matches = new HashSet<String>();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            if (type != null && !type.isAssignableFrom(this.getMergedBeanDefinition(name, false).getBeanClass())) continue;
            matches.add(name);
        }
        matches.addAll(Arrays.asList(this.getSingletonNames(type)));
        return matches.toArray(new String[matches.size()]);
    }

    public boolean containsBeanDefinition(String name) {
        return this.beanDefinitionMap.containsKey(name);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        String[] beanNames = this.getBeanDefinitionNames(type);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < beanNames.length; ++i) {
            if (!includePrototypes && !this.isSingleton(beanNames[i])) continue;
            result.put(beanNames[i], this.getBean(beanNames[i]));
        }
        if (includeFactoryBeans) {
            String[] factoryNames = this.getBeanDefinitionNames(class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean);
            for (int i = 0; i < factoryNames.length; ++i) {
                try {
                    Object createdObject;
                    FactoryBean factory = (FactoryBean)this.getBean("&" + factoryNames[i]);
                    Class objectType = factory.getObjectType();
                    if ((objectType != null || !factory.isSingleton()) && (!factory.isSingleton() && !includePrototypes || objectType == null || !type.isAssignableFrom(objectType)) || !type.isInstance(createdObject = this.getBean(factoryNames[i]))) continue;
                    result.put(factoryNames[i], createdObject);
                    continue;
                }
                catch (FactoryBeanCircularReferenceException ex) {
                    this.logger.debug((Object)"Ignoring exception on FactoryBean type check", (Throwable)ex);
                }
            }
        }
        return result;
    }

    public void preInstantiateSingletons() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Pre-instantiating singletons in factory [" + this + "]"));
        }
        String[] beanNames = this.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            RootBeanDefinition bd;
            if (!this.containsBeanDefinition(beanNames[i]) || !(bd = this.getMergedBeanDefinition(beanNames[i], false)).isSingleton() || bd.isLazyInit()) continue;
            if ((class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(bd.getBeanClass())) {
                FactoryBean factory = (FactoryBean)this.getBean("&" + beanNames[i]);
                if (!factory.isSingleton()) continue;
                this.getBean(beanNames[i]);
                continue;
            }
            this.getBean(beanNames[i]);
        }
    }

    public void registerBeanDefinition(String name, AbstractBeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        try {
            beanDefinition.validate();
        }
        catch (BeanDefinitionValidationException ex) {
            throw new BeanDefinitionStoreException("Validation of bean definition with name '" + name + "' failed", ex);
        }
        Object oldBeanDefinition = this.beanDefinitionMap.get(name);
        if (oldBeanDefinition != null) {
            if (!this.allowBeanDefinitionOverriding) {
                throw new BeanDefinitionStoreException("Cannot register bean definition [" + beanDefinition + "] for bean '" + name + "': there's already [" + oldBeanDefinition + "] bound");
            }
            this.logger.info((Object)("Overriding bean definition for bean '" + name + "': replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]"));
        }
        this.beanDefinitionMap.put(name, beanDefinition);
    }

    public AbstractBeanDefinition getBeanDefinition(String beanName) throws BeansException {
        AbstractBeanDefinition bd = (AbstractBeanDefinition)this.beanDefinitionMap.get(beanName);
        if (bd == null) {
            throw new NoSuchBeanDefinitionException(beanName, this.toString());
        }
        return bd;
    }

    protected String[] getDependingBeanNames(String beanName) throws BeansException {
        ArrayList<String> dependingBeanNames = new ArrayList<String>();
        String[] beanDefinitionNames = this.getBeanDefinitionNames();
        for (int i = 0; i < beanDefinitionNames.length; ++i) {
            List<String> dependsOn;
            RootBeanDefinition bd;
            if (!this.containsBeanDefinition(beanDefinitionNames[i]) || (bd = this.getMergedBeanDefinition(beanDefinitionNames[i], false)).getDependsOn() == null || !(dependsOn = Arrays.asList(bd.getDependsOn())).contains(beanName)) continue;
            this.logger.debug((Object)("Found depending bean '" + beanDefinitionNames[i] + "' for bean '" + beanName + "'"));
            dependingBeanNames.add(beanDefinitionNames[i]);
        }
        return dependingBeanNames.toArray(new String[dependingBeanNames.size()]);
    }

    protected Map findMatchingBeans(Class requiredType) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors(this, requiredType, true, true);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + " defining beans [" + StringUtils.arrayToDelimitedString(this.getBeanDefinitionNames(), ",") + "]");
        if (this.getParentBeanFactory() == null) {
            sb.append("; Root of BeanFactory hierarchy");
        } else {
            sb.append("; parent=<" + this.getParentBeanFactory() + ">");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

