/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.access;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ContextBeanFactoryReference
implements BeanFactoryReference {
    private ApplicationContext applicationContext;

    public ContextBeanFactoryReference(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public BeanFactory getFactory() {
        ApplicationContext retval = this.applicationContext;
        if (retval == null) {
            throw new IllegalStateException("ApplicationContext owned by this BeanFactoryReference has been released");
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.applicationContext != null) {
            ApplicationContext savedCtx;
            ContextBeanFactoryReference contextBeanFactoryReference = this;
            synchronized (contextBeanFactoryReference) {
                savedCtx = this.applicationContext;
                this.applicationContext = null;
            }
            if (savedCtx != null && savedCtx instanceof ConfigurableApplicationContext) {
                ((ConfigurableApplicationContext)savedCtx).close();
            }
        }
    }
}

