/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import org.springframework.jms.JmsException;
import org.springframework.jms.connection.ConnectionHolder;
import org.springframework.jms.connection.JmsTransactionObject;
import org.springframework.jms.support.JmsUtils;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JmsTransactionManager
extends AbstractPlatformTransactionManager {
    private ConnectionFactory connectionFactory;

    public JmsTransactionManager() {
        this.setTransactionSynchronization(2);
    }

    public JmsTransactionManager(ConnectionFactory connectionFactory) {
        this();
        this.connectionFactory = connectionFactory;
        this.afterPropertiesSet();
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void afterPropertiesSet() {
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory is required");
        }
    }

    protected Connection createConnection() throws JMSException {
        return this.getConnectionFactory().createConnection();
    }

    protected Session createSession(Connection con) throws JMSException {
        return con.createSession(true, 1);
    }

    protected JmsException convertJmsAccessException(JMSException ex) {
        return JmsUtils.convertJmsAccessException(ex);
    }

    protected Object doGetTransaction() {
        JmsTransactionObject txObject = new JmsTransactionObject();
        txObject.setConnectionHolder((ConnectionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getConnectionFactory())));
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        JmsTransactionObject txObject = (JmsTransactionObject)transaction;
        return txObject.getConnectionHolder() != null;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("JMS does not support an isolation level concept");
        }
        JmsTransactionObject txObject = (JmsTransactionObject)transaction;
        Connection con = null;
        Session session = null;
        try {
            con = this.createConnection();
            session = this.createSession(con);
            txObject.setConnectionHolder(new ConnectionHolder(con, session));
            txObject.getConnectionHolder().setSynchronizedWithTransaction(true);
            if (definition.getTimeout() != -1) {
                txObject.getConnectionHolder().setTimeoutInSeconds(definition.getTimeout());
            }
            TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)txObject.getConnectionHolder()));
        }
        catch (JMSException ex) {
            JmsUtils.closeSession(session);
            JmsUtils.closeConnection(con);
            throw this.convertJmsAccessException(ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        JmsTransactionObject txObject = (JmsTransactionObject)transaction;
        txObject.setConnectionHolder(null);
        return TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        ConnectionHolder conHolder = (ConnectionHolder)((Object)suspendedResources);
        TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)conHolder));
    }

    protected void doCommit(DefaultTransactionStatus status) {
        JmsTransactionObject txObject = (JmsTransactionObject)status.getTransaction();
        try {
            txObject.getConnectionHolder().getSession().commit();
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        JmsTransactionObject txObject = (JmsTransactionObject)status.getTransaction();
        try {
            txObject.getConnectionHolder().getSession().rollback();
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        JmsTransactionObject txObject = (JmsTransactionObject)status.getTransaction();
        txObject.getConnectionHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        JmsTransactionObject txObject = (JmsTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
        txObject.getConnectionHolder().clear();
        JmsUtils.closeSession(txObject.getConnectionHolder().getSession());
        JmsUtils.closeConnection(txObject.getConnectionHolder().getConnection());
    }
}

