/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.util.StringUtils;

public class ResourceBundleMessageSource
extends AbstractMessageSource {
    private String[] basenames;
    private final Map cachedMessageFormats = new HashMap();

    public void setBasename(String basename) {
        this.setBasenames(new String[]{basename});
    }

    public void setBasenames(String[] basenames) {
        this.basenames = basenames;
    }

    protected final MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat messageFormat = null;
        for (int i = 0; messageFormat == null && i < this.basenames.length; ++i) {
            messageFormat = this.resolve(this.basenames[i], code, locale);
        }
        return messageFormat;
    }

    protected MessageFormat resolve(String basename, String code, Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(basename, locale, Thread.currentThread().getContextClassLoader());
            try {
                return this.getMessageFormat(bundle, code, locale);
            }
            catch (MissingResourceException ex) {
                return null;
            }
        }
        catch (MissingResourceException ex) {
            this.logger.warn((Object)("ResourceBundle [" + basename + "] not found for MessageSource: " + ex.getMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageFormat getMessageFormat(ResourceBundle bundle, String code, Locale locale) throws MissingResourceException {
        Map map = this.cachedMessageFormats;
        synchronized (map) {
            MessageFormat result;
            HashMap codeMap = (HashMap)this.cachedMessageFormats.get(bundle);
            HashMap<Locale, MessageFormat> localeMap = null;
            if (codeMap != null && (localeMap = (HashMap<Locale, MessageFormat>)codeMap.get(code)) != null && (result = (MessageFormat)localeMap.get(locale)) != null) {
                return result;
            }
            String msg = bundle.getString(code);
            if (msg != null) {
                if (codeMap == null) {
                    codeMap = new HashMap();
                    this.cachedMessageFormats.put(bundle, codeMap);
                }
                if (localeMap == null) {
                    localeMap = new HashMap<Locale, MessageFormat>();
                    codeMap.put(code, localeMap);
                }
                MessageFormat result2 = this.createMessageFormat(msg, locale);
                localeMap.put(locale, result2);
                return result2;
            }
            return null;
        }
    }

    public String toString() {
        return this.getClass().getName() + ": basenames=[" + StringUtils.arrayToCommaDelimitedString((Object[])this.basenames) + "]";
    }
}

