/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.beans.PropertyEditorSupport;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.UrlResource;

public class ResourceEditor
extends PropertyEditorSupport {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";

    public void setAsText(String text) throws IllegalArgumentException {
        if (text.startsWith(CLASSPATH_URL_PREFIX)) {
            this.setValue(new ClassPathResource(text.substring(CLASSPATH_URL_PREFIX.length())));
        }
        try {
            URL url = new URL(text);
            this.setValue(new UrlResource(url));
        }
        catch (MalformedURLException ex) {
            this.setValue(new ClassPathResource(text));
        }
    }
}

