/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.context.support.AbstractNestingMessageSource;
import org.springframework.util.StringUtils;

public class ResourceBundleMessageSource
extends AbstractNestingMessageSource {
    private String[] basenames;

    public void setBasename(String basename) {
        this.setBasenames(new String[]{basename});
    }

    public void setBasenames(String[] basenames) {
        this.basenames = basenames;
    }

    protected String resolve(String code, Locale locale) {
        String msg = null;
        for (int i = 0; msg == null && i < this.basenames.length; ++i) {
            String basename = this.basenames[i];
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(basename, locale, Thread.currentThread().getContextClassLoader());
                try {
                    msg = bundle.getString(code);
                }
                catch (MissingResourceException ex) {
                    msg = null;
                }
                continue;
            }
            catch (MissingResourceException ex) {
                this.logger.warn((Object)("No ResourceBundle found for MessageSource: " + ex.getMessage()));
                msg = null;
            }
        }
        return msg;
    }

    public String toString() {
        return this.getClass().getName() + " with basenames [" + StringUtils.arrayToCommaDelimitedString(this.basenames) + "]";
    }
}

