/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PropertiesPersister;

public abstract class PropertyResourceConfigurer
implements BeanFactoryPostProcessor,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private Properties properties;
    private Resource[] locations;
    private String fileEncoding;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();
    private boolean ignoreResourceNotFound = false;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setLocation(Resource location) {
        this.locations = new Resource[]{location};
    }

    public void setLocations(Resource[] locations) {
        this.locations = locations;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister;
    }

    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        this.ignoreResourceNotFound = ignoreResourceNotFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Properties mergedProps = new Properties();
        if (this.properties != null) {
            Enumeration<?> en = this.properties.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                mergedProps.setProperty(key, this.properties.getProperty(key));
            }
        }
        if (this.locations != null) {
            for (int i = 0; i < this.locations.length; ++i) {
                Resource location = this.locations[i];
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loading properties from " + location + ""));
                }
                try {
                    InputStream is = location.getInputStream();
                    try {
                        if (this.fileEncoding != null) {
                            this.propertiesPersister.load(mergedProps, (Reader)new InputStreamReader(is, this.fileEncoding));
                            continue;
                        }
                        this.propertiesPersister.load(mergedProps, is);
                        continue;
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    String msg = "Could not load properties from " + location;
                    if (this.ignoreResourceNotFound) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn((Object)(msg + ": " + ex.getMessage()));
                        continue;
                    }
                    throw new BeanInitializationException(msg, ex);
                }
            }
        }
        this.processProperties(beanFactory, mergedProps);
    }

    protected void convertProperties(Properties props) {
        Enumeration<?> propertyNames = props.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String convertedValue;
            String propertyName = (String)propertyNames.nextElement();
            String propertyValue = props.getProperty(propertyName);
            if (ObjectUtils.nullSafeEquals((Object)propertyValue, (Object)(convertedValue = this.convertPropertyValue(propertyValue)))) continue;
            props.setProperty(propertyName, convertedValue);
        }
    }

    protected String convertPropertyValue(String originalValue) {
        return originalValue;
    }

    protected abstract void processProperties(ConfigurableListableBeanFactory var1, Properties var2) throws BeansException;
}

