/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.support.SortDefinition;

public class PropertyComparator
implements Comparator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final SortDefinition sortDefinition;
    private final Map cachedBeanWrappers = new HashMap();

    public PropertyComparator(SortDefinition sortDefinition) {
        this.sortDefinition = sortDefinition;
    }

    public int compare(Object o1, Object o2) {
        int result;
        Object v1 = this.getPropertyValue(o1);
        Object v2 = this.getPropertyValue(o2);
        if (this.sortDefinition.isIgnoreCase() && v1 instanceof String && v2 instanceof String) {
            v1 = ((String)v1).toLowerCase();
            v2 = ((String)v2).toLowerCase();
        }
        try {
            result = v1 != null ? (v2 != null ? ((Comparable)v1).compareTo(v2) : -1) : (v2 != null ? 1 : 0);
        }
        catch (RuntimeException ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Could not sort objects [" + o1 + "] and [" + o2 + "]"), (Throwable)ex);
            }
            return 0;
        }
        return this.sortDefinition.isAscending() ? result : -result;
    }

    private Object getPropertyValue(Object obj) {
        BeanWrapper bw = (BeanWrapper)this.cachedBeanWrappers.get(obj);
        if (bw == null) {
            bw = new BeanWrapperImpl(obj);
            this.cachedBeanWrappers.put(obj, bw);
        }
        try {
            return bw.getPropertyValue(this.sortDefinition.getProperty());
        }
        catch (BeansException ex) {
            this.logger.info((Object)"PropertyComparator could not access property - treating as null for sorting", (Throwable)((Object)ex));
            return null;
        }
    }

    public static void sort(List source, SortDefinition sortDefinition) throws BeansException {
        Collections.sort(source, new PropertyComparator(sortDefinition));
    }

    public static void sort(Object[] source, SortDefinition sortDefinition) throws BeansException {
        Arrays.sort(source, new PropertyComparator(sortDefinition));
    }
}

