/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import org.springframework.beans.InvalidPropertyValuesException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.ErrorCoded;
import org.springframework.core.HasRootCause;

public class ErrorCodedPropertyVetoException
extends PropertyVetoException
implements ErrorCoded,
HasRootCause {
    public static final String TYPE_MISMATCH_ERROR_CODE = "typeMismatch";
    private static final String METHOD_INVOCATION_ERROR_CODE = "methodInvocation";
    private String errorCode;
    private Throwable rootCause;

    public ErrorCodedPropertyVetoException(String mesg, PropertyChangeEvent e, String errorCode) {
        super(mesg, e);
        this.errorCode = errorCode;
    }

    ErrorCodedPropertyVetoException(String mesg, PropertyChangeEvent e) {
        super(mesg, e);
    }

    ErrorCodedPropertyVetoException(PropertyVetoException ex) {
        super(ex.getMessage(), ex.getPropertyChangeEvent());
        if (ex instanceof ErrorCoded) {
            this.errorCode = ((ErrorCoded)((Object)ex)).getErrorCode();
        }
        this.rootCause = ex;
    }

    ErrorCodedPropertyVetoException(TypeMismatchException ex) {
        super(ex.getMessage(), ex.getPropertyChangeEvent());
        this.rootCause = ex.getRootCause();
        this.errorCode = TYPE_MISMATCH_ERROR_CODE;
    }

    ErrorCodedPropertyVetoException(MethodInvocationException ex) {
        super(ex.getMessage(), ex.getPropertyChangeEvent());
        this.rootCause = ex.getRootCause();
        this.errorCode = METHOD_INVOCATION_ERROR_CODE;
    }

    ErrorCodedPropertyVetoException(Object source, InvalidPropertyValuesException.MissingFieldException ex) {
        super(ex.getMessage(), new PropertyChangeEvent(source, ex.getField(), null, null));
        this.errorCode = ex.getErrorCode();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String toString() {
        return "ErrorCodedPropertyVetoException: message=[" + this.getMessage() + "]; errorCode=[" + this.getErrorCode() + "]";
    }
}

