/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy.target;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.TargetSourceCreator;
import org.springframework.aop.target.AbstractPrototypeBasedTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public abstract class AbstractPrototypeBasedTargetSourceCreator
implements TargetSourceCreator {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public final TargetSource getTargetSource(Object bean, String beanName, BeanFactory factory) {
        AbstractPrototypeBasedTargetSource prototypeTargetSource = this.createPrototypeTargetSource(bean, beanName, factory);
        if (prototypeTargetSource == null) {
            return null;
        }
        if (!(factory instanceof ConfigurableListableBeanFactory)) {
            this.logger.warn((Object)"Cannot do auto TargetSource creation with a BeanFactory that doesn't implement ConfigurableListableBeanFactory");
            return null;
        }
        this.logger.debug((Object)"Configuring AbstractPrototypeBasedTargetSource");
        ConfigurableListableBeanFactory listableFactory = (ConfigurableListableBeanFactory)factory;
        BeanDefinition definition = listableFactory.getBeanDefinition(beanName);
        DefaultListableBeanFactory beanFactory2 = new DefaultListableBeanFactory(factory);
        beanFactory2.registerBeanDefinition(beanName, definition);
        prototypeTargetSource.setTargetBeanName(beanName);
        prototypeTargetSource.setBeanFactory((BeanFactory)beanFactory2);
        return prototypeTargetSource;
    }

    protected abstract AbstractPrototypeBasedTargetSource createPrototypeTargetSource(Object var1, String var2, BeanFactory var3);
}

